/*
 * Decompiled with CFR 0.152.
 */
package surfaceplot;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import ij.IJ;
import ij3d.Volume;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public final class SurfacePlot
extends Shape3D {
    private Volume volume;
    private int slice = 1;
    private float pw = 1.0f;
    private float ph = 1.0f;
    private int maxVal = -1;
    private float maxZ = -1.0f;
    private float zFactor = 1.0f;
    private Color3f color = null;
    private IndexedQuadArray[] geometry;
    private Appearance appearance;

    public SurfacePlot(Volume volume, final Color3f color3f, float f, final int n) {
        this.volume = volume;
        this.slice = n;
        this.color = color3f;
        this.pw = (float)this.volume.pw;
        this.ph = (float)this.volume.ph;
        this.calculateMax();
        this.calculateZFactor();
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.geometry = new IndexedQuadArray[this.volume.zDim];
        this.geometry[n] = this.createGeometry(n, color3f);
        this.appearance = SurfacePlot.createAppearance(f);
        this.setGeometry((Geometry)this.geometry[n]);
        this.setAppearance(this.appearance);
        new Thread(){

            public void run() {
                for (int i = 0; i < ((SurfacePlot)SurfacePlot.this).volume.zDim; ++i) {
                    if (i == n) continue;
                    ((SurfacePlot)SurfacePlot.this).geometry[i] = SurfacePlot.this.createGeometry(i, color3f);
                    IJ.showProgress((int)(i + 1), (int)((SurfacePlot)SurfacePlot.this).volume.zDim);
                }
            }
        }.start();
    }

    public void setSlice(int n) {
        this.slice = n;
        this.setGeometry((Geometry)this.geometry[n - 1]);
    }

    public void setTransparency(float f) {
        TransparencyAttributes transparencyAttributes = this.appearance.getTransparencyAttributes();
        int n = f == 0.0f ? 4 : 0;
        transparencyAttributes.setTransparencyMode(n);
        transparencyAttributes.setTransparency(f);
    }

    public void setChannels(boolean[] blArray) {
        if (!this.volume.setChannels(blArray)) {
            return;
        }
        this.calculateMax();
        this.calculateZFactor();
        this.geometry[this.slice] = this.createGeometry(this.slice, this.color);
        this.setGeometry((Geometry)this.geometry[this.slice]);
        new Thread(){

            public void run() {
                for (int i = 0; i < ((SurfacePlot)SurfacePlot.this).volume.zDim; ++i) {
                    if (i == SurfacePlot.this.slice) continue;
                    ((SurfacePlot)SurfacePlot.this).geometry[i] = SurfacePlot.this.createGeometry(i, SurfacePlot.this.color);
                    IJ.showProgress((int)(i + 1), (int)((SurfacePlot)SurfacePlot.this).volume.zDim);
                }
            }
        }.start();
    }

    public void setColor(Color3f color3f) {
        for (int i = 0; i < this.geometry.length; ++i) {
            int n = this.geometry[i].getVertexCount();
            Color3f[] color3fArray = new Color3f[n];
            Point3f point3f = new Point3f();
            for (int j = 0; j < n; ++j) {
                this.geometry[i].getCoordinate(j, point3f);
                color3fArray[j] = color3f != null ? color3f : new Color3f(Color.getHSBColor(point3f.z / this.maxZ, 1.0f, 1.0f));
            }
            this.geometry[i].setColors(0, color3fArray);
        }
    }

    public void setShaded(boolean bl) {
        PolygonAttributes polygonAttributes = this.appearance.getPolygonAttributes();
        if (bl) {
            polygonAttributes.setPolygonMode(2);
        } else {
            polygonAttributes.setPolygonMode(1);
        }
    }

    void calculateMinMaxCenterPoint(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        point3d.x = 0.0;
        point3d.y = 0.0;
        point3d.z = 0.0;
        point3d2.x = (float)this.volume.xDim * this.pw;
        point3d2.y = (float)this.volume.yDim * this.ph;
        point3d2.z = this.maxZ;
        point3d3.x = point3d2.x / 2.0;
        point3d3.y = point3d2.y / 2.0;
        point3d3.z = point3d2.z / 2.0;
    }

    private void calculateMax() {
        this.maxVal = 0;
        for (int i = 0; i < this.volume.zDim; ++i) {
            for (int j = 0; j < this.volume.yDim; ++j) {
                for (int k = 0; k < this.volume.xDim; ++k) {
                    int n = this.volume.load(k, j, i);
                    if (n <= this.maxVal) continue;
                    this.maxVal = n;
                }
            }
        }
    }

    private void calculateZFactor() {
        float f = (float)this.volume.xDim * this.pw;
        float f2 = (float)this.volume.yDim * this.ph;
        this.maxZ = f > f2 ? f : f2;
        this.zFactor = this.maxZ / (float)this.maxVal;
    }

    private static Appearance createAppearance(float f) {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(3);
        polygonAttributes.setPolygonMode(2);
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polygonAttributes);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setShadeModel(3);
        appearance.setColoringAttributes(coloringAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        int n = f == 0.0f ? 4 : 0;
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        transparencyAttributes.setTransparencyMode(n);
        transparencyAttributes.setTransparency(f);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Material material = new Material();
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.5f, 0.5f, 0.5f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    private IndexedQuadArray createGeometry(int n, Color3f color3f) {
        int n2 = (this.volume.xDim - 1) * (this.volume.yDim - 1);
        int n3 = this.volume.xDim * this.volume.yDim;
        int n4 = n2 * 4;
        IndexedQuadArray indexedQuadArray = new IndexedQuadArray(n3, 7, n4);
        Point3f[] point3fArray = new Point3f[n3];
        Color3f[] color3fArray = new Color3f[n3];
        for (int i = 0; i < n3; ++i) {
            float f = this.ph * (float)(i / this.volume.xDim);
            float f2 = this.pw * (float)(i % this.volume.yDim);
            float f3 = this.zFactor * (float)this.volume.load(i % this.volume.xDim, i / this.volume.yDim, n);
            point3fArray[i] = new Point3f(f2, f, f3);
            color3fArray[i] = color3f != null ? color3f : new Color3f(Color.getHSBColor(f3 / this.maxZ, 1.0f, 1.0f));
        }
        indexedQuadArray.setCoordinates(0, point3fArray);
        indexedQuadArray.setColors(0, color3fArray);
        int[] nArray = new int[n4];
        int n5 = 0;
        for (int i = 0; i < this.volume.yDim - 1; ++i) {
            for (int j = 0; j < this.volume.xDim - 1; ++j) {
                nArray[n5++] = i * this.volume.xDim + j;
                nArray[n5++] = (i + 1) * this.volume.xDim + j;
                nArray[n5++] = (i + 1) * this.volume.xDim + j + 1;
                nArray[n5++] = i * this.volume.xDim + j + 1;
            }
        }
        indexedQuadArray.setCoordinateIndices(0, nArray);
        indexedQuadArray.setColorIndices(0, nArray);
        GeometryInfo geometryInfo = new GeometryInfo((GeometryArray)indexedQuadArray);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        IndexedQuadArray indexedQuadArray2 = (IndexedQuadArray)geometryInfo.getIndexedGeometryArray();
        indexedQuadArray2.setCapability(3);
        indexedQuadArray2.setCapability(8);
        indexedQuadArray2.setCapability(18);
        return indexedQuadArray2;
    }
}

