/*
 * Decompiled with CFR 0.152.
 */
package textureByRef;

import com.sun.j3d.utils.pickfast.PickCanvas;
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector4f;

public class Texture_By_Ref
implements PlugInFilter,
ImageListener,
MouseMotionListener,
MouseListener {
    private static final int TEX_MODE = 1;
    private static final int COMP_TYPE = 10;
    private static final boolean BY_REF = true;
    private static final boolean Y_UP = true;
    private Image3DUniverse univ;
    private ByteProcessor bProcessor;
    private ImageComponent2D bComp;
    private ImageComponent2D.Updater updater;
    private ImagePlus imp;
    private int w = 256;
    private int h = 256;
    private static final int r = 5;
    private boolean doDraw = false;

    public static void main(String[] stringArray) {
        new ImageJ();
        ImagePlus imagePlus = IJ.openImage((String)"/home/bene/PhD/brains/template.tif");
        imagePlus = new ImagePlus("Slice 20", imagePlus.getStack().getProcessor(20));
        imagePlus.show();
        IJ.runPlugIn((String)"textureByRef.Texture_By_Ref", (String)"");
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.imp.getStackSize() > 1 || !Texture_By_Ref.isPow2(this.imp.getWidth()) || !Texture_By_Ref.isPow2(this.imp.getHeight())) {
            IJ.error((String)"Only one slice allowed, whose dimensions must be a power of 2");
            return;
        }
        this.createImage();
        this.univ = new Image3DUniverse();
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)this.createShape());
        branchGroup.compile();
        this.univ.getScene().addChild((Node)branchGroup);
        this.univ.show();
        this.univ.getCanvas().addMouseListener((MouseListener)this);
        this.univ.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.updater = new ImageUpdater();
        ImagePlus.addImageListener((ImageListener)this);
        this.imp.show();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.doDraw) {
            return;
        }
        OvalRoi ovalRoi = new OvalRoi(mouseEvent.getX() - 5, mouseEvent.getY() - 5, 10, 10);
        Polygon polygon = ovalRoi.getPolygon();
        int n = polygon.npoints;
        Polygon polygon2 = new Polygon(new int[n], new int[n], n);
        for (int i = 0; i < n; ++i) {
            Point3d point3d = this.getPickPoint(polygon.xpoints[i], polygon.ypoints[i]);
            if (point3d == null) continue;
            polygon2.xpoints[i] = (int)Math.round(point3d.x);
            polygon2.ypoints[i] = (int)Math.round(point3d.y);
        }
        this.bProcessor.fillPolygon(polygon2);
        this.imp.updateAndDraw();
    }

    private final Point3d getPickPoint(int n, int n2) {
        PickCanvas pickCanvas = new PickCanvas(this.univ.getCanvas(), this.univ.getScene());
        pickCanvas.setMode(2);
        pickCanvas.setFlags(8);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(n, n2);
        try {
            PickInfo[] pickInfoArray = pickCanvas.pickAllSorted();
            if (pickInfoArray == null || pickInfoArray.length == 0) {
                return null;
            }
            int n3 = 0;
            if (n3 < pickInfoArray.length) {
                return pickInfoArray[n3].getClosestIntersectionPoint();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = Toolbar.getToolId();
        this.doDraw = n == 10 || n == 15 || n == 16 || n == 17 || n == 18 || n == 19 || n == 20 || n == 21 || n == 22;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void imageOpened(ImagePlus imagePlus) {
    }

    public void imageClosed(ImagePlus imagePlus) {
    }

    public void imageUpdated(ImagePlus imagePlus) {
        if (imagePlus == this.imp) {
            this.bComp.updateData(this.updater, 0, 0, this.w, this.h);
        }
    }

    public Appearance createAppearance() {
        Appearance appearance = new Appearance();
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(6);
        textureAttributes.setCombineRgbMode(1);
        textureAttributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(textureAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.1f);
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setTransparencyMode(2);
        appearance.setTransparencyAttributes(transparencyAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        appearance.setPolygonAttributes(polygonAttributes);
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setCapability(1);
        coloringAttributes.setShadeModel(1);
        coloringAttributes.setColor(1.0f, 1.0f, 1.0f);
        appearance.setColoringAttributes(coloringAttributes);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(1);
        renderingAttributes.setAlphaTestValue(0.1f);
        renderingAttributes.setAlphaTestFunction(6);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setTexture(this.getTexture());
        appearance.setTexCoordGeneration(this.getTg());
        return appearance;
    }

    public Shape3D createShape() {
        Shape3D shape3D = new Shape3D((Geometry)this.createGeometry(), this.createAppearance());
        return shape3D;
    }

    public BufferedImage createImage() {
        this.bProcessor = (ByteProcessor)this.imp.getProcessor();
        byte[] byArray = (byte[])this.bProcessor.getPixels();
        IndexColorModel indexColorModel = Texture_By_Ref.getDefaultColorModel();
        SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(this.w, this.h);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, this.w * this.h, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    private static IndexColorModel getDefaultColorModel() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public Texture getTexture() {
        Texture2D texture2D = new Texture2D(1, 1, this.w, this.h);
        this.bComp = new ImageComponent2D(10, this.w, this.h, true, true);
        this.bComp.setCapability(3);
        this.bComp.set(this.createImage());
        texture2D.setImage(0, (ImageComponent)this.bComp);
        texture2D.setEnable(true);
        texture2D.setMinFilter(3);
        texture2D.setMagFilter(3);
        texture2D.setBoundaryModeS(2);
        texture2D.setBoundaryModeT(2);
        return texture2D;
    }

    public TexCoordGeneration getTg() {
        float f = (float)(1.0 / (double)this.w);
        float f2 = (float)(1.0 / (double)this.h);
        TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
        texCoordGeneration.setPlaneS(new Vector4f(f, 0.0f, 0.0f, 0.0f));
        texCoordGeneration.setPlaneT(new Vector4f(0.0f, f2, 0.0f, 0.0f));
        return texCoordGeneration;
    }

    public GeometryArray createGeometry() {
        QuadArray quadArray = new QuadArray(4, 5);
        Point3f[] point3fArray = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f((float)this.w, 0.0f, 0.0f), new Point3f((float)this.w, (float)this.h, 0.0f), new Point3f(0.0f, (float)this.h, 0.0f)};
        Color3f[] color3fArray = new Color3f[]{new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f)};
        quadArray.setCoordinates(0, point3fArray);
        quadArray.setColors(0, color3fArray);
        return quadArray;
    }

    private static final int nextPow2(int n) {
        int n2;
        for (n2 = 2; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private static final boolean isPow2(int n) {
        int n2 = Texture_By_Ref.nextPow2(n);
        return n == n2;
    }

    private class ImageUpdater
    implements ImageComponent2D.Updater {
        private ImageUpdater() {
        }

        public void updateData(ImageComponent2D imageComponent2D, int n, int n2, int n3, int n4) {
        }
    }
}

