/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.ComputeCurvatures;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.SearchThread;
import tracing.TracerThread;

public class Albert_Test
implements PlugIn {
    public void run(String string) {
        File file;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.error((String)"No current image to use.");
            return;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        if (imagePlus.getType() != 0 && imagePlus.getType() != 3) {
            IJ.error((String)"This test only works on 8 bit images");
            return;
        }
        Random random = new Random();
        int n4 = random.nextInt(n);
        int n5 = random.nextInt(n2);
        int n6 = random.nextInt(n3);
        int n7 = random.nextInt(n);
        int n8 = random.nextInt(n2);
        int n9 = random.nextInt(n3);
        n4 = 319;
        n5 = 263;
        n6 = 39;
        n7 = 186;
        n8 = 48;
        n9 = 29;
        boolean bl = true;
        Calibration calibration = imagePlus.getCalibration();
        double d = 1.0;
        if (calibration != null) {
            d = Math.min(Math.abs(calibration.pixelWidth), Math.min(Math.abs(calibration.pixelHeight), Math.abs(calibration.pixelDepth)));
        }
        ComputeCurvatures computeCurvatures = null;
        System.out.println("Calculating Gaussian...");
        computeCurvatures = new ComputeCurvatures(imagePlus, d, null, calibration != null);
        computeCurvatures.run();
        System.out.println("Finished calculating Gaussian.");
        int n10 = 300;
        long l = 3000L;
        TracerThread tracerThread = new TracerThread(imagePlus, 0.0f, 255.0f, n10, l, n4, n5, n6, n7, n8, n9, bl, n3 == 1, computeCurvatures, computeCurvatures == null ? 1 : 4, null, computeCurvatures != null);
        System.out.println("Running tracer...");
        tracerThread.run();
        System.out.println("Finished running tracer...");
        Path path = tracerThread.getResult();
        if (path == null) {
            IJ.error((String)("Finding a path failed: " + SearchThread.exitReasonStrings[tracerThread.getExitReason()]));
            return;
        }
        IJ.error((String)("Found a path: " + path));
        PathAndFillManager pathAndFillManager = new PathAndFillManager(imagePlus);
        pathAndFillManager.addPath(path);
        try {
            file = File.createTempFile("albert-test-", ".xml");
            pathAndFillManager.writeXML(file.getAbsolutePath(), false);
        }
        catch (IOException iOException) {
            IJ.error((String)("IOException while trying to write the path to a temporary file: " + iOException));
            return;
        }
        IJ.open((String)file.getAbsolutePath());
    }
}

