/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.ImagePlus;
import java.util.ArrayList;
import tracing.AutoPoint;
import tracing.Path;
import tracing.SearchNode;
import tracing.SearchThread;
import tracing.SinglePathsGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSearchThread
extends SearchThread {
    float[][] tubeValues;
    float tubenessThreshold;
    SinglePathsGraph previousPathGraph;
    ArrayList<AutoPoint> destinations = new ArrayList(512);
    int start_x;
    int start_y;
    int start_z;

    public ArrayList<AutoPoint> getDestinations() {
        return this.destinations;
    }

    public AutoSearchThread(ImagePlus imagePlus, float[][] fArray, AutoPoint autoPoint, float f, SinglePathsGraph singlePathsGraph) {
        super(imagePlus, -1.0f, -1.0f, false, false, false, 0, 1000L);
        this.verbose = false;
        this.tubeValues = fArray;
        this.tubenessThreshold = f;
        this.previousPathGraph = singlePathsGraph;
        this.start_x = autoPoint.x;
        this.start_y = autoPoint.y;
        this.start_z = autoPoint.z;
        SearchNode searchNode = this.createNewNode(this.start_x, this.start_y, this.start_z, 0.0f, this.estimateCostToGoal(this.start_x, this.start_y, this.start_z, 0), null, (byte)1);
        this.addNode(searchNode);
    }

    @Override
    protected double costMovingTo(int n, int n2, int n3) {
        float f = this.tubeValues[n3][n2 * this.width + n];
        if (f == 0.0f) {
            f = 0.2f;
        }
        double d = 1.0f / f;
        return d;
    }

    @Override
    protected void addingNode(SearchNode searchNode) {
        if (this.tubeValues[searchNode.z][searchNode.y * this.width + searchNode.x] > this.tubenessThreshold) {
            AutoPoint autoPoint = new AutoPoint(searchNode.x, searchNode.y, searchNode.z);
            this.destinations.add(autoPoint);
        } else if (null != this.previousPathGraph.get(searchNode.x, searchNode.y, searchNode.z)) {
            AutoPoint autoPoint = new AutoPoint(searchNode.x, searchNode.y, searchNode.z);
            this.destinations.add(autoPoint);
        }
    }

    @Override
    float estimateCostToGoal(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    Path getPathBack(int n, int n2, int n3) {
        return this.nodes_as_image[n3][n2 * this.width + n].asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
    }
}

