/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.TubenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import stacks.PaneOwner;
import stacks.ThreePanes;
import tracing.AutoPoint;
import tracing.AutoSearchThread;
import tracing.AutoTracerCanvas;
import tracing.Path;
import tracing.SearchProgressCallback;
import tracing.SearchThread;
import tracing.SinglePathsGraph;
import tracing.TracerCanvas;
import util.BatchOpener;

public class Auto_Tracer
extends ThreePanes
implements PlugIn,
PaneOwner,
SearchProgressCallback {
    int width;
    int height;
    int depth;
    HashSet<AutoPoint> done;
    PriorityQueue<AutoPoint> mostTubelikePoints;
    float[][] tubeValues;
    AutoTracerCanvas canvas;
    boolean verbose = false;
    AutoSearchThread ast;
    long totalTimeLimitSeconds = 60L;
    long totalTimeStarted;
    long threadTimeStarted;
    int maxNodes = 22000;
    int maxSeconds = 120;
    float tubenessThreshold = 18.0f;
    float minimumRollingMean = 5.0f;
    int rollingLength = 4;
    int minimumPointsOnPath = -1;
    boolean liveDisplay = true;

    public boolean dimensionsIdentical(ImagePlus imagePlus, ImagePlus imagePlus2) {
        return imagePlus.getWidth() == imagePlus2.getWidth() && imagePlus.getHeight() == imagePlus2.getHeight() && imagePlus.getStackSize() == imagePlus2.getStackSize();
    }

    public TracerCanvas createCanvas(ImagePlus imagePlus, int n) {
        return new AutoTracerCanvas(imagePlus, this, n, null);
    }

    /*
     * Exception decompiling
     */
    AutoTracerParameters loadParameters(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void recreatePriorityQueue(boolean bl) {
        System.out.println("  [Recreating Priority Queue]");
        this.mostTubelikePoints = new PriorityQueue<AutoPoint>(512, new TubenessComparator(this.width, this.height, this.depth, this.tubeValues));
        System.gc();
        for (int i = 0; i < this.depth; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    if (!(this.tubeValues[i][j * this.width + k] > this.tubenessThreshold)) continue;
                    AutoPoint autoPoint = new AutoPoint(k, j, i);
                    if (bl) {
                        if (this.done.contains(autoPoint)) continue;
                        this.mostTubelikePoints.add(autoPoint);
                        continue;
                    }
                    this.mostTubelikePoints.add(autoPoint);
                }
            }
        }
        System.out.println("  [Done]");
    }

    public void autoTrace(ImagePlus imagePlus) {
        long l;
        long l2;
        AutoTracerParameters autoTracerParameters;
        int n;
        Calibration calibration = imagePlus.getCalibration();
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        String string = fileInfo.fileName;
        System.out.println("originalFileName is " + string);
        int n2 = string.lastIndexOf(".");
        String string2 = string.substring(0, n2);
        String string3 = string2 + ".tubes.tif";
        String string4 = string2 + ".thresholds";
        String string5 = string2 + ".traces.obj";
        ImagePlus imagePlus2 = null;
        File file = new File(fileInfo.directory, string3);
        if (file.exists()) {
            IJ.showStatus((String)"Loading tubes file.");
            imagePlus2 = BatchOpener.openFirstChannel(file.getAbsolutePath());
            if (imagePlus2 == null) {
                IJ.error((String)("Failed to load tubes image from " + file.getAbsolutePath()));
                return;
            }
        } else {
            IJ.showStatus((String)"No tubes file found, generating anew...");
            double d = 1.0;
            if (calibration != null) {
                d = Math.min(Math.abs(calibration.pixelWidth), Math.min(Math.abs(calibration.pixelHeight), Math.abs(calibration.pixelDepth)));
            }
            TubenessProcessor tubenessProcessor = new TubenessProcessor(d, true);
            imagePlus2 = tubenessProcessor.generateImage(imagePlus);
            System.out.println("Got tubes file.");
            n = new FileSaver(imagePlus2).saveAsTiffStack(file.getAbsolutePath());
            if (n == 0) {
                IJ.error((String)("Failed to save tubes image to " + file.getAbsolutePath()));
                return;
            }
        }
        if (!this.dimensionsIdentical(imagePlus, imagePlus2)) {
            IJ.error((String)"The dimensions of the image and the tube image didn't match.");
            return;
        }
        File file2 = new File(fileInfo.directory, string4);
        System.out.println("Testing for the existence of: " + file2.getAbsolutePath());
        if (file2.exists()) {
            autoTracerParameters = this.loadParameters(file2.getAbsolutePath());
            if (autoTracerParameters == null) {
                throw new RuntimeException("The thresholds file '" + file2.getAbsolutePath() + "' was corrupted somehow.");
            }
            this.tubenessThreshold = autoTracerParameters.tubenessThreshold;
            this.minimumRollingMean = autoTracerParameters.minimumRollingMean;
        } else {
            autoTracerParameters = new GenericDialog("Auto Tracer");
            autoTracerParameters.addNumericField("Tubeness threshold for destinations", this.tubenessThreshold, 2);
            autoTracerParameters.addNumericField("Minimum rolling mean tubeness", this.minimumRollingMean, 2);
            autoTracerParameters.addMessage("(For help about these options, please go to: http://fruitfly.inf.ed.ac.uk/auto-tracer/ )");
            autoTracerParameters.showDialog();
            if (autoTracerParameters.wasCanceled()) {
                return;
            }
            this.tubenessThreshold = (float)autoTracerParameters.getNextNumber();
            this.minimumRollingMean = (float)autoTracerParameters.getNextNumber();
            if (this.tubenessThreshold < 0.0f) {
                throw new RuntimeException("Tubeness threshold for destinations must be positive");
            }
            if (this.minimumRollingMean < 0.0f) {
                throw new RuntimeException("Minimum rolling mean tubeness must be positive");
            }
            if (this.minimumRollingMean > this.tubenessThreshold) {
                throw new RuntimeException("It doesn't make sense for tubeness threshold for destinations to be less than the minimum rolling mean tubeness.");
            }
        }
        this.totalTimeStarted = System.currentTimeMillis();
        System.out.println("Now using tubenessThreshold: " + this.tubenessThreshold);
        System.out.println("     and minimumRollingMean: " + this.minimumRollingMean);
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
        autoTracerParameters = imagePlus2.getStack();
        this.tubeValues = new float[this.depth][];
        for (int i = 0; i < this.depth; ++i) {
            this.tubeValues[i] = (float[])autoTracerParameters.getPixels(i + 1);
        }
        this.done = new HashSet();
        this.recreatePriorityQueue(false);
        System.out.println("Initial points: " + this.mostTubelikePoints.size());
        SinglePathsGraph singlePathsGraph = new SinglePathsGraph(this.width, this.height, this.depth, Math.abs(calibration.pixelWidth), Math.abs(calibration.pixelHeight), Math.abs(calibration.pixelDepth));
        n = -1;
        int n3 = 0;
        while (this.mostTubelikePoints.size() > 0 && (l2 = ((l = System.currentTimeMillis()) - this.totalTimeStarted) / 1000L) <= this.totalTimeLimitSeconds && (n < 0 || n3 < n)) {
            int n4;
            AutoPoint autoPoint = this.mostTubelikePoints.poll();
            if (this.done.contains(autoPoint)) continue;
            System.out.println("=== Done size is: " + this.done.size());
            System.out.println("=== Priority queue now has: " + this.mostTubelikePoints.size());
            System.out.println("=== Loops done: " + n3);
            System.out.println("  Got point " + autoPoint + " with tubeness: " + this.tubeValues[autoPoint.z][autoPoint.y * this.width + autoPoint.x]);
            if (this.liveDisplay) {
                imagePlus.setSlice(autoPoint.z + 1);
            }
            this.ast = new AutoSearchThread(imagePlus, this.tubeValues, autoPoint, this.tubenessThreshold, singlePathsGraph);
            this.threadTimeStarted = l;
            this.ast.setDrawingColors(Color.BLUE, Color.CYAN);
            this.ast.setDrawingThreshold(-1.0f);
            this.ast.addProgressListener(this);
            if (this.liveDisplay) {
                this.canvas.addSearchThread(this.ast);
            }
            this.ast.start();
            try {
                this.ast.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.liveDisplay) {
                this.canvas.removeSearchThread(this.ast);
            }
            ArrayList<AutoPoint> arrayList = this.ast.getDestinations();
            System.out.println("  === Destinations: " + arrayList.size());
            if (this.verbose) {
                System.out.print("  === Destinations: " + arrayList.size() + " ");
            }
            if (this.verbose) {
                System.out.flush();
            }
            Iterator<AutoPoint> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n5;
                int n6;
                if (this.verbose) {
                    System.out.print("    ");
                }
                AutoPoint autoPoint2 = iterator.next();
                Path path = this.ast.getPathBack(autoPoint2.x, autoPoint2.y, autoPoint2.z);
                float[] fArray = new float[this.rollingLength];
                n4 = 0;
                int n7 = 0;
                int n8 = path.size() - 1;
                if (this.minimumPointsOnPath >= 0 && path.size() < this.minimumPointsOnPath) {
                    n8 = -1;
                } else {
                    for (int i = 0; i < path.size(); ++i) {
                        float f;
                        if (this.verbose) {
                            System.out.print(".");
                        }
                        if (this.verbose) {
                            System.out.flush();
                        }
                        int n9 = path.getXUnscaled(i);
                        int n10 = path.getYUnscaled(i);
                        n6 = path.getZUnscaled(i);
                        fArray[n4] = f = this.tubeValues[n6][n10 * this.width + n9];
                        if (n7 < n4 + 1) {
                            n7 = n4 + 1;
                        }
                        float f2 = 0.0f;
                        for (n5 = 0; n5 < n7; ++n5) {
                            f2 += fArray[n5];
                        }
                        if ((f2 /= (float)n7) < this.minimumRollingMean) {
                            n8 = i + 1 - n7;
                            break;
                        }
                        if (n4 == this.rollingLength - 1) {
                            n4 = 0;
                            continue;
                        }
                        ++n4;
                    }
                }
                AutoPoint autoPoint3 = null;
                AutoPoint autoPoint4 = null;
                HashSet<AutoPoint> hashSet = new HashSet<AutoPoint>();
                for (n6 = 0; n6 <= n8; ++n6) {
                    if (this.verbose) {
                        System.out.print("#");
                    }
                    if (this.verbose) {
                        System.out.flush();
                    }
                    int n11 = path.getXUnscaled(n6);
                    int n12 = path.getYUnscaled(n6);
                    n5 = path.getZUnscaled(n6);
                    float f = this.tubeValues[n5][n12 * this.width + n11];
                    autoPoint3 = new AutoPoint(n11, n12, n5);
                    if (f > this.tubenessThreshold) {
                        hashSet.add(autoPoint3);
                    }
                    singlePathsGraph.addPoint(autoPoint3, autoPoint4);
                    autoPoint4 = autoPoint3;
                }
                for (AutoPoint autoPoint5 : hashSet) {
                    if (this.verbose) {
                        System.out.flush();
                    }
                    this.done.add(autoPoint5);
                }
                if (!this.verbose) continue;
                System.out.println("");
            }
            this.ast = null;
            System.gc();
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = Runtime.getRuntime().totalMemory();
            n4 = (int)((l4 - l3) * 100L / l4);
            System.out.println("=== Memory usage: " + n4 + "%");
            if (n4 > 95 || n3 % 50 == 49) {
                this.recreatePriorityQueue(true);
                if (this.mostTubelikePoints.size() == 0) break;
            }
            ++n3;
        }
        File file3 = new File(fileInfo.directory, string5);
        try {
            singlePathsGraph.writeWavefrontObj(file3.getAbsolutePath());
        }
        catch (IOException iOException) {
            IJ.error((String)("Writing the Wavefront OBJ file '" + file3.getAbsolutePath() + "' failed"));
            return;
        }
    }

    public void run(String string) {
        String string2;
        String string3;
        long l;
        long l2;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No current image for automatic tracing.");
            return;
        }
        long l3 = imagePlus.getWidth();
        long l4 = l3 * (l2 = (long)imagePlus.getHeight()) * (l = (long)imagePlus.getStackSize());
        if (l4 >= Integer.MAX_VALUE) {
            IJ.error((String)"This plugin currently only works with images with less that 2147483647 points.");
            return;
        }
        String string4 = Macro.getOptions();
        if (string4 != null && (string3 = (string2 = Macro.getValue((String)string4, (String)"live", (String)"")).toLowerCase()).length() > 0 && (string3.equals("no") || string3.equals("f") || string3.equals("false") || string3.equals("n"))) {
            this.liveDisplay = false;
        }
        this.single_pane = true;
        if (this.liveDisplay) {
            this.initialize(imagePlus);
            this.canvas = (AutoTracerCanvas)this.xy_canvas;
        }
        this.autoTrace(imagePlus);
    }

    public void pointsInSearch(SearchThread searchThread, int n, int n2) {
        if (this.liveDisplay) {
            this.repaintAllPanes();
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.threadTimeStarted;
        if (n + n2 > this.maxNodes || l2 / 1000L > (long)this.maxSeconds) {
            if (this.verbose) {
                System.out.println("### Requesting stop...");
            }
            this.ast.requestStop();
        }
    }

    public void finished(SearchThread searchThread, boolean bl) {
        long l = System.currentTimeMillis();
        long l2 = (l - this.threadTimeStarted) / 1000L;
        System.out.println("  " + (searchThread.open_from_start.size() + searchThread.closed_from_start.size()) + " nodes in " + l2 + " seconds");
    }

    public void threadStatus(SearchThread searchThread, int n) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TubenessComparator
    implements Comparator<AutoPoint> {
        int width;
        int height;
        int depth;
        float[][] tubeValues;

        public TubenessComparator(int n, int n2, int n3, float[][] fArray) {
            this.width = n;
            this.height = n2;
            this.depth = n3;
            this.tubeValues = fArray;
        }

        @Override
        public int compare(AutoPoint autoPoint, AutoPoint autoPoint2) {
            return -Float.compare(this.tubeValues[autoPoint.z][autoPoint.y * this.width + autoPoint.x], this.tubeValues[autoPoint2.z][autoPoint2.y * this.width + autoPoint2.x]);
        }
    }

    static class AutoTracerParameters {
        float tubenessThreshold;
        float minimumRollingMean;

        AutoTracerParameters() {
        }
    }
}

