/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tracing.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fill {
    public double distanceThreshold;
    ArrayList<Node> nodeList = new ArrayList();
    Set<Path> sourcePaths;
    public String metric;
    public double x_spacing;
    public double y_spacing;
    public double z_spacing;
    public String spacing_units;

    public void add(int n, int n2, int n3, double d, int n4, boolean bl) {
        Node node = new Node();
        node.x = n;
        node.y = n2;
        node.z = n3;
        node.distance = d;
        node.previous = n4;
        node.open = bl;
        this.nodeList.add(node);
    }

    public void setSourcePaths(Path[] pathArray) {
        this.sourcePaths = new HashSet<Path>();
        for (int i = 0; i < pathArray.length; ++i) {
            this.sourcePaths.add(pathArray[i]);
        }
    }

    public void setSourcePaths(Set<Path> set) {
        this.sourcePaths = new HashSet<Path>();
        this.sourcePaths.addAll(set);
    }

    public void setMetric(String string) {
        this.metric = string;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setSpacing(double d, double d2, double d3, String string) {
        this.x_spacing = d;
        this.y_spacing = d2;
        this.z_spacing = d3;
        this.spacing_units = string;
    }

    public void setThreshold(double d) {
        this.distanceThreshold = d;
    }

    public double getThreshold() {
        return this.distanceThreshold;
    }

    public void writeNodesXML(PrintWriter printWriter) {
        int n = 0;
        for (Node node : this.nodeList) {
            printWriter.println("    <node id=\"" + n + "\" " + "x=\"" + node.x + "\" " + "y=\"" + node.y + "\" " + "z=\"" + node.z + "\" " + (node.previous >= 0 ? "previousid=\"" + node.previous + "\" " : "") + "distance=\"" + node.distance + "\" status=\"" + (node.open ? "open" : "closed") + "\"/>");
            ++n;
        }
    }

    public void writeXML(PrintWriter printWriter, int n, Map<Path, Integer> map) {
        printWriter.print("  <fill id=\"" + n + "\"");
        if (this.sourcePaths != null && this.sourcePaths.size() > 0) {
            printWriter.print(" frompaths=\"");
            Iterator<Path> iterator = this.sourcePaths.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                Path path = iterator.next();
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(", ");
                }
                Integer n2 = map.get(path);
                if (n2 == null) {
                    printWriter.print("-1");
                    continue;
                }
                printWriter.print("" + n2);
            }
            printWriter.print("\"");
        }
        printWriter.println(" metric=\"" + this.getMetric() + "\" threshold=\"" + this.getThreshold() + "\">");
        this.writeNodesXML(printWriter);
        printWriter.println("  </fill>");
    }

    public class Node {
        public int x;
        public int y;
        public int z;
        public double distance;
        public int previous;
        public boolean open;
    }
}

