/*
 * Decompiled with CFR 0.152.
 */
package tracing;

class GraphNode
implements Comparable {
    public int id;
    public int x;
    public int y;
    public int z;
    public String material_name;
    public GraphNode previous;
    public double g;
    public double h;

    GraphNode() {
    }

    void setFrom(GraphNode graphNode) {
        this.id = graphNode.id;
        this.x = graphNode.x;
        this.y = graphNode.y;
        this.z = graphNode.z;
        this.material_name = graphNode.material_name;
        this.previous = graphNode.previous;
        this.g = graphNode.g;
        this.h = graphNode.h;
    }

    double f() {
        return this.g + this.h;
    }

    public int compareTo(Object object) {
        GraphNode graphNode = (GraphNode)object;
        return Double.compare(this.f(), graphNode.f());
    }

    public boolean equals(Object object) {
        return this.id == ((GraphNode)object).id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean nearTo(int n, int n2, int n3, int n4) {
        int n5 = n2 - this.x;
        int n6 = n3 - this.y;
        int n7 = n4 - this.z;
        long l = n5 * n5 + n6 * n6 + n7 * n7;
        long l2 = n * n;
        return l <= l2;
    }

    public String toDotName() {
        return this.material_name + " (" + this.id + ")";
    }

    public String toCollapsedDotName() {
        if (this.material_name.equals("Exterior")) {
            return this.material_name + " (" + this.id + ")";
        }
        return this.material_name;
    }
}

