/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import tracing.FillerThread;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.Simple_Neurite_Tracer;
import tracing.TracerCanvas;

public class InteractiveTracerCanvas
extends TracerCanvas
implements KeyListener {
    static final boolean verbose = false;
    boolean fillTransparent = false;
    Color transparentGreen = new Color(0, 128, 0, 128);
    private Simple_Neurite_Tracer tracerPlugin;
    private Path unconfirmedSegment;
    private Path currentPath;
    private boolean lastPathUnfinished;
    int last_x_in_pane;
    int last_y_in_pane;

    public void setFillTransparent(boolean bl) {
        this.fillTransparent = bl;
    }

    public Simple_Neurite_Tracer getTracerPlugin() {
        return this.tracerPlugin;
    }

    InteractiveTracerCanvas(ImagePlus imagePlus, Simple_Neurite_Tracer simple_Neurite_Tracer, int n, PathAndFillManager pathAndFillManager) {
        super(imagePlus, simple_Neurite_Tracer, n, pathAndFillManager);
        this.tracerPlugin = simple_Neurite_Tracer;
    }

    public void setPathUnfinished(boolean bl) {
        this.lastPathUnfinished = bl;
    }

    public void setTemporaryPath(Path path) {
        this.unconfirmedSegment = path;
    }

    public void setCurrentPath(Path path) {
        this.currentPath = path;
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2;
        if (!this.tracerPlugin.isReady()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        boolean bl3 = IJ.isMacintosh();
        boolean bl4 = bl2 = n == 16;
        boolean bl5 = bl3 ? n == 18 : (bl = n == 17);
        if (c == 'y' || c == 'Y') {
            this.tracerPlugin.confirmTemporary();
        } else if (n == 27) {
            this.tracerPlugin.cancelTemporary();
        } else if (c == 'f' || c == 'F') {
            this.tracerPlugin.finishedPath();
        } else if (c == 'v' || c == 'V') {
            this.tracerPlugin.makePathVolume();
        } else if (c == '5') {
            this.just_near_slices = !this.just_near_slices;
        } else if (bl2 || bl) {
            this.tracerPlugin.mouseMovedTo(this.last_x_in_pane, this.last_y_in_pane, this.plane, bl2, bl);
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl;
        if (!this.tracerPlugin.isReady()) {
            return;
        }
        double d = this.myOffScreenXD(mouseEvent.getX());
        double d2 = this.myOffScreenYD(mouseEvent.getY());
        this.last_x_in_pane = (int)d;
        this.last_y_in_pane = (int)d2;
        boolean bl2 = IJ.isMacintosh();
        boolean bl3 = bl = (mouseEvent.getModifiersEx() & 0x40) != 0;
        boolean bl4 = bl2 ? (mouseEvent.getModifiersEx() & 0x200) != 0 : (mouseEvent.getModifiersEx() & 0x80) != 0;
        this.tracerPlugin.mouseMovedTo(d, d2, this.plane, bl, bl4);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.tracerPlugin.isReady()) {
            return;
        }
        int n = this.tracerPlugin.resultsDialog.getState();
        if (n != 11 && n != 10) {
            if (n == 8) {
                this.tracerPlugin.launchPaletteAround(this.myOffScreenX(mouseEvent.getX()), this.myOffScreenY(mouseEvent.getY()), this.imp.getCurrentSlice() - 1);
            } else if (n == 9) {
                IJ.error((String)"You must close the sigma palette to continue");
            } else if (this.tracerPlugin.setupTrace) {
                boolean bl = IJ.isMacintosh() ? mouseEvent.isAltDown() : mouseEvent.isControlDown();
                this.tracerPlugin.clickForTrace(this.myOffScreenX(mouseEvent.getX()), this.myOffScreenY(mouseEvent.getY()), this.plane, bl);
            } else {
                IJ.error((String)"BUG: No operation chosen");
            }
        }
    }

    protected void drawOverlay(Graphics graphics) {
        Path path;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.tracerPlugin.loading) {
            return;
        }
        FillerThread fillerThread = this.tracerPlugin.filler;
        if (fillerThread != null) {
            fillerThread.setDrawingColors(this.fillTransparent ? this.transparentGreen : Color.GREEN, this.fillTransparent ? this.transparentGreen : Color.GREEN);
            fillerThread.setDrawingThreshold(fillerThread.getThreshold());
        }
        super.drawOverlay(graphics);
        int n5 = (int)this.getMagnification();
        if (n5 < 1) {
            n5 = 1;
        }
        int n6 = 5 * n5;
        if (this.unconfirmedSegment != null) {
            this.unconfirmedSegment.drawPathAsPoints(this, graphics, Color.BLUE, this.plane);
            if (this.unconfirmedSegment.endJoins != null) {
                int n7 = this.unconfirmedSegment.size();
                n4 = this.myScreenX(this.unconfirmedSegment.getXUnscaled(n7 - 1));
                n3 = this.myScreenY(this.unconfirmedSegment.getYUnscaled(n7 - 1));
                n2 = n4 - n6 / 2;
                n = n3 - n6 / 2;
                graphics.setColor(Color.BLUE);
                graphics.fillRect(n2, n, n6, n6);
                graphics.setColor(Color.GREEN);
                graphics.drawRect(n2, n, n6, n6);
            }
        }
        if ((path = this.tracerPlugin.getCurrentPath()) != null) {
            if (this.just_near_slices) {
                path.drawPathAsPoints(this, graphics, Color.RED, this.plane, this.imp.getCurrentSlice() - 1, this.eitherSide);
            } else {
                path.drawPathAsPoints(this, graphics, Color.RED, this.plane);
            }
            if (this.lastPathUnfinished && this.currentPath.size() == 0) {
                n4 = this.myScreenX(this.tracerPlugin.last_start_point_x);
                n3 = this.myScreenY(this.tracerPlugin.last_start_point_y);
                n2 = n4 - n6 / 2;
                n = n3 - n6 / 2;
                graphics.setColor(Color.BLUE);
                graphics.fillRect(n2, n, n6, n6);
                if (path.startJoins != null) {
                    graphics.setColor(Color.GREEN);
                    graphics.drawRect(n2, n, n6, n6);
                }
            }
        }
    }
}

