/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.Sigma_Palette;
import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import tracing.FillWindow;
import tracing.Path;
import tracing.PathAndFillListener;
import tracing.PathAndFillManager;
import tracing.PathColorsCanvas;
import tracing.PathWindow;
import tracing.SearchThread;
import tracing.Simple_Neurite_Tracer;

class NeuriteTracerResultsDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener,
PathAndFillListener,
TextListener,
Sigma_Palette.SigmaPaletteListener {
    static final boolean verbose = false;
    PathWindow pw;
    FillWindow fw;
    static final int WAITING_TO_START_PATH = 0;
    static final int PARTIAL_PATH = 1;
    static final int SEARCHING = 2;
    static final int QUERY_KEEP = 3;
    static final int LOGGING_POINTS = 4;
    static final int DISPLAY_EVS = 5;
    static final int FILLING_PATHS = 6;
    static final int CALCULATING_GAUSSIAN = 7;
    static final int WAITING_FOR_SIGMA_POINT = 8;
    static final int WAITING_FOR_SIGMA_CHOICE = 9;
    static final int SAVING = 10;
    static final int LOADING = 11;
    static final String[] stateNames = new String[]{"WAITING_TO_START_PATH", "PARTIAL_PATH", "SEARCHING", "QUERY_KEEP", "LOGGING_POINTS", "DISPLAY_EVS", "FILLING_PATHS", "CALCULATING_GAUSSIAN", "WAITING_FOR_SIGMA_POINT", "WAITING_FOR_SIGMA_CHOICE", "SAVING", "LOADING"};
    static final String SEARCHING_STRING = "Searching for path between points...";
    private int currentState;
    Simple_Neurite_Tracer plugin;
    Panel statusPanel;
    TextArea statusText;
    Button keepSegment;
    Button junkSegment;
    Button cancelSearch;
    Panel pathActionPanel;
    Button completePath;
    Button cancelPath;
    Choice viewPathChoice;
    String projectionChoice = "projected through all slices";
    String partsNearbyChoice = "parts in nearby slices";
    TextField nearbyField;
    PathColorsCanvas pathColorsCanvas;
    Checkbox justShowSelected;
    Checkbox preprocess;
    Checkbox usePreprocessed;
    double currentSigma;
    double currentMultiplier;
    Label currentSigmaAndMultiplierLabel;
    Button editSigma;
    Button sigmaWizard;
    Button loadLabelsButton;
    Button importSWCButton;
    Button exportCSVButton;
    Button saveButton;
    Button loadButton;
    Button uploadButton;
    Button fetchButton;
    Button quitButton;
    Button showOrHidePathList;
    Button showOrHideFillList;
    int preGaussianState;
    int preSigmaPaletteState;
    DecimalFormat threeDecimalPlaces = new DecimalFormat("0.0000");
    DecimalFormat threeDecimalPlacesScientific = new DecimalFormat("0.00E00");
    private PathAndFillManager pathAndFillManager;
    boolean launchedByArchive;
    boolean reportedInvalid;

    public void newSigmaSelected(double d) {
        this.setSigma(d, false);
    }

    public void newMaximum(double d) {
        double d2 = 256.0 / d;
        this.setMultiplier(d2);
    }

    public void setPathList(String[] stringArray, Path path, boolean bl) {
    }

    public void setFillList(String[] stringArray) {
    }

    public void setSelectedPaths(HashSet hashSet, Object object) {
        if (object == this) {
            return;
        }
        for (int i = 0; i < this.pathAndFillManager.size(); ++i) {
            Path path = this.pathAndFillManager.getPath(i);
            if (hashSet.contains(path)) {
                path.setSelected(true);
                continue;
            }
            path.setSelected(false);
        }
    }

    public void gaussianCalculated(boolean bl) {
        if (!bl) {
            this.preprocess.setState(false);
        }
        this.changeState(this.preGaussianState);
        if (this.preprocess.getState()) {
            this.editSigma.setEnabled(false);
            this.sigmaWizard.setEnabled(false);
        } else {
            this.editSigma.setEnabled(true);
            this.sigmaWizard.setEnabled(true);
        }
    }

    public void setMultiplier(double d) {
        this.currentMultiplier = d;
        this.updateLabel();
    }

    public void setSigma(double d, boolean bl) {
        this.currentSigma = d;
        this.updateLabel();
        if (bl) {
            if (this.preprocess.getState()) {
                IJ.error((String)"[BUG] The preprocess checkbox should never be on when setSigma is called");
            } else {
                this.preprocess.setState(true);
                this.turnOnHessian();
            }
        }
    }

    public void turnOnHessian() {
        this.preGaussianState = this.currentState;
        this.plugin.enableHessian(true);
    }

    public String formatDouble(double d) {
        double d2 = Math.abs(d);
        if (d2 < 0.01 || d2 >= 1000.0) {
            return this.threeDecimalPlacesScientific.format(d);
        }
        return this.threeDecimalPlaces.format(d);
    }

    public void updateLabel() {
        this.currentSigmaAndMultiplierLabel.setText("\u03c3 = " + this.formatDouble(this.currentSigma) + ", multiplier = " + this.formatDouble(this.currentMultiplier));
    }

    public double getSigma() {
        return this.currentSigma;
    }

    public double getMultiplier() {
        return this.currentMultiplier;
    }

    public void exitRequested() {
        YesNoCancelDialog yesNoCancelDialog;
        if (this.plugin.pathsUnsaved() && !(yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Really quit?", "There are unsaved paths. Do you really want to quit?")).yesPressed()) {
            return;
        }
        this.plugin.cancelSearch(true);
        this.pw.dispose();
        this.fw.dispose();
        this.dispose();
        this.plugin.closeAndReset();
    }

    public void disableEverything() {
        this.fw.setEnabledNone();
        this.pw.setButtonsEnabled(false);
        this.statusText.setEnabled(false);
        this.keepSegment.setEnabled(false);
        this.junkSegment.setEnabled(false);
        this.cancelSearch.setEnabled(false);
        this.completePath.setEnabled(false);
        this.cancelPath.setEnabled(false);
        this.editSigma.setEnabled(false);
        this.sigmaWizard.setEnabled(false);
        this.viewPathChoice.setEnabled(false);
        this.preprocess.setEnabled(false);
        this.importSWCButton.setEnabled(false);
        this.exportCSVButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.loadButton.setEnabled(false);
        if (this.uploadButton != null) {
            this.uploadButton.setEnabled(false);
            this.fetchButton.setEnabled(false);
        }
        this.loadLabelsButton.setEnabled(false);
        this.quitButton.setEnabled(false);
    }

    public void changeState(int n) {
        switch (n) {
            case 0: {
                this.statusText.setText("Click somewhere to start a new path...");
                this.disableEverything();
                this.pw.setButtonsEnabled(true);
                this.pw.valueChanged(null);
                this.cancelSearch.setVisible(false);
                this.keepSegment.setVisible(false);
                this.junkSegment.setVisible(false);
                this.viewPathChoice.setEnabled(true);
                this.preprocess.setEnabled(true);
                this.editSigma.setEnabled(!this.preprocess.getState());
                this.sigmaWizard.setEnabled(!this.preprocess.getState());
                this.fw.setEnabledWhileNotFilling();
                this.loadLabelsButton.setEnabled(true);
                this.saveButton.setEnabled(true);
                this.loadButton.setEnabled(true);
                this.importSWCButton.setEnabled(true);
                this.exportCSVButton.setEnabled(true);
                if (this.uploadButton != null) {
                    this.uploadButton.setEnabled(true);
                    this.fetchButton.setEnabled(true);
                }
                this.quitButton.setEnabled(true);
                break;
            }
            case 1: {
                this.statusText.setText("Now select a point further along that structure...");
                this.disableEverything();
                this.cancelSearch.setVisible(false);
                this.keepSegment.setVisible(false);
                this.junkSegment.setVisible(false);
                if (this.plugin.justFirstPoint()) {
                    this.completePath.setEnabled(false);
                } else {
                    this.completePath.setEnabled(true);
                }
                this.cancelPath.setEnabled(true);
                this.viewPathChoice.setEnabled(true);
                this.preprocess.setEnabled(true);
                this.editSigma.setEnabled(!this.preprocess.getState());
                this.sigmaWizard.setEnabled(!this.preprocess.getState());
                this.quitButton.setEnabled(false);
                break;
            }
            case 2: {
                this.statusText.setText(SEARCHING_STRING);
                this.disableEverything();
                this.cancelSearch.setLabel("Abandon search");
                this.cancelSearch.setEnabled(true);
                this.cancelSearch.setVisible(true);
                this.keepSegment.setVisible(false);
                this.junkSegment.setVisible(false);
                this.completePath.setEnabled(false);
                this.cancelPath.setEnabled(false);
                this.quitButton.setEnabled(true);
                break;
            }
            case 3: {
                this.statusText.setText("Keep this new path segment?");
                this.disableEverything();
                this.keepSegment.setEnabled(true);
                this.junkSegment.setEnabled(true);
                this.cancelSearch.setVisible(false);
                this.keepSegment.setVisible(true);
                this.junkSegment.setVisible(true);
                break;
            }
            case 6: {
                this.statusText.setText("Filling out from neuron...");
                this.disableEverything();
                this.fw.setEnabledWhileFilling();
                break;
            }
            case 7: {
                this.statusText.setText("Calculating Gaussian...");
                this.disableEverything();
                this.cancelSearch.setLabel("Cancel");
                this.cancelSearch.setEnabled(true);
                this.cancelSearch.setVisible(true);
                this.keepSegment.setVisible(true);
                this.junkSegment.setVisible(true);
                break;
            }
            case 8: {
                this.statusText.setText("Click on a neuron in the image");
                this.disableEverything();
                break;
            }
            case 9: {
                this.statusText.setText("Close the sigma palette window to continue");
                this.disableEverything();
                break;
            }
            case 11: {
                this.statusText.setText("Loading...");
                this.disableEverything();
                break;
            }
            case 10: {
                this.statusText.setText("Saving...");
                this.disableEverything();
                break;
            }
            default: {
                IJ.error((String)"BUG: switching to an unknown state");
                return;
            }
        }
        this.pack();
        this.plugin.repaintAllPanes();
        this.currentState = n;
    }

    public int getState() {
        return this.currentState;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitRequested();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void updateSearchingStatistics(int n) {
        this.statusText.setText("Searching for path between points... (" + n + " boundary points.)");
    }

    public NeuriteTracerResultsDialog(String string, Simple_Neurite_Tracer simple_Neurite_Tracer, boolean bl) {
        super((Frame)IJ.getInstance(), string, false);
        this.plugin = simple_Neurite_Tracer;
        this.launchedByArchive = bl;
        this.pathAndFillManager = simple_Neurite_Tracer.getPathAndFillManager();
        this.addWindowListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.statusPanel = new Panel();
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.add((Component)new Label("Instructions:"), "North");
        this.statusText = new TextArea("Initial status text...", 2, 25, 3);
        this.statusPanel.add((Component)this.statusText, "Center");
        this.keepSegment = new Button("Yes");
        this.junkSegment = new Button("No");
        this.cancelSearch = new Button("Abandon Search");
        this.keepSegment.addActionListener(this);
        this.junkSegment.addActionListener(this);
        this.cancelSearch.addActionListener(this);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 21;
        panel.add((Component)this.keepSegment, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 21;
        panel.add((Component)this.junkSegment, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 21;
        panel.add((Component)this.cancelSearch, gridBagConstraints2);
        this.statusPanel.add((Component)panel, "South");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.statusPanel, gridBagConstraints);
        this.pathActionPanel = new Panel();
        this.completePath = new Button("Complete Path");
        this.cancelPath = new Button("Cancel Path");
        this.completePath.addActionListener(this);
        this.cancelPath.addActionListener(this);
        this.pathActionPanel.add(this.completePath);
        this.pathActionPanel.add(this.cancelPath);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.pathActionPanel, gridBagConstraints);
        panel = new Panel();
        panel.setLayout(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 21;
        this.viewPathChoice = new Choice();
        this.viewPathChoice.addItem(this.projectionChoice);
        this.viewPathChoice.addItem(this.partsNearbyChoice);
        this.viewPathChoice.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)new Label("(up to"), "West");
        this.nearbyField = new TextField("2", 2);
        this.nearbyField.addTextListener(this);
        panel2.add((Component)this.nearbyField, "Center");
        panel2.add((Component)new Label("slices to each side)"), "East");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        panel.add((Component)new Label("View paths: "), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        panel.add((Component)this.viewPathChoice, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 22;
        panel.add((Component)panel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 21;
        panel.add((Component)new Label("Click to change Path colours:"), gridBagConstraints2);
        System.out.println("Creating with plugin: " + simple_Neurite_Tracer);
        this.pathColorsCanvas = new PathColorsCanvas(simple_Neurite_Tracer, 150, 18);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.pathColorsCanvas, gridBagConstraints2);
        this.justShowSelected = new Checkbox("Show only selected paths");
        this.justShowSelected.addItemListener(this);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.justShowSelected, gridBagConstraints2);
        this.preprocess = new Checkbox("Hessian-based analysis");
        this.preprocess.addItemListener(this);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 21;
        panel.add((Component)this.preprocess, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.usePreprocessed = new Checkbox("Use preprocessed image");
        this.usePreprocessed.addItemListener(this);
        this.usePreprocessed.setEnabled(simple_Neurite_Tracer.tubeness != null);
        panel.add((Component)this.usePreprocessed, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        this.currentSigmaAndMultiplierLabel = new Label();
        ++gridBagConstraints2.gridy;
        panel.add((Component)this.currentSigmaAndMultiplierLabel, gridBagConstraints2);
        this.setSigma(simple_Neurite_Tracer.getMinimumSeparation(), false);
        this.setMultiplier(4.0);
        this.updateLabel();
        ++gridBagConstraints2.gridy;
        Panel panel3 = new Panel();
        this.editSigma = new Button("Pick Sigma Manually");
        this.editSigma.addActionListener(this);
        panel3.add(this.editSigma);
        this.sigmaWizard = new Button("Pick Sigma Visually");
        this.sigmaWizard.addActionListener(this);
        panel3.add(this.sigmaWizard);
        ++gridBagConstraints2.gridy;
        panel.add((Component)panel3, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)panel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.showOrHidePathList = new Button("Show / Hide Path List");
        this.add((Component)this.showOrHidePathList, gridBagConstraints);
        this.showOrHidePathList.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.showOrHideFillList = new Button("Show / Hide Fill List");
        this.add((Component)this.showOrHideFillList, gridBagConstraints);
        this.showOrHideFillList.addActionListener(this);
        panel = new Panel();
        panel.setLayout(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.loadLabelsButton = new Button("Load Labels");
        this.loadLabelsButton.addActionListener(this);
        this.add((Component)this.loadLabelsButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.importSWCButton = new Button("Import SWC File");
        this.importSWCButton.addActionListener(this);
        this.add((Component)this.importSWCButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.exportCSVButton = new Button("Export as CSV");
        this.exportCSVButton.addActionListener(this);
        this.add((Component)this.exportCSVButton, gridBagConstraints);
        this.saveButton = new Button("Save Traces File");
        this.saveButton.addActionListener(this);
        this.loadButton = new Button("Load Traces File");
        this.loadButton.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        panel.add((Component)this.saveButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        panel.add((Component)this.loadButton, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)panel, gridBagConstraints);
        this.quitButton = new Button("Quit Tracer");
        this.quitButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.quitButton, gridBagConstraints);
        this.pack();
        this.pw = new PathWindow(this.pathAndFillManager, simple_Neurite_Tracer, this.getX() + this.getWidth(), this.getY());
        this.fw = new FillWindow(this.pathAndFillManager, simple_Neurite_Tracer, this.getX() + this.getWidth(), this.getY() + this.pw.getHeight());
        this.changeState(0);
    }

    public void displayOnStarting() {
        this.setVisible(true);
        this.setPathListVisible(true);
        this.setFillListVisible(false);
    }

    public void showMouseThreshold(float f) {
        String string = null;
        string = f < 0.0f ? "Not reached by search yet" : "Distance from path is: " + f;
        this.fw.fillStatus.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            Object object2;
            String string;
            SaveDialog saveDialog;
            FileInfo fileInfo = this.plugin.file_info;
            if (fileInfo == null) {
                saveDialog = new SaveDialog("Save traces as...", "image", ".traces");
            } else {
                string = fileInfo.fileName;
                object2 = fileInfo.directory;
                String string2 = string;
                saveDialog = new SaveDialog("Save traces as...", (String)object2, string2, ".traces");
            }
            if (saveDialog.getFileName() == null) {
                return;
            }
            string = saveDialog.getDirectory() + saveDialog.getFileName();
            object2 = new File(string);
            if (object2 != null && ((File)object2).exists() && !IJ.showMessageWithCancel((String)"Save traces file...", (String)("The file " + string + " already exists.\n" + "Do you want to replace it?"))) {
                return;
            }
            IJ.showStatus((String)("Saving traces to " + string));
            int n = this.currentState;
            this.changeState(10);
            try {
                this.pathAndFillManager.writeXML(string, true);
            }
            catch (IOException iOException) {
                IJ.showStatus((String)"Saving failed.");
                IJ.error((String)("Writing traces to '" + string + "' failed: " + iOException));
                this.changeState(n);
                return;
            }
            this.changeState(n);
            IJ.showStatus((String)"Saving completed.");
            this.plugin.unsavedPaths = false;
        } else if (object == this.loadButton) {
            YesNoCancelDialog yesNoCancelDialog;
            if (this.plugin.pathsUnsaved() && !(yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Warning", "There are unsaved paths. Do you really want to load new traces?")).yesPressed()) {
                return;
            }
            int n = this.currentState;
            this.changeState(11);
            this.plugin.loadTracings();
            this.changeState(n);
        } else if (object == this.importSWCButton) {
            YesNoCancelDialog yesNoCancelDialog;
            if (this.plugin.pathsUnsaved() && !(yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Warning", "There are unsaved paths. Do you really want to import an SWC file?")).yesPressed()) {
                return;
            }
            int n = this.currentState;
            this.changeState(11);
            this.plugin.importSWC();
            this.changeState(n);
        } else if (object == this.exportCSVButton) {
            FileInfo fileInfo = this.plugin.file_info;
            SaveDialog saveDialog = fileInfo == null ? new SaveDialog("Export as CSV...", "traces", ".csv") : new SaveDialog("Export as CSV...", fileInfo.directory, fileInfo.fileName, ".csv");
            if (saveDialog.getFileName() == null) {
                return;
            }
            String string = saveDialog.getDirectory() + saveDialog.getFileName();
            File file = new File(string);
            if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Export as CSV...", (String)("The file " + string + " already exists.\n" + "Do you want to replace it?"))) {
                return;
            }
            IJ.showStatus((String)("Exporting as CSV to " + string));
            int n = this.currentState;
            this.changeState(10);
            try {
                this.pathAndFillManager.exportToCSV(file);
            }
            catch (IOException iOException) {
                IJ.showStatus((String)"Exporting failed.");
                IJ.error((String)("Writing traces to '" + string + "' failed: " + iOException));
                this.changeState(n);
                return;
            }
            IJ.showStatus((String)"Export complete.");
            this.changeState(n);
        } else if (object == this.loadLabelsButton) {
            this.plugin.loadLabels();
        } else if (object == this.cancelSearch) {
            if (this.currentState == 2) {
                this.statusText.setText("Cancelling path search...");
                this.plugin.cancelSearch(false);
            } else if (this.currentState == 7) {
                this.statusText.setText("Cancelling Gaussian generation...");
                this.plugin.cancelGaussian();
            } else {
                IJ.error((String)"BUG! (wrong state for cancelling...)");
            }
        } else if (object == this.keepSegment) {
            this.plugin.confirmTemporary();
        } else if (object == this.junkSegment) {
            this.plugin.cancelTemporary();
        } else if (object == this.completePath) {
            this.plugin.finishedPath();
        } else if (object == this.cancelPath) {
            this.plugin.cancelPath();
        } else if (object == this.quitButton) {
            this.exitRequested();
        } else if (object == this.showOrHidePathList) {
            this.togglePathListVisibility();
        } else if (object == this.showOrHideFillList) {
            this.toggleFillListVisibility();
        } else if (object == this.editSigma) {
            double d = -1.0;
            double d2 = -1.0;
            while (d <= 0.0) {
                GenericDialog genericDialog = new GenericDialog("Select Scale of Structures");
                genericDialog.addMessage("Please enter the approximate radius of the structures you are looking for:");
                genericDialog.addNumericField("Sigma: ", this.plugin.getMinimumSeparation(), 4);
                genericDialog.addMessage("(The default value is the minimum voxel separation.)");
                genericDialog.addMessage("Please enter the scaling factor to apply:");
                genericDialog.addNumericField("Multiplier: ", 4.0, 4);
                genericDialog.addMessage("(If you're not sure, just leave this at 4.)");
                genericDialog.showDialog();
                if (genericDialog.wasCanceled()) {
                    return;
                }
                d = genericDialog.getNextNumber();
                if (d <= 0.0) {
                    IJ.error((String)"The value of sigma must be positive");
                }
                if (!((d2 = genericDialog.getNextNumber()) <= 0.0)) continue;
                IJ.error((String)"The value of the multiplier must be positive");
            }
            this.setSigma(d, true);
            this.setMultiplier(d2);
        } else if (object == this.sigmaWizard) {
            this.preSigmaPaletteState = this.currentState;
            this.changeState(8);
        }
    }

    public void sigmaPaletteClosing() {
        this.changeState(this.preSigmaPaletteState);
        this.setSigma(this.currentSigma, true);
    }

    public void setPathListVisible(boolean bl) {
        if (bl) {
            this.showOrHidePathList.setLabel("Hide Path List");
            this.pw.setVisible(true);
            this.pw.toFront();
        } else {
            this.showOrHidePathList.setLabel("Show Path List");
            this.pw.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePathListVisibility() {
        PathWindow pathWindow = this.pw;
        synchronized (pathWindow) {
            this.setPathListVisible(!this.pw.isVisible());
        }
    }

    public void setFillListVisible(boolean bl) {
        if (bl) {
            this.showOrHideFillList.setLabel("Hide Fill List");
            this.fw.setVisible(true);
            this.fw.toFront();
        } else {
            this.showOrHideFillList.setLabel("Show Fill List");
            this.fw.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleFillListVisibility() {
        FillWindow fillWindow = this.fw;
        synchronized (fillWindow) {
            this.setFillListVisible(!this.fw.isVisible());
        }
    }

    public void thresholdChanged(double d) {
        this.fw.thresholdChanged(d);
    }

    public boolean nearbySlices() {
        return this.viewPathChoice.getSelectedIndex() > 0;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.viewPathChoice) {
            this.plugin.justDisplayNearSlices(this.nearbySlices(), this.getEitherSide());
        } else if (object == this.preprocess) {
            if (this.preprocess.getState()) {
                this.turnOnHessian();
            } else {
                this.plugin.enableHessian(false);
            }
        } else if (object == this.usePreprocessed) {
            if (this.usePreprocessed.getState()) {
                this.preprocess.setState(false);
            }
        } else if (object == this.justShowSelected) {
            this.plugin.setShowOnlySelectedPaths(this.justShowSelected.getState());
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public int getEitherSide() {
        String string = this.nearbyField.getText();
        if (string.equals("")) {
            this.reportedInvalid = false;
            return 0;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 0 && !this.reportedInvalid) {
                IJ.error((String)"The number of slices either side cannot be negative.");
                this.reportedInvalid = true;
                return 0;
            }
            this.reportedInvalid = false;
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.reportedInvalid) {
                IJ.error((String)"The number of slices either side must be a non-negative integer.");
                this.reportedInvalid = true;
                return 0;
            }
            return 0;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.plugin.justDisplayNearSlices(this.nearbySlices(), this.getEitherSide());
    }

    public void threadStatus(SearchThread searchThread, int n) {
    }

    public void finished(SearchThread searchThread, boolean bl) {
    }

    public void pointsInSearch(SearchThread searchThread, int n, int n2) {
    }
}

