/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import tracing.Path;
import tracing.Simple_Neurite_Tracer;

class NormalPlaneCanvas
extends ImageCanvas {
    HashMap<Integer, Integer> indexToValidIndex = new HashMap();
    double maxScore = -1.0;
    double[] centre_x_positions;
    double[] centre_y_positions;
    double[] radiuses;
    double[] scores;
    double[] modeRadiuses;
    boolean[] valid;
    double[] angles;
    Path fittedPath;
    Simple_Neurite_Tracer tracerPlugin;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;
    int last_slice = -1;

    public NormalPlaneCanvas(ImagePlus imagePlus, Simple_Neurite_Tracer simple_Neurite_Tracer, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, boolean[] blArray, Path path) {
        super(imagePlus);
        int n;
        this.tracerPlugin = simple_Neurite_Tracer;
        this.centre_x_positions = dArray;
        this.centre_y_positions = dArray2;
        this.radiuses = dArray3;
        this.scores = dArray4;
        this.modeRadiuses = dArray5;
        this.angles = dArray6;
        this.valid = blArray;
        this.fittedPath = path;
        int n2 = imagePlus.getStackSize();
        for (n = 0; n < dArray4.length; ++n) {
            if (!(dArray4[n] > this.maxScore)) continue;
            this.maxScore = dArray4[n];
        }
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            this.indexToValidIndex.put(i, n);
            ++n;
        }
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    public void paint(Graphics graphics) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        super.paint(this.backBufferGraphics);
        this.drawOverlay(this.backBufferGraphics);
        graphics.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    protected void drawOverlay(Graphics graphics) {
        int n;
        int n2;
        Integer n3;
        int n4 = this.imp.getCurrentSlice() - 1;
        if (n4 != this.last_slice && (n3 = this.indexToValidIndex.get(n4)) != null) {
            n2 = this.fittedPath.getXUnscaled(n3);
            n = this.fittedPath.getYUnscaled(n3);
            int n5 = this.fittedPath.getZUnscaled(n3);
            this.tracerPlugin.setSlicesAllPanes(n2, n, n5);
            this.tracerPlugin.setCrosshair(n2, n, n5);
            this.last_slice = n4;
        }
        if (this.valid[n4]) {
            graphics.setColor(Color.RED);
        } else {
            graphics.setColor(Color.MAGENTA);
        }
        System.out.println("radiuses[" + n4 + "] is: " + this.radiuses[n4]);
        int n6 = this.screenXD(this.centre_x_positions[n4] - this.radiuses[n4]);
        n2 = this.screenYD(this.centre_y_positions[n4] - this.radiuses[n4]);
        graphics.fillRect(this.screenXD(this.centre_x_positions[n4]) - 2, this.screenYD(this.centre_y_positions[n4]) - 2, 5, 5);
        n = this.screenXD(this.centre_x_positions[n4] + this.radiuses[n4]) - this.screenXD(this.centre_x_positions[n4] - this.radiuses[n4]);
        graphics.drawOval(n6, n2, n, n);
        double d = this.scores[n4] / this.maxScore;
        int n7 = (int)(d * (double)(this.imp.getWidth() - 1));
        if (this.valid[n4]) {
            graphics.setColor(Color.GREEN);
        } else {
            graphics.setColor(Color.RED);
        }
        graphics.fillRect(this.screenX(0), this.screenY(0), this.screenX(n7) - this.screenX(0), this.screenY(2) - this.screenY(0));
        int n8 = this.screenXD((double)this.imp.getWidth() / 2.0 - this.modeRadiuses[n4]);
        int n9 = this.screenYD((double)this.imp.getHeight() / 2.0 - this.modeRadiuses[n4]);
        int n10 = this.screenXD((double)this.imp.getWidth() / 2.0 + this.modeRadiuses[n4]) - n8;
        graphics.setColor(Color.YELLOW);
        graphics.drawOval(n8, n9, n10, n10);
        graphics.setColor(Color.GREEN);
        double d2 = (double)(this.imp.getWidth() * 3) / 8.0;
        double d3 = (double)this.imp.getWidth() / 2.0;
        double d4 = (double)this.imp.getHeight() / 2.0;
        double d5 = this.angles[n4] / 2.0;
        double d6 = d3 + d2 * Math.sin(d5);
        double d7 = d4 - d2 * Math.cos(d5);
        double d8 = d3 + d2 * Math.sin(-d5);
        double d9 = d3 - d2 * Math.cos(d5);
        graphics.drawLine(this.screenXD(d3), this.screenYD(d4), this.screenXD(d6), this.screenYD(d7));
        graphics.drawLine(this.screenXD(d3), this.screenYD(d4), this.screenXD(d8), this.screenYD(d9));
    }
}

