/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.gui.ColorChooser;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import tracing.Simple_Neurite_Tracer;

public class PathColorsCanvas
extends Canvas
implements MouseListener {
    Simple_Neurite_Tracer plugin;
    private Color selectedColor;
    private Color deselectedColor;

    public PathColorsCanvas(Simple_Neurite_Tracer simple_Neurite_Tracer, int n, int n2) {
        this.plugin = simple_Neurite_Tracer;
        this.addMouseListener(this);
        this.setSize(n, n2);
        this.selectedColor = simple_Neurite_Tracer.selectedColor;
        this.deselectedColor = simple_Neurite_Tracer.deselectedColor;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        graphics.setColor(this.selectedColor);
        graphics.fillRect(0, 0, n3, n2);
        graphics.setColor(this.deselectedColor);
        graphics.fillRect(n3, 0, n - n3, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < this.getWidth() / 2) {
            ColorChooser colorChooser = new ColorChooser("Colour for selected paths", this.selectedColor, false);
            Color color = colorChooser.getColor();
            if (color == null) {
                return;
            }
            this.selectedColor = color;
            this.plugin.setSelectedColor(color);
        } else {
            ColorChooser colorChooser = new ColorChooser("Colour for deselected paths", this.deselectedColor, false);
            Color color = colorChooser.getColor();
            if (color == null) {
                return;
            }
            this.deselectedColor = color;
            this.plugin.setDeselectedColor(color);
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

