/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tracing.Path;
import tracing.PathAndFillListener;
import tracing.PathAndFillManager;
import tracing.Simple_Neurite_Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathWindow
extends JFrame
implements PathAndFillListener,
TreeSelectionListener,
ActionListener {
    JScrollPane scrollPane;
    HelpfulJTree tree;
    DefaultMutableTreeNode root;
    JPanel buttonPanel;
    JButton renameButton;
    JButton fitVolumeButton;
    JButton fillOutButton;
    JButton makePrimaryButton;
    JButton deleteButton;
    Simple_Neurite_Tracer plugin;
    PathAndFillManager pathAndFillManager;

    public Set<Path> getSelectedPaths() {
        HashSet<Path> hashSet = new HashSet<Path>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return hashSet;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == this.root) continue;
            Path path = (Path)defaultMutableTreeNode.getUserObject();
            hashSet.add(path);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Set<Path> set = this.getSelectedPaths();
        if (object == this.deleteButton) {
            if (set.isEmpty()) {
                IJ.error((String)"No paths were selected for deletion");
                return;
            }
            for (Path path : set) {
                path.disconnectFromAll();
                this.pathAndFillManager.deletePath(path);
            }
        } else if (object == this.makePrimaryButton) {
            if (set.size() != 1) {
                IJ.error((String)"You must have exactly one path selected");
                return;
            }
            Path[] pathArray = set.toArray(new Path[0]);
            Path path = pathArray[0];
            HashSet<Path> hashSet = new HashSet<Path>();
            path.setPrimary(true);
            hashSet.add(path);
            path.unsetPrimaryForConnected(hashSet);
            this.pathAndFillManager.resetListeners(null);
        } else if (object == this.fillOutButton) {
            if (set.size() < 1) {
                IJ.error((String)"You must have one or more paths in the list selected");
                return;
            }
            this.plugin.startFillingPaths(set);
        } else if (object == this.fitVolumeButton) {
            if (set.size() < 1) {
                IJ.error((String)"You must have one or more paths in the list selected");
                return;
            }
            boolean bl = this.allUsingFittedVersion(set);
            for (Path path : set) {
                if (bl) {
                    path.setUseFitted(false, this.plugin);
                    continue;
                }
                if (path.getUseFitted()) continue;
                if (path.fitted == null) {
                    Path path2 = path.fitCircles(40, this.plugin, (actionEvent.getModifiers() & 1) > 0);
                    path.setFitted(path2);
                    path.setUseFitted(true, this.plugin);
                    this.pathAndFillManager.addPath(path2);
                    continue;
                }
                path.setUseFitted(true, this.plugin);
            }
            this.pathAndFillManager.resetListeners(null);
        } else if (object == this.renameButton) {
            if (set.size() != 1) {
                IJ.error((String)"You must have exactly one path selected");
                return;
            }
            Path[] pathArray = set.toArray(new Path[0]);
            Path path = pathArray[0];
            String string = (String)JOptionPane.showInputDialog(this, "Rename this path to:", "Rename Path", -1, null, null, path.getName());
            if (string == null) {
                return;
            }
            if (string.length() == 0) {
                IJ.error((String)"The new name cannot be empty");
                return;
            }
            PathAndFillManager pathAndFillManager = this.pathAndFillManager;
            synchronized (pathAndFillManager) {
                if (this.pathAndFillManager.getPathFromName(string, false) != null) {
                    IJ.error((String)("There is already a path with that name ('" + string + "')"));
                    return;
                }
                path.setName(string);
                this.pathAndFillManager.resetListeners(null);
            }
        } else {
            IJ.error((String)"Unexpectedly got an event from an unknown source");
            return;
        }
    }

    public void updateButtonsNoneSelected() {
        this.renameButton.setEnabled(false);
        this.fitVolumeButton.setText("Fit Volume");
        this.fitVolumeButton.setEnabled(false);
        this.fillOutButton.setEnabled(false);
        this.makePrimaryButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    public void updateButtonsOneSelected(Path path) {
        this.renameButton.setEnabled(true);
        if (path.getUseFitted()) {
            this.fitVolumeButton.setText("Un-fit Volume");
        } else {
            this.fitVolumeButton.setText("Fit Volume");
        }
        this.fitVolumeButton.setEnabled(true);
        this.fillOutButton.setEnabled(true);
        this.makePrimaryButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    public boolean allSelectedUsingFittedVersion() {
        return this.allUsingFittedVersion(this.getSelectedPaths());
    }

    public boolean allUsingFittedVersion(Set<Path> set) {
        for (Path path : set) {
            if (path.getUseFitted()) continue;
            return false;
        }
        return true;
    }

    public void updateButtonsManySelected() {
        this.renameButton.setEnabled(false);
        if (this.allSelectedUsingFittedVersion()) {
            this.fitVolumeButton.setText("Un-fit Volumes");
        } else {
            this.fitVolumeButton.setText("Fit Volumes");
        }
        this.fitVolumeButton.setEnabled(true);
        this.fillOutButton.setEnabled(true);
        this.makePrimaryButton.setEnabled(false);
        this.deleteButton.setEnabled(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Set<Path> set = this.getSelectedPaths();
        if (set.isEmpty()) {
            this.pathAndFillManager.setSelected(new Path[0], this);
            this.updateButtonsNoneSelected();
        } else {
            Path[] pathArray = set.toArray(new Path[0]);
            if (set.isEmpty()) {
                this.updateButtonsNoneSelected();
            } else if (set.size() == 1) {
                this.updateButtonsOneSelected(pathArray[0]);
            } else {
                this.updateButtonsManySelected();
            }
            this.pathAndFillManager.setSelected(pathArray, this);
        }
        this.plugin.update3DViewerContents();
    }

    public PathWindow(PathAndFillManager pathAndFillManager, Simple_Neurite_Tracer simple_Neurite_Tracer) {
        this(pathAndFillManager, simple_Neurite_Tracer, 200, 60);
    }

    public PathWindow(PathAndFillManager pathAndFillManager, Simple_Neurite_Tracer simple_Neurite_Tracer, int n, int n2) {
        super("All Paths");
        this.pathAndFillManager = pathAndFillManager;
        this.plugin = simple_Neurite_Tracer;
        this.setBounds(n, n2, 540, 300);
        this.root = new DefaultMutableTreeNode("All Paths");
        this.tree = new HelpfulJTree(this.root);
        this.tree.addTreeSelectionListener(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        this.add((Component)this.scrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.renameButton = new JButton("Rename");
        this.fitVolumeButton = new JButton("Fit Volume");
        this.fillOutButton = new JButton("Fill Out");
        this.makePrimaryButton = new JButton("Make Primary");
        this.deleteButton = new JButton("Delete");
        this.buttonPanel.add(this.renameButton);
        this.buttonPanel.add(this.fitVolumeButton);
        this.buttonPanel.add(this.fillOutButton);
        this.buttonPanel.add(this.makePrimaryButton);
        this.buttonPanel.add(this.deleteButton);
        this.renameButton.addActionListener(this);
        this.fitVolumeButton.addActionListener(this);
        this.fillOutButton.addActionListener(this);
        this.makePrimaryButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.add((Component)this.buttonPanel, "Last");
    }

    void setButtonsEnabled(boolean bl) {
        this.renameButton.setEnabled(bl);
        this.fitVolumeButton.setEnabled(bl);
        this.fillOutButton.setEnabled(bl);
        this.makePrimaryButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
    }

    void getExpandedPaths(HelpfulJTree helpfulJTree, TreeModel treeModel, MutableTreeNode mutableTreeNode, HashSet hashSet) {
        int n = treeModel.getChildCount(mutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(mutableTreeNode, i);
            Path path = (Path)defaultMutableTreeNode.getUserObject();
            if (helpfulJTree.isExpanded(defaultMutableTreeNode.getPath())) {
                hashSet.add(path);
            }
            if (treeModel.isLeaf(defaultMutableTreeNode)) continue;
            this.getExpandedPaths(helpfulJTree, treeModel, defaultMutableTreeNode, hashSet);
        }
    }

    void setExpandedPaths(HelpfulJTree helpfulJTree, TreeModel treeModel, MutableTreeNode mutableTreeNode, HashSet hashSet, Path path) {
        int n = treeModel.getChildCount(mutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(mutableTreeNode, i);
            Path path2 = (Path)defaultMutableTreeNode.getUserObject();
            if (hashSet.contains(path2) || path != null && path == path2) {
                helpfulJTree.setExpanded(defaultMutableTreeNode.getPath(), true);
            }
            if (treeModel.isLeaf(defaultMutableTreeNode)) continue;
            this.setExpandedPaths(helpfulJTree, treeModel, defaultMutableTreeNode, hashSet, path);
        }
    }

    @Override
    public void setSelectedPaths(HashSet hashSet, Object object) {
        if (object == this) {
            return;
        }
        TreePath[] treePathArray = new TreePath[]{};
        this.tree.setSelectionPaths(treePathArray);
        this.setSelectedPaths(this.tree, this.tree.getModel(), this.root, hashSet);
    }

    void setSelectedPaths(HelpfulJTree helpfulJTree, TreeModel treeModel, MutableTreeNode mutableTreeNode, HashSet hashSet) {
        int n = treeModel.getChildCount(mutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(mutableTreeNode, i);
            Path path = (Path)defaultMutableTreeNode.getUserObject();
            if (hashSet.contains(path)) {
                helpfulJTree.setSelected(defaultMutableTreeNode.getPath());
            }
            if (treeModel.isLeaf(defaultMutableTreeNode)) continue;
            this.setSelectedPaths(helpfulJTree, treeModel, defaultMutableTreeNode, hashSet);
        }
    }

    @Override
    public void setPathList(String[] stringArray, Path path, boolean bl) {
        int n;
        Path[] pathArray;
        Serializable serializable;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        HashSet<Path> hashSet = new HashSet<Path>();
        HashSet hashSet2 = new HashSet();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                serializable = treePathArray[i];
                pathArray = (Path[])((TreePath)serializable).getLastPathComponent();
                if (pathArray == this.root) continue;
                Path path2 = (Path)pathArray.getUserObject();
                hashSet.add(path2);
            }
        }
        this.getExpandedPaths(this.tree, this.tree.getModel(), this.root, hashSet2);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("All Paths");
        serializable = new DefaultTreeModel(defaultMutableTreeNode);
        pathArray = this.pathAndFillManager.getPathsStructured();
        for (n = 0; n < pathArray.length; ++n) {
            Path path3 = pathArray[n];
            if (path3.fittedVersionOf != null) continue;
            this.addNode(defaultMutableTreeNode, path3, (DefaultTreeModel)serializable);
        }
        this.root = defaultMutableTreeNode;
        this.tree.setModel((TreeModel)((Object)serializable));
        ((DefaultTreeModel)serializable).reload();
        if (bl) {
            for (n = 0; n < this.tree.getRowCount(); ++n) {
                this.tree.expandRow(n);
            }
        } else {
            this.setExpandedPaths(this.tree, (TreeModel)((Object)serializable), this.root, hashSet2, path);
        }
        this.setSelectedPaths(this.tree, (TreeModel)((Object)serializable), this.root, hashSet);
    }

    public void addNode(MutableTreeNode mutableTreeNode, Path path, DefaultTreeModel defaultTreeModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(path);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        for (Path path2 : path.children) {
            this.addNode(defaultMutableTreeNode, path2, defaultTreeModel);
        }
    }

    @Override
    public void setFillList(String[] stringArray) {
    }

    public void setSelectedPaths(int[] nArray) {
    }

    public static class PathTreeNode
    extends DefaultMutableTreeNode {
    }

    public static class HelpfulJTree
    extends JTree {
        public HelpfulJTree(TreeNode treeNode) {
            super(treeNode);
        }

        public boolean isExpanded(Object[] objectArray) {
            TreePath treePath = new TreePath(objectArray);
            return this.isExpanded(treePath);
        }

        public void setExpanded(Object[] objectArray, boolean bl) {
            TreePath treePath = new TreePath(objectArray);
            this.setExpandedState(treePath, bl);
        }

        public void setSelected(Object[] objectArray) {
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
        }
    }
}

