/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import tracing.AutoPoint;
import tracing.TraceLoaderListener;

public class SinglePathsGraph {
    int width;
    int height;
    int depth;
    float spacing_x;
    float spacing_y;
    float spacing_z;
    Hashtable<Integer, AutoPoint> fromPosition = new Hashtable();
    HashSet<Long> directedLinks = new HashSet();

    public SinglePathsGraph(int n, int n2, int n3, double d, double d2, double d3) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.spacing_x = (float)d;
        this.spacing_y = (float)d2;
        this.spacing_z = (float)d3;
    }

    public AutoPoint get(int n, int n2, int n3) {
        int n4 = n + n2 * this.width + n3 * this.width * this.height;
        return this.fromPosition.get(n4);
    }

    public void addPoint(AutoPoint autoPoint, AutoPoint autoPoint2) {
        int n = autoPoint.x + autoPoint.y * this.width + autoPoint.z * this.width * this.height;
        AutoPoint autoPoint3 = this.fromPosition.get(n);
        if (autoPoint3 == null) {
            this.fromPosition.put(n, autoPoint);
        }
        if (autoPoint2 != null) {
            int n2 = autoPoint2.x + autoPoint2.y * this.width + autoPoint2.z * this.width * this.height;
            this.addLink(n2, n);
        }
    }

    void addLink(int n, int n2) {
        long l = (n << 32) + n2;
        this.directedLinks.add(l);
    }

    void addLink(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + n2 * this.width + n3 * this.width * this.height;
        int n8 = n4 + n5 * this.width + n6 * this.width * this.height;
        this.addLink(n7, n8);
    }

    void writeWavefrontObj(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        printWriter.println("# width: " + this.width);
        printWriter.println("# height: " + this.height);
        printWriter.println("# depth: " + this.depth);
        printWriter.println("# spacing_x: " + this.spacing_x);
        printWriter.println("# spacing_y: " + this.spacing_y);
        printWriter.println("# spacing_z: " + this.spacing_z);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Set<Integer> set = this.fromPosition.keySet();
        int n = 1;
        Iterator<Number> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            hashtable.put(n2, n);
            int n3 = n2 % this.width;
            int n4 = n2 / this.width % this.height;
            int n5 = n2 / (this.width * this.height) % this.depth;
            printWriter.println("v " + (float)n3 * this.spacing_x + " " + (float)n4 * this.spacing_y + " " + (float)n5 * this.spacing_z);
            ++n;
        }
        iterator = this.directedLinks.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            long l2 = l >> 32;
            long l3 = l & 0xFFFFFFFFFFFFFFFFL;
            int n6 = (int)l2;
            int n7 = (int)l3;
            int n8 = (Integer)hashtable.get(n6);
            int n9 = (Integer)hashtable.get(n7);
            printWriter.println("l " + n8 + " " + n9);
        }
        printWriter.print("g");
        printWriter.close();
    }

    public static int getNonNegativeIntAfterPrefix(String string, String string2) {
        try {
            String string3 = string.substring(string2.length());
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static float getNonNegativeFloatAfterPrefix(String string, String string2) {
        try {
            String string3 = string.substring(string2.length());
            return Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    static boolean loadWithListener(String string, TraceLoaderListener traceLoaderListener) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        float f = Float.MIN_VALUE;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.MIN_VALUE;
        try {
            String string2;
            String string3 = "# width: ";
            String string4 = "# height: ";
            String string5 = "# depth: ";
            String string6 = "# spacing_x: ";
            String string7 = "# spacing_y: ";
            String string8 = "# spacing_z: ";
            String string9 = "v ";
            String string10 = "l ";
            String string11 = "g ";
            int n4 = 1;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (null != (string2 = bufferedReader.readLine())) {
                int n5;
                Object[] objectArray;
                StringTokenizer stringTokenizer;
                if (string2.startsWith(string3)) {
                    n = SinglePathsGraph.getNonNegativeIntAfterPrefix(string2, string3);
                    traceLoaderListener.gotWidth(n);
                }
                if (string2.startsWith(string4)) {
                    n2 = SinglePathsGraph.getNonNegativeIntAfterPrefix(string2, string4);
                    traceLoaderListener.gotHeight(n2);
                }
                if (string2.startsWith(string5)) {
                    n3 = SinglePathsGraph.getNonNegativeIntAfterPrefix(string2, string5);
                    traceLoaderListener.gotDepth(n3);
                }
                if (string2.startsWith(string6)) {
                    f = SinglePathsGraph.getNonNegativeFloatAfterPrefix(string2, string6);
                    traceLoaderListener.gotSpacingX(f);
                }
                if (string2.startsWith(string7)) {
                    f2 = SinglePathsGraph.getNonNegativeFloatAfterPrefix(string2, string7);
                    traceLoaderListener.gotSpacingY(f2);
                }
                if (string2.startsWith(string8)) {
                    f3 = SinglePathsGraph.getNonNegativeFloatAfterPrefix(string2, string8);
                    traceLoaderListener.gotSpacingZ(f3);
                }
                if (string2.startsWith(string9)) {
                    stringTokenizer = new StringTokenizer(string2.substring(string9.length()), " ");
                    objectArray = new float[3];
                    n5 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        objectArray[n5] = Float.parseFloat(stringTokenizer.nextToken());
                        ++n5;
                    }
                    int n6 = Math.round(objectArray[0] / f);
                    int n7 = Math.round(objectArray[1] / f2);
                    int n8 = Math.round(objectArray[2] / f3);
                    traceLoaderListener.gotVertex(n4, objectArray[0], objectArray[1], objectArray[2], n6, n7, n8);
                }
                if (string2.startsWith(string10)) {
                    stringTokenizer = new StringTokenizer(string2.substring(string10.length()), " ");
                    objectArray = new int[2];
                    n5 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        objectArray[n5] = Integer.parseInt(stringTokenizer.nextToken());
                        ++n5;
                    }
                    traceLoaderListener.gotLine((int)objectArray[0], (int)objectArray[1]);
                }
                if (!string2.startsWith(string11)) continue;
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("IOException loading " + string + ": " + iOException));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(String string) throws IOException {
        PrintWriter printWriter = null;
        boolean bl = false;
        try {
            if (bl) {
                System.out.println("Creating, with compression...");
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(string)), "UTF-8"));
                System.out.println("Created, pw is: " + printWriter);
            } else {
                System.out.println("Creating, without compression...");
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
                System.out.println("Created, pw is: " + printWriter);
            }
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE connections [");
            printWriter.println("  <!ELEMENT tracings       (samplespacing,imagesize,path*,fill*)>");
            printWriter.println("  <!ELEMENT imagesize      EMPTY>");
            printWriter.println("  <!ELEMENT samplespacing  EMPTY>");
            printWriter.println("  <!ELEMENT path           (point+)>");
            printWriter.println("  <!ELEMENT point          EMPTY>");
            printWriter.println("  <!ELEMENT fill           (node*)>");
            printWriter.println("  <!ELEMENT node           EMPTY>");
            printWriter.println("  <!ATTLIST samplespacing  x             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  y             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  z             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  units         CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      width         CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      height        CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      depth         CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST path           id            CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST path           startson      CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startsindex   CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endson        CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endsindex     CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           reallength    CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          x             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST point          y             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST point          z             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST fill           id            CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST fill           frompaths     CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST fill           metric        CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST fill           threshold     CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           id            CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           x             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           y             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           z             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           previousid    CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST node           distance      CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           status        (open|closed)   #REQUIRED>");
            printWriter.println("]>");
            printWriter.println("");
            printWriter.println("<tracings>");
            printWriter.println("</tracings>");
        }
        finally {
            printWriter.close();
        }
    }
}

