/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.ComputeCurvatures;
import ij.ImagePlus;
import ij.measure.Calibration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tracing.Path;
import tracing.TracerThread;
import util.BatchOpener;

public class Test2DTracing {
    ImagePlus image;
    double startX = 73.539;
    double startY = 48.449;
    double endX = 1.73;
    double endY = 13.554;

    @Before
    public void setUp() {
        this.image = BatchOpener.openFirstChannel("test-images/c061AG-small-section-z-max.tif");
        Assert.assertNotNull((String)"Couldn't open the 2D test image", (Object)this.image);
    }

    @After
    public void tearDown() {
        this.image.close();
    }

    @Test
    public void testTracing() {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        Calibration calibration = this.image.getCalibration();
        if (calibration != null) {
            d4 = Math.min(Math.abs(calibration.pixelWidth), Math.min(Math.abs(calibration.pixelHeight), Math.abs(calibration.pixelDepth)));
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
        }
        int n = 0;
        TracerThread tracerThread = new TracerThread(this.image, 0.0f, 255.0f, -1, 100L, (int)(this.startX / d), (int)(this.startY / d2), 0, (int)(this.endX / d), (int)(this.endY / d2), 0, true, true, null, 1.0, null, false);
        tracerThread.run();
        Object object = tracerThread.getResult();
        Assert.assertNotNull((String)"Not path found", (Object)object);
        double d5 = ((Path)object).getRealLength();
        Assert.assertTrue((String)"Path length must be greater than 100 micrometres", (d5 > 100.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path length must be less than 105 micrometres", (d5 < 105.0 ? 1 : 0) != 0);
        n = tracerThread.pointsConsideredInSearch();
        int n2 = 0;
        object = new ComputeCurvatures(this.image, d4, null, calibration != null);
        ((ComputeCurvatures)object).run();
        TracerThread tracerThread2 = new TracerThread(this.image, 0.0f, 255.0f, -1, 100L, (int)(this.startX / d), (int)(this.startY / d2), 0, (int)(this.endX / d), (int)(this.endY / d2), 0, true, true, (ComputeCurvatures)object, 50.0, null, true);
        tracerThread2.run();
        Path path = tracerThread2.getResult();
        Assert.assertNotNull((String)"Not path found", (Object)path);
        double d6 = path.getRealLength();
        Assert.assertTrue((String)"Path length must be greater than 92 micrometres", (d6 > 92.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path length must be less than 96 micrometres", (d6 < 96.0 ? 1 : 0) != 0);
        n2 = tracerThread2.pointsConsideredInSearch();
        Assert.assertTrue((String)("Hessian-based analysis should reduce the points explored by at least a third; in fact went from " + n + " to " + n2), ((double)n2 * 1.5 < (double)n ? 1 : 0) != 0);
    }
}

