/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.plugin.HyperStackReducer;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class BatchOpener {
    private static final int TIFF_FIELD_TYPE_SHORT = 3;
    private static final int TIFF_FIELD_TYPE_LONG = 4;

    public static ImagePlus openFirstChannel(String string) {
        ImagePlus[] imagePlusArray = BatchOpener.open(string);
        if (imagePlusArray == null) {
            return null;
        }
        if (imagePlusArray.length == 0) {
            return null;
        }
        return imagePlusArray[0];
    }

    public static ImagePlus openParticularChannel(String string, int n) throws NoSuchChannelException {
        ImagePlus[] imagePlusArray = BatchOpener.open(string);
        if (imagePlusArray == null) {
            return null;
        }
        if (n >= imagePlusArray.length || n < 0) {
            throw new NoSuchChannelException("No channel " + n + " in file " + string + ", which has " + imagePlusArray.length + " channels.  (Channel indices start at zero.)");
        }
        return imagePlusArray[n];
    }

    public static ImagePlus[] open(String string) {
        ChannelsAndLoader channelsAndLoader;
        try {
            channelsAndLoader = BatchOpener.openToChannelsAndLoader(string);
        }
        catch (ImageLoaderException imageLoaderException) {
            return null;
        }
        if (channelsAndLoader == null) {
            return null;
        }
        return channelsAndLoader.channels;
    }

    public static ChannelsAndLoader openToChannelsAndLoader(String string) throws ImageLoaderException {
        File file;
        File file2;
        File file3;
        String[] stringArray;
        String string2 = null;
        File file4 = new File(string);
        byte[] byArray = new byte[132];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ((InputStream)fileInputStream).read(byArray, 0, 132);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            return null;
        }
        String string3 = file4.getName();
        String string4 = string3.toLowerCase();
        String string5 = file4.getParent();
        byte[] byArray2 = new byte[]{73, 73, 42, 0};
        byte[] byArray3 = new byte[]{77, 77, 0, 42};
        byte[] byArray4 = new byte[4];
        System.arraycopy(byArray, 0, byArray4, 0, 4);
        boolean bl = Arrays.equals(byArray2, byArray4);
        boolean bl2 = Arrays.equals(byArray3, byArray4);
        if (bl || bl2) {
            ImagePlus[] imagePlusArray;
            boolean bl3;
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "r");
            }
            catch (IOException iOException) {
                return null;
            }
            if (randomAccessFile == null) {
                return null;
            }
            try {
                bl3 = BatchOpener.findLSMTag(randomAccessFile, bl);
            }
            catch (IOException iOException) {
                return null;
            }
            if (bl3) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    return null;
                }
                string2 = "LSM_Toolbox";
                ClassLoader classLoader = IJ.getClassLoader();
                if (classLoader == null) {
                    throw new RuntimeException("IJ.getClassLoader() failed (!)");
                }
                try {
                    ImagePlus[] imagePlusArray2;
                    Class<?> clazz = classLoader.loadClass("org.imagearchive.lsm.toolbox.Reader");
                    Object obj = clazz.newInstance();
                    Class[] classArray = new Class[]{String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};
                    Method method = clazz.getMethod("open", classArray);
                    Object[] objectArray = new Object[]{file4.getParent(), file4.getName(), false, false, false};
                    Object object = method.invoke(obj, objectArray);
                    if (object instanceof CompositeImage) {
                        CompositeImage compositeImage = (CompositeImage)object;
                        imagePlusArray2 = BatchOpener.splitChannelsToArray((ImagePlus)compositeImage, true);
                    } else {
                        imagePlusArray2 = object instanceof ImagePlus ? new ImagePlus[]{(ImagePlus)object} : (ImagePlus[])object;
                    }
                    return new ChannelsAndLoader(imagePlusArray2, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ImageLoaderException("There was an illegal argument when trying to invoke the LSM_Toolbox reader: " + illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throw new ImageLoaderException("There was an exception thrown by the LSM_Toolbox plugin: " + throwable);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ImageLoaderException("The LSM_Toolbox plugin was not found: " + classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ImageLoaderException("Failed to instantiate the LSM_Toolbox reader: " + instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ImageLoaderException("IllegalAccessException when trying to create an instance of the LSM_Toolbox reader: " + illegalAccessException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ImageLoaderException("There was a NoSuchMethodException when trying to invoke the LSM_Toolbox reader: " + noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    throw new ImageLoaderException("There was a SecurityException when trying to invoke the LSM_Toolbox reader: " + securityException);
                }
            }
            byte[] byArray5 = new byte[44];
            long l = -1L;
            try {
                l = randomAccessFile.length() - 1658L;
                randomAccessFile.seek(l);
                randomAccessFile.readFully(byArray5);
            }
            catch (IOException iOException) {
                IJ.error((String)("Couldn't seek to " + l + " in " + string));
                return null;
            }
            String string6 = new String(byArray5);
            if (string6.equals("Leica Lasertechnik GmbH, Heidelberg, Germany")) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    IJ.error((String)"Couldn't close the Leica TIFF file.");
                    return null;
                }
                ClassLoader classLoader = IJ.getClassLoader();
                if (classLoader == null) {
                    IJ.error((String)"IJ.getClassLoader() failed (!)");
                    return null;
                }
                try {
                    string2 = "Leica_SP_Reader";
                    Class<?> clazz = classLoader.loadClass("leica.Leica_SP_Reader");
                    Object obj = clazz.newInstance();
                    Class[] classArray = new Class[]{String.class};
                    Object[] objectArray = new Object[]{string};
                    Method method = clazz.getMethod("run", classArray);
                    method.invoke(obj, objectArray);
                    classArray = new Class[]{};
                    objectArray = new Object[]{};
                    method = clazz.getMethod("getNumberOfChannels", classArray);
                    Integer n = (Integer)method.invoke(obj, objectArray);
                    if (n < 1) {
                        IJ.error((String)("Error: got " + n + " channels from " + string + " with the Leica SP Reader"));
                        return null;
                    }
                    ImagePlus[] imagePlusArray3 = new ImagePlus[n.intValue()];
                    for (int i = 0; i < n; ++i) {
                        classArray = new Class[]{Integer.TYPE};
                        objectArray = new Object[]{new Integer(i)};
                        method = clazz.getMethod("getImage", classArray);
                        imagePlusArray3[i] = (ImagePlus)method.invoke(obj, objectArray);
                    }
                    return new ChannelsAndLoader(imagePlusArray3, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IJ.error((String)("There was an illegal argument when trying to invoke a method on the Leica SP Reader plugin: " + illegalArgumentException));
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    IJ.error((String)("There was an exception thrown by the Leica SP Reader plugin: " + throwable));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    IJ.error((String)("The Leica SP Reader plugin was not found: " + classNotFoundException));
                }
                catch (InstantiationException instantiationException) {
                    IJ.error((String)("Failed to instantiate the Leica SP Reader plugin: " + instantiationException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    IJ.error((String)("IllegalAccessException when trying the Leica SP Reader plugin: " + illegalAccessException));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    IJ.error((String)("Couldn't find a method in the Leica SP Reader plugin: " + noSuchMethodException));
                }
                catch (SecurityException securityException) {
                    IJ.error((String)("There was a SecurityException when trying to invoke a method of the Leica SP Reader plugin: " + securityException));
                }
                return null;
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                IJ.error((String)"Couldn't close the file.");
                return null;
            }
            string2 = "ImageJ TIFF";
            ImagePlus imagePlus = IJ.openImage((String)string);
            if (imagePlus instanceof CompositeImage) {
                CompositeImage compositeImage = (CompositeImage)imagePlus;
                imagePlusArray = BatchOpener.splitChannelsToArray((ImagePlus)compositeImage, true);
            } else {
                imagePlusArray = new ImagePlus[]{imagePlus};
            }
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        ImagePlus imagePlus = null;
        if (byArray[54] == 57 && byArray[55] == 48) {
            string2 = "Biorad_Reader";
            imagePlus = (ImagePlus)IJ.runPlugIn((String)"Biorad_Reader", (String)string);
            if (imagePlus == null) {
                return null;
            }
            if (imagePlus != null && imagePlus.getWidth() == 0) {
                return null;
            }
            ImagePlus[] imagePlusArray = new ImagePlus[]{IJ.openImage((String)string)};
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 3) {
            string2 = "DM3_Reader";
            String[] stringArray2 = new String[]{"DM3_Reader", "io.DM3_Reader"};
            imagePlus = BatchOpener.findAndRunPlugIn(stringArray2, string);
            if (imagePlus == null) {
                return null;
            }
            if (imagePlus != null && imagePlus.getWidth() == 0) {
                return null;
            }
            ImagePlus[] imagePlusArray = new ImagePlus[]{IJ.openImage((String)string)};
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        if (byArray[0] == 105 && byArray[1] == 105 && byArray[2] == 105 && byArray[3] == 105 || byArray[0] == 109 && byArray[1] == 109 && byArray[2] == 109 && byArray[3] == 109) {
            string2 = "IPLab_Reader";
            String[] stringArray3 = new String[]{"IPLab_Reader", "io.IPLab_Reader"};
            imagePlus = BatchOpener.findAndRunPlugIn(stringArray3, string);
            if (imagePlus == null) {
                return null;
            }
            if (imagePlus != null && imagePlus.getWidth() == 0) {
                return null;
            }
            ImagePlus[] imagePlusArray = new ImagePlus[]{IJ.openImage((String)string)};
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        if (byArray[0] == 35 && byArray[1] == 32 && byArray[2] == 65 && byArray[3] == 109 && byArray[4] == 105 && byArray[5] == 114 && byArray[6] == 97 && byArray[7] == 77 && byArray[8] == 101 && byArray[9] == 115 && byArray[10] == 104 && byArray[11] == 32) {
            string2 = "AmiraMeshReader_";
            ImagePlus[] imagePlusArray = new ImagePlus[1];
            imagePlus = (ImagePlus)IJ.runPlugIn((String)"AmiraMeshReader_", (String)string);
            if (imagePlus == null) {
                return null;
            }
            imagePlusArray[0] = imagePlus;
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        if (byArray[0] == 75 && byArray[1] == 65 && byArray[2] == 74 && byArray[3] == 0) {
            string2 = "InstantImager_Reader";
            String[] stringArray4 = new String[]{"InstantImager_Reader", "io.InstantImager_Reader"};
            imagePlus = BatchOpener.findAndRunPlugIn(stringArray4, string);
            if (imagePlus == null) {
                return null;
            }
            if (imagePlus != null && imagePlus.getWidth() == 0) {
                return null;
            }
            ImagePlus[] imagePlusArray = new ImagePlus[]{imagePlus};
            return new ChannelsAndLoader(imagePlusArray, string2);
        }
        if ((string3.endsWith(".bin") || string3.endsWith(".bin.gz")) && (stringArray = (file3 = new File((file2 = new File((file = new File(string5, string3)).getParent())).getParent())).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file5;
                File file6 = new File(file3.getPath(), stringArray[i]);
                if (!file6.isDirectory() || !file6.getName().equals(file2.getName() + ".study") || !(file5 = new File(file6.getPath(), "images")).exists()) continue;
                string2 = "TorstenRaw_GZ_Reader";
                ImagePlus[] imagePlusArray = new ImagePlus[1];
                String[] stringArray5 = new String[]{"io.TorstenRaw_GZ_Reader", "TorstenRaw_GZ_Reader"};
                imagePlus = BatchOpener.findAndRunPlugIn(stringArray5, string);
                if (imagePlus == null) {
                    return null;
                }
                imagePlusArray[0] = imagePlus;
                return new ChannelsAndLoader(imagePlusArray, string2);
            }
        }
        return null;
    }

    private static ImagePlus findAndRunPlugIn(String[] stringArray, String string) {
        ImagePlus imagePlus = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                Class<?> clazz = Class.forName(string2);
                PlugIn plugIn = (PlugIn)clazz.newInstance();
                plugIn.run(string);
                imagePlus = (ImagePlus)plugIn;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return imagePlus;
    }

    public static ImagePlus[] splitChannelsToArray(ImagePlus imagePlus, boolean bl) {
        if (!imagePlus.isComposite()) {
            String string = "splitChannelsToArray was called on a non-composite image";
            IJ.error((String)string);
            return null;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        int n6 = imagePlus.getBitDepth();
        int n7 = n4 * n5;
        ImagePlus[] imagePlusArray = new ImagePlus[n3];
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        HyperStackReducer hyperStackReducer = new HyperStackReducer(imagePlus);
        for (int i = 1; i <= n3; ++i) {
            ImageStack imageStack = new ImageStack(n, n2, n7);
            imageStack.setPixels(imagePlus.getProcessor().getPixels(), 1);
            ImagePlus imagePlus2 = new ImagePlus("C" + i + "-" + imagePlus.getTitle(), imageStack);
            imageStack.setPixels(null, 1);
            imagePlus.setPosition(i, 1, 1);
            imagePlus2.setDimensions(1, n4, n5);
            hyperStackReducer.reduce(imagePlus2);
            imagePlus2.setOpenAsHyperStack(true);
            imagePlus2.setFileInfo(fileInfo);
            imagePlusArray[i - 1] = imagePlus2;
        }
        imagePlus.changes = false;
        if (bl) {
            imagePlus.close();
        }
        return imagePlusArray;
    }

    private static boolean findLSMTag(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        return BatchOpener.findTag(34412L, randomAccessFile, bl);
    }

    private static boolean findTag(long l, RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        short s = randomAccessFile.readShort();
        int n = BatchOpener.getShort(randomAccessFile, bl);
        int n2 = BatchOpener.getInt(randomAccessFile, bl);
        if (n != 42) {
            IJ.error((String)"Not really a TIFF file (BUG: should have been detected earlier.)");
        }
        if (n2 < 0) {
            IJ.error((String)"TIFF file probably corrupted: offset is negative");
            return false;
        }
        while (n2 > 0) {
            randomAccessFile.seek(n2);
            int n3 = BatchOpener.getShort(randomAccessFile, bl);
            if (n3 < 1 || n3 > 1000) {
                return false;
            }
            for (int i = 0; i < n3; ++i) {
                int n4 = BatchOpener.getShort(randomAccessFile, bl);
                int n5 = BatchOpener.getShort(randomAccessFile, bl);
                int n6 = BatchOpener.getInt(randomAccessFile, bl);
                int n7 = BatchOpener.getValue(randomAccessFile, bl, n5, n6);
                if ((long)n4 != l) continue;
                return true;
            }
            n2 = BatchOpener.getInt(randomAccessFile, bl);
        }
        return false;
    }

    private static int getInt(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        int n = randomAccessFile.read();
        int n2 = randomAccessFile.read();
        int n3 = randomAccessFile.read();
        int n4 = randomAccessFile.read();
        if (bl) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    private static int getShort(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        int n = randomAccessFile.read();
        int n2 = randomAccessFile.read();
        if (bl) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    private static int getValue(RandomAccessFile randomAccessFile, boolean bl, int n, int n2) throws IOException {
        int n3 = 0;
        if (n == 3 && n2 == 1) {
            n3 = BatchOpener.getShort(randomAccessFile, bl);
            int n4 = BatchOpener.getShort(randomAccessFile, bl);
        } else {
            n3 = BatchOpener.getInt(randomAccessFile, bl);
        }
        return n3;
    }

    public static class ChannelsAndLoader {
        public ImagePlus[] channels;
        public String loaderUsed;

        public ChannelsAndLoader(ImagePlus[] imagePlusArray, String string) {
            this.channels = imagePlusArray;
            this.loaderUsed = string;
        }
    }

    public static class ImageLoaderException
    extends Exception {
        ImageLoaderException(String string) {
            super(string);
        }
    }

    public static class NoSuchChannelException
    extends Exception {
        NoSuchChannelException(String string) {
            super(string);
        }
    }
}

