/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigInteger;

public class CombinationGenerator {
    private int[] a;
    private int n;
    private int r;
    private BigInteger numLeft;
    private BigInteger total;

    public CombinationGenerator(int n, int n2) {
        if (n2 > n) {
            throw new IllegalArgumentException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.r = n2;
        this.a = new int[n2];
        BigInteger bigInteger = CombinationGenerator.getFactorial(n);
        BigInteger bigInteger2 = CombinationGenerator.getFactorial(n2);
        BigInteger bigInteger3 = CombinationGenerator.getFactorial(n - n2);
        this.total = bigInteger.divide(bigInteger2.multiply(bigInteger3));
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(i)));
        }
        return bigInteger;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int n = this.r - 1;
        while (this.a[n] == this.n - this.r + n) {
            --n;
        }
        this.a[n] = this.a[n] + 1;
        for (int i = n + 1; i < this.r; ++i) {
            this.a[i] = this.a[n] + i - n;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }
}

