/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.File;

public class FileAndChannel {
    private String filePath;
    private File fileObject;
    private int channelZeroIndexed;
    private String channelString;

    public FileAndChannel(String string, int n) {
        this.filePath = string;
        this.channelZeroIndexed = n;
        this.channelString = "Channel : Ch" + (n + 1);
        this.fileObject = new File(this.filePath);
    }

    public boolean exists() {
        return this.fileObject.exists();
    }

    public boolean correctFileName(ImagePlus imagePlus) {
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        String string = fileInfo.directory;
        if (string.lastIndexOf(File.separatorChar) == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl = string.equals(this.fileObject.getParent()) && fileInfo.fileName.equals(this.fileObject.getName());
        return bl;
    }

    public boolean correctChannel(ImagePlus imagePlus) {
        boolean bl = -1 != imagePlus.getTitle().indexOf(this.channelString);
        return bl;
    }

    public int getChannelZeroIndexed() {
        return this.channelZeroIndexed;
    }

    public String getPath() {
        return this.filePath;
    }
}

