/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Collections;
import util.CancelDialog;

public class Find_Connected_Regions
implements PlugIn {
    public static final String PLUGIN_VERSION = "1.0";
    boolean pleaseStop = false;
    private static final byte IN_QUEUE = 1;
    private static final byte ADDED = 2;

    public void cancel() {
        this.pleaseStop = true;
    }

    public void run(String string) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        GenericDialog genericDialog = new GenericDialog("Find Connected Regions Options (version: 1.0)");
        genericDialog.addCheckbox("Allow diagonal connections?", false);
        genericDialog.addCheckbox("Display an image for each region?", true);
        genericDialog.addCheckbox("Display results table?", true);
        genericDialog.addCheckbox("Regions must have the same value?", true);
        genericDialog.addCheckbox("Start from point selection?", false);
        genericDialog.addNumericField("Regions for values over: ", 0.0, 0);
        genericDialog.addNumericField("Minimum number of points in a region", 1.0, 0);
        genericDialog.addNumericField("Stop after this number of regions are found: ", 1.0, 0);
        genericDialog.addMessage("(If number of regions is -1, find all of them.)");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        boolean bl4 = genericDialog.getNextBoolean();
        boolean bl5 = genericDialog.getNextBoolean();
        double d = genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        int n5 = (int)genericDialog.getNextNumber();
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No image to operate on.");
            return;
        }
        int n6 = imagePlus.getType();
        if (0 != n6 && 3 != n6 && 2 != n6) {
            IJ.error((String)"The image must be either 8 bit or 32 bit for this plugin.");
            return;
        }
        boolean bl6 = false;
        if (0 == n6 || 3 == n6) {
            bl6 = true;
        }
        if (!bl6 && bl4) {
            IJ.error((String)"You can only specify that each region must have the same value for 8 bit images.");
            return;
        }
        boolean bl7 = !bl4;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        if (bl5) {
            Roi roi = imagePlus.getRoi();
            if (roi == null) {
                IJ.error((String)"There's no point selected in the image.");
                return;
            }
            if (roi.getType() != 10) {
                IJ.error((String)"There's a selection in the image, but it's not a point selection.");
                return;
            }
            Polygon polygon = roi.getPolygon();
            if (polygon.npoints > 1) {
                IJ.error((String)"You can only have one point selected.");
                return;
            }
            n7 = polygon.xpoints[0];
            n8 = polygon.ypoints[0];
            n9 = imagePlus.getCurrentSlice() - 1;
            System.out.println("Fetched ROI with co-ordinates: " + polygon.xpoints[0] + ", " + polygon.ypoints[0]);
        }
        if ((n4 = imagePlus.getWidth()) * (n3 = imagePlus.getHeight()) * (n2 = imagePlus.getStackSize()) > Integer.MAX_VALUE) {
            IJ.error((String)"This stack is too large for this plugin (must have less than 2147483647 points.");
            return;
        }
        String[] stringArray = null;
        AmiraParameters amiraParameters = null;
        if (AmiraParameters.isAmiraLabelfield(imagePlus)) {
            amiraParameters = new AmiraParameters(imagePlus);
            stringArray = amiraParameters.getMaterialList();
        }
        ArrayList<Region> arrayList = new ArrayList<Region>();
        ImageStack imageStack = imagePlus.getStack();
        Object object2 = null;
        Object object3 = null;
        if (bl6) {
            object2 = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                object = (ByteProcessor)imageStack.getProcessor(n + 1);
                object2[n] = (byte[])object.getPixelsCopy();
            }
        } else {
            object3 = new float[n2][];
            for (n = 0; n < n2; ++n) {
                object = (FloatProcessor)imageStack.getProcessor(n + 1);
                object3[n] = (float[])object.getPixelsCopy();
            }
        }
        Calibration calibration = imagePlus.getCalibration();
        object = null;
        if (3 == n6) {
            object = imageStack.getColorModel();
        }
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        resultsTable.reset();
        CancelDialog cancelDialog = new CancelDialog(this);
        cancelDialog.show();
        boolean bl8 = true;
        while (!this.pleaseStop) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = -1;
            int n17 = -1;
            int n18 = -1;
            int n19 = -1;
            float f = Float.MIN_VALUE;
            int n20 = -1;
            float f2 = Float.MIN_VALUE;
            if (bl8 && bl5) {
                n16 = n7;
                n17 = n8;
                n18 = n9;
                if (bl6) {
                    n19 = object2[n18][n17 * n4 + n16] & 0xFF;
                } else {
                    f = object3[n18][n17 * n4 + n16];
                }
            } else if (bl6 && bl7) {
                for (n15 = 0; n15 < n2; ++n15) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            n14 = object2[n15][i * n4 + j] & 0xFF;
                            if (n14 <= n20) continue;
                            n16 = j;
                            n17 = i;
                            n18 = n15;
                            n20 = n14;
                        }
                    }
                }
                n19 = n20;
                if ((double)n19 < d) {
                    break;
                }
            } else if (bl6 && !bl7) {
                for (n15 = 0; n15 < n2 && n19 == -1; ++n15) {
                    block7: for (int i = 0; i < n3 && n19 == -1; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            n14 = object2[n15][i * n4 + j] & 0xFF;
                            if (!((double)n14 > d)) continue;
                            n16 = j;
                            n17 = i;
                            n18 = n15;
                            n19 = n14;
                            continue block7;
                        }
                    }
                }
                if (n19 == -1) {
                    break;
                }
            } else {
                assert (!bl6 && bl7);
                for (n15 = 0; n15 < n2; ++n15) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            float f3 = object3[n15][i * n4 + j];
                            if (!((double)f3 > d)) continue;
                            n16 = j;
                            n17 = i;
                            n18 = n15;
                            f2 = f3;
                        }
                    }
                }
                f = f2;
                if (f == Float.MIN_VALUE || (double)f < d) break;
            }
            bl8 = false;
            n15 = n19;
            float f4 = f;
            String string2 = null;
            if (stringArray != null) {
                string2 = stringArray[n15];
            }
            n14 = 0;
            int n21 = 1024;
            int[] nArray = new int[n21];
            byte[] byArray = new byte[n2 * n4 * n3];
            int n22 = n4 * (n18 * n3 + n17) + n16;
            byArray[n22] = 1;
            nArray[n14++] = n22;
            int n23 = 0;
            while (n14 > 0 && !this.pleaseStop) {
                int n24;
                n13 = n24 = nArray[--n14];
                int n25 = n24 / (n4 * n3);
                n12 = n24 % (n4 * n3);
                int n26 = n12 / n4;
                int n27 = n12 % n4;
                byArray[n13] = 2;
                if (bl6) {
                    object2[n25][n12] = 0;
                } else {
                    object3[n25][n12] = Float.MIN_VALUE;
                }
                ++n23;
                n11 = n27 - 1;
                n10 = n26 - 1;
                int n28 = n25 - 1;
                int n29 = n27 + 1;
                int n30 = n26 + 1;
                int n31 = n25 + 1;
                int n32 = n11 < 0 ? 0 : n11;
                int n33 = n10 < 0 ? 0 : n10;
                int n34 = n28 < 0 ? 0 : n28;
                int n35 = n29 >= n4 ? n4 - 1 : n29;
                int n36 = n30 >= n3 ? n3 - 1 : n30;
                int n37 = n31 >= n2 ? n2 - 1 : n31;
                for (int i = n34; i <= n37; ++i) {
                    for (int j = n33; j <= n36; ++j) {
                        for (int k = n32; k <= n35; ++k) {
                            int n38;
                            if (!(bl || k != n11 && k != n29 || j != n10 && j != n30 || i != n28 && i != n31)) continue;
                            int n39 = j * n4 + k;
                            int n40 = n4 * (i * n3 + j) + k;
                            if (bl6) {
                                n38 = object2[i][n39] & 0xFF;
                                if (bl4 ? n38 != n15 : (double)n38 <= d) {
                                    continue;
                                }
                            } else {
                                float f5 = object3[i][n39];
                                if ((double)f5 <= d) continue;
                            }
                            if (0 != byArray[n40]) continue;
                            byArray[n40] = 1;
                            if (n14 == n21) {
                                n38 = (int)((double)n21 * 1.2);
                                int[] nArray2 = new int[n38];
                                System.arraycopy(nArray, 0, nArray2, 0, n14);
                                nArray = nArray2;
                                n21 = n38;
                            }
                            nArray[n14++] = n40;
                        }
                    }
                }
            }
            if (this.pleaseStop) break;
            Region region = bl6 ? new Region(n15, string2, n23, bl4) : new Region(n23, bl4);
            if ((double)n23 < d2) continue;
            arrayList.add(region);
            n13 = bl6 ? (int)((byte)(object == null ? 255 : n15)) : -1;
            if (bl2) {
                ImageStack imageStack2 = new ImageStack(n4, n3);
                for (n12 = 0; n12 < n2; ++n12) {
                    byte[] byArray2 = new byte[n4 * n3];
                    for (int i = 0; i < n3; ++i) {
                        for (n11 = 0; n11 < n4; ++n11) {
                            n10 = byArray[n4 * (n12 * n3 + i) + n11];
                            if (n10 == 1) {
                                IJ.log((String)("BUG: point " + n11 + "," + i + "," + n12 + " is still marked as IN_QUEUE"));
                            }
                            if (n10 != 2) continue;
                            byArray2[i * n4 + n11] = n13;
                        }
                    }
                    ByteProcessor byteProcessor = new ByteProcessor(n4, n3);
                    byteProcessor.setPixels((Object)byArray2);
                    imageStack2.addSlice("", (ImageProcessor)byteProcessor);
                }
                if (3 == n6 && object != null) {
                    imageStack2.setColorModel((ColorModel)object);
                }
                ImagePlus imagePlus2 = new ImagePlus(region.toString(), imageStack2);
                if (calibration != null) {
                    imagePlus2.setCalibration(calibration);
                }
                if (amiraParameters != null) {
                    amiraParameters.setParameters(imagePlus2, true);
                }
                imagePlus2.show();
            }
            if (n5 <= 0 || arrayList.size() < n5) continue;
            break;
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        cancelDialog.dispose();
        for (Region region : arrayList) {
            System.out.println(region.toString());
            if (!bl3) continue;
            region.addRow(resultsTable);
        }
        if (bl3) {
            resultsTable.show("Results");
        }
    }

    private class Region
    implements Comparable {
        boolean byteImage;
        int points;
        String materialName;
        int value;
        boolean sameValue;

        Region(int n, String string, int n2, boolean bl) {
            this.byteImage = true;
            this.value = n;
            this.materialName = string;
            this.points = n2;
            this.sameValue = bl;
        }

        Region(int n, boolean bl) {
            this.byteImage = false;
            this.points = n;
            this.sameValue = bl;
        }

        public int compareTo(Object object) {
            Region region = (Region)object;
            return this.points < region.points ? -1 : (this.points > region.points ? 1 : 0);
        }

        public String toString() {
            if (this.byteImage) {
                String string = "";
                if (this.materialName != null) {
                    string = " (" + this.materialName + ")";
                }
                return "Region of value " + this.value + string + " containing " + this.points + " points";
            }
            return "Region containing " + this.points + " points";
        }

        public void addRow(ResultsTable resultsTable) {
            resultsTable.incrementCounter();
            if (this.byteImage) {
                if (this.sameValue) {
                    resultsTable.addValue("Value in Region", (double)this.value);
                }
                resultsTable.addValue("Points In Region", (double)this.points);
                if (this.materialName != null) {
                    resultsTable.addLabel("Material Name", this.materialName);
                }
            } else {
                resultsTable.addValue("Points in Region", (double)this.points);
            }
        }
    }
}

