/*
 * Decompiled with CFR 0.152.
 */
package util;

import pal.math.MultivariateFunction;
import util.IdealImager;

class FluorescenceOptimizer
implements MultivariateFunction {
    int n;
    IdealImager[] imagers;
    int minValue;
    int maxValue;
    double upperFluorescenceBound;
    double lowerFluorescenceBound;
    int[] valuesInImages;

    public FluorescenceOptimizer(IdealImager[] idealImagerArray) {
        this.imagers = idealImagerArray;
        this.n = idealImagerArray.length;
        if (this.n < 1) {
            throw new RuntimeException("There must be at least one IdealImager in the array");
        }
        this.minValue = idealImagerArray[0].minValue;
        this.maxValue = idealImagerArray[0].maxValue;
        for (int i = 1; i < this.n; ++i) {
            if (idealImagerArray[i].minValue == this.minValue && idealImagerArray[i].maxValue == this.maxValue) continue;
            throw new RuntimeException("All IdealImagers must have the same value range.");
        }
    }

    public void setRealResult(int[] nArray) {
        this.valuesInImages = nArray;
    }

    public double evaluate(double[] dArray) {
        float f = 0.0f;
        for (int i = 0; i < this.n; ++i) {
            int n = this.imagers[i].map(dArray[0]);
            int n2 = this.valuesInImages[i] - n;
            f += (float)(n2 * n2);
        }
        return f;
    }

    public double optimize(float f) {
        return -1.0;
    }

    public int getNumArguments() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getLowerBound(int n) {
        return this.lowerFluorescenceBound;
    }

    public double getUpperBound(int n) {
        return this.upperFluorescenceBound;
    }

    void setLowerBound(float f) {
        this.lowerFluorescenceBound = f;
    }

    void setUpperBound(float f) {
        this.upperFluorescenceBound = f;
    }
}

