/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.ImagePlus;
import ij.ImageStack;

public class Limits {
    public static float[] getStackLimits(ImagePlus imagePlus) {
        Object[] objectArray;
        int n = imagePlus.getStackSize();
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imagePlus.getBitDepth();
        int n3 = imagePlus.getType();
        if (n3 == 4) {
            throw new RuntimeException("Limits.getStackLimits can't do anything sensible with RGB images");
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            int n4;
            if (8 == n2) {
                objectArray = (byte[])imageStack.getPixels(i + 1);
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    int n5 = objectArray[n4] & 0xFF;
                    if ((float)n5 > f2) {
                        f2 = n5;
                    }
                    if (!((float)n5 < f)) continue;
                    f = n5;
                }
                continue;
            }
            if (n3 == 1) {
                objectArray = (short[])imageStack.getPixels(i + 1);
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    float f3 = objectArray[n4];
                    if ((float)f3 > f2) {
                        f2 = f3;
                    }
                    if (!((float)f3 < f)) continue;
                    f = f3;
                }
                continue;
            }
            if (n3 != 2) continue;
            objectArray = (float[])imageStack.getPixels(i + 1);
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                float f4 = objectArray[n4];
                if (f4 > f2) {
                    f2 = f4;
                }
                if (!(f4 < f)) continue;
                f = f4;
            }
        }
        objectArray = new float[]{f, f2};
        return objectArray;
    }
}

