/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class Mask_Of_Nearby_Points
implements PlugIn {
    public static final String PLUGIN_VERSION = "1.1";

    public void run(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No image to operate on.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        int n6 = imagePlus.getType();
        if (0 != n6 && 3 != n6) {
            IJ.error((String)"The image must be either 8 bit for this plugin.");
            return;
        }
        int n7 = imagePlus.getWidth();
        if (n7 * (n5 = imagePlus.getHeight()) * (n4 = imagePlus.getStackSize()) > Integer.MAX_VALUE) {
            IJ.error((String)"This stack is too large for this plugin (must have less than 2147483647 points.");
            return;
        }
        double d = calibration.pixelWidth * 3.0;
        GenericDialog genericDialog = new GenericDialog("Mask Of Nearby Points (version: 1.1)");
        genericDialog.addNumericField("Add to mask points within distance (" + calibration.getUnits() + ")", d, 4);
        genericDialog.addMessage("(The default distance is 3 times the separation of voxels.)");
        genericDialog.addNumericField("... of points with value at least: ", 128.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d2 = genericDialog.getNextNumber();
        double d3 = genericDialog.getNextNumber();
        int n8 = (int)(d2 / calibration.pixelWidth);
        int n9 = (int)(d2 / calibration.pixelHeight);
        int n10 = (int)(d2 / calibration.pixelDepth);
        float[][][] fArray = new float[2 * n10 + 1][2 * n9 + 1][2 * n8 + 1];
        for (int i = -n10; i <= n10; ++i) {
            for (int j = -n9; j <= n9; ++j) {
                for (n3 = -n8; n3 <= n8; ++n3) {
                    float f;
                    double d4 = (double)n3 * calibration.pixelWidth;
                    double d5 = (double)j * calibration.pixelHeight;
                    double d6 = (double)i * calibration.pixelDepth;
                    fArray[i + n10][j + n9][n3 + n8] = f = (float)Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
                }
            }
        }
        ImageStack imageStack = imagePlus.getStack();
        byte[][] byArrayArray = new byte[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            ByteProcessor byteProcessor = (ByteProcessor)imageStack.getProcessor(n3 + 1);
            byArrayArray[n3] = (byte[])byteProcessor.getPixelsCopy();
        }
        float[][] fArrayArray = new float[n4][];
        for (n2 = 0; n2 < n4; ++n2) {
            fArrayArray[n2] = new float[n7 * n5];
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n7; ++i) {
                    fArrayArray[n2][n * n7 + i] = Float.MAX_VALUE;
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            IJ.showProgress((double)((double)n2 / (double)n4));
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n7; ++i) {
                    int n11 = byArrayArray[n2][n * n7 + i] & 0xFF;
                    if ((double)n11 < d3) continue;
                    int n12 = -n8;
                    int n13 = -n9;
                    int n14 = -n10;
                    int n15 = n8;
                    int n16 = n9;
                    int n17 = n10;
                    if (i < n8) {
                        n12 = -i;
                    }
                    if (n < n9) {
                        n13 = -n;
                    }
                    if (n2 < n10) {
                        n14 = -n2;
                    }
                    if (i >= n7 - n8) {
                        n15 = n7 - 1 - i;
                    }
                    if (n >= n5 - n9) {
                        n16 = n5 - 1 - n;
                    }
                    if (n2 >= n4 - n10) {
                        n17 = n4 - 1 - n2;
                    }
                    for (int j = n14; j <= n17; ++j) {
                        for (int k = n13; k <= n16; ++k) {
                            for (int i2 = n12; i2 <= n15; ++i2) {
                                float f = fArray[j + n10][k + n9][i2 + n8];
                                int n18 = n2 + j;
                                int n19 = (n + k) * n7 + (i + i2);
                                if (!(f < fArrayArray[n18][n19])) continue;
                                fArrayArray[n18][n19] = f;
                            }
                        }
                    }
                }
            }
        }
        ImageStack imageStack2 = new ImageStack(n7, n5);
        for (n = 0; n < n4; ++n) {
            IJ.showProgress((double)((double)n / (double)n4));
            byte[] byArray = new byte[n7 * n5];
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n7; ++j) {
                    if (!((double)fArrayArray[n][i * n7 + j] <= d2)) continue;
                    byArray[i * n7 + j] = -1;
                }
            }
            ByteProcessor byteProcessor = new ByteProcessor(n7, n5);
            byteProcessor.setPixels((Object)byArray);
            imageStack2.addSlice("", (ImageProcessor)byteProcessor);
        }
        IJ.showProgress((double)1.0);
        ImagePlus imagePlus2 = new ImagePlus("within distance " + d2 + " of values over " + d3, imageStack2);
        imagePlus2.show();
    }
}

