/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class RGB_to_Luminance
implements PlugIn {
    public static ImagePlus convertToLuminance(ImagePlus imagePlus) {
        if (imagePlus.getType() != 4) {
            return null;
        }
        int n = imagePlus.getStackSize();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        Calibration calibration = imagePlus.getCalibration();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(n2, n3);
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray = (int[])imageStack.getPixels(i + 1);
            byArrayArray[i] = new byte[n2 * n3];
            for (int n4 : nArray) {
                int n5 = n4 & 0xFF;
                int n6 = (n4 & 0xFF00) >> 8;
                int n7 = (n4 & 0xFF0000) >> 16;
                int n8 = (int)Math.round(0.2126 * (double)n7 + 0.7152 * (double)n6 + 0.0722 * (double)n5);
                byArrayArray[i][var11_13] = (byte)n8;
            }
            ByteProcessor byteProcessor = new ByteProcessor(n2, n3);
            byteProcessor.setPixels((Object)byArrayArray[i]);
            imageStack2.addSlice("", (ImageProcessor)byteProcessor);
            IJ.showProgress((double)((float)i / (float)n));
        }
        ImagePlus imagePlus2 = new ImagePlus("luminance of " + imagePlus.getTitle(), imageStack2);
        imagePlus2.setCalibration(calibration);
        IJ.showProgress((double)1.0);
        return imagePlus2;
    }

    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No current image found");
            return;
        }
        if (imagePlus.getType() != 4) {
            IJ.error((String)"This plugin requires an RGB image");
            return;
        }
        ImagePlus imagePlus2 = RGB_to_Luminance.convertToLuminance(imagePlus);
        imagePlus2.show();
    }
}

