/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Panel;
import java.io.File;
import util.BatchOpener;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class Average_Images
implements PlugIn {
    float[][] cumulativeImage;
    int width;
    int height;
    int depth;
    int numberOfImages;
    float maxValue;

    public Average_Images() {
        this.reset();
    }

    public void reset() {
        this.cumulativeImage = null;
        this.width = -1;
        this.height = -1;
        this.depth = -1;
        this.numberOfImages = 0;
        this.maxValue = Float.MIN_VALUE;
    }

    public boolean add(ImagePlus imagePlus) {
        if (imagePlus.getBitDepth() != 8) {
            IJ.error((String)("All images must be 8 bit " + imagePlus + " doesn't."));
            return false;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        if (this.width < 0) {
            this.width = n;
            this.height = n2;
            this.depth = n3;
            this.cumulativeImage = new float[this.depth][];
            for (int i = 0; i < this.depth; ++i) {
                this.cumulativeImage[i] = new float[this.width * this.height];
            }
        } else if (this.width != n || this.height != n2 || this.depth != n3) {
            IJ.error((String)("Dimensions of " + imagePlus + " didn't match."));
            return false;
        }
        ImageStack imageStack = imagePlus.getStack();
        for (int i = 0; i < this.depth; ++i) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    float[] fArray = this.cumulativeImage[i];
                    int n4 = j * this.width + k;
                    fArray[n4] = fArray[n4] + (float)(byArray[j * this.width + k] & 0xFF);
                    float f = this.cumulativeImage[i][j * this.width + k];
                    if (!(f > this.maxValue)) continue;
                    this.maxValue = f;
                }
            }
        }
        ++this.numberOfImages;
        return true;
    }

    public ImagePlus getAverageImage(boolean bl) {
        IJ.showStatus((String)"Creating averaged image...");
        IJ.showProgress((double)0.0);
        ImageStack imageStack = new ImageStack(this.width, this.height);
        for (int i = 0; i < this.depth; ++i) {
            ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
            byte[] byArray = new byte[this.width * this.height];
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    float f = this.cumulativeImage[i][j * this.width + k];
                    int n = bl ? (int)(255.0f * f / (this.maxValue * (float)this.numberOfImages)) : (int)(f / (float)this.numberOfImages);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    byArray[j * this.width + k] = (byte)n;
                }
            }
            IJ.showProgress((double)(((double)i + 1.0) / (double)this.depth));
            byteProcessor.setPixels((Object)byArray);
            imageStack.addSlice(null, (ImageProcessor)byteProcessor);
        }
        IJ.showProgress((double)1.0);
        return new ImagePlus("average of " + this.numberOfImages + " images", imageStack);
    }

    public void run(String string) {
        File file;
        String string2;
        ImagePlus[] imagePlusArray;
        GenericDialog genericDialog = new GenericDialog("Average Images");
        FileGroup fileGroup = new FileGroup("foo");
        FileGroupDialog fileGroupDialog = new FileGroupDialog(fileGroup, false);
        genericDialog.addPanel((Panel)fileGroupDialog);
        genericDialog.addNumericField("Index of channels to use (starting at 1): ", 1.0, 0);
        genericDialog.addCheckbox("Rescale maximum to 255?", true);
        int n = (int)genericDialog.getNextNumber();
        --n;
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        int n2 = fileGroup.size();
        if (n2 < 1) {
            IJ.error((String)"No image files selected");
        }
        if ((imagePlusArray = BatchOpener.open(string2 = (file = (File)fileGroup.get(0)).getAbsolutePath())) == null) {
            IJ.error((String)("Couldn't open " + file));
            return;
        }
        if (n < 0 || n >= imagePlusArray.length) {
            IJ.error((String)("The image " + string2 + " doesn't have a channel " + n));
            return;
        }
        ImagePlus imagePlus = imagePlusArray[n];
        for (int i = 0; i < n2; ++i) {
            if (i != 0) {
                File file2 = (File)fileGroup.get(i);
                string2 = file2.getAbsolutePath();
                ImagePlus[] imagePlusArray2 = BatchOpener.open(string2);
                if (imagePlusArray2 == null) {
                    IJ.error((String)("Couldn't open the file " + string2));
                    return;
                }
                if (n < 0 || n >= imagePlusArray2.length) {
                    IJ.error((String)("The image " + string2 + " doesn't have a channel " + n));
                    return;
                }
                imagePlus = imagePlusArray2[n];
            }
            if (this.add(imagePlus)) continue;
            return;
        }
        ImagePlus imagePlus2 = this.getAverageImage(bl);
        imagePlus2.show();
    }
}

