/*
 * Decompiled with CFR 0.152.
 */
package vib;

class Bins {
    int bins;
    double minDistance;
    double maxDistance;
    double distanceRange;
    double[] sum;
    double[] sumSquared;
    int[] n;

    public Bins(int n, double d, double d2) {
        this.bins = n;
        this.minDistance = d;
        this.maxDistance = d2;
        this.distanceRange = d2 - d;
        this.sum = new double[n];
        this.sumSquared = new double[n];
        this.n = new int[n];
    }

    public void add(int n, double d) {
        double d2;
        int n2;
        if (n > 255) {
            System.out.println("Warning, adding value > 255: " + n);
        }
        if ((n2 = (int)Math.floor(d2 = (double)this.bins * (d - this.minDistance) / this.distanceRange)) >= this.bins) {
            n2 = this.bins - 1;
        }
        int n3 = n2;
        this.n[n3] = this.n[n3] + 1;
        int n4 = n2;
        this.sum[n4] = this.sum[n4] + (double)n;
        int n5 = n2;
        this.sumSquared[n5] = this.sumSquared[n5] + (double)(n * n);
    }

    public int numberOfBins() {
        return this.bins;
    }

    public double getMean(int n) {
        return this.sum[n] / (double)this.n[n];
    }

    public double getVariance(int n) {
        return this.sumSquared[n] / (double)this.n[n] - this.sum[n] * this.sum[n] / (double)(this.n[n] * this.n[n]);
    }

    public double getStandardDeviation(int n) {
        return Math.sqrt(this.getVariance(n));
    }

    public double getMinimumInBin(int n) {
        return (double)n * this.distanceRange / (double)this.bins;
    }

    public double getMaximumInBin(int n) {
        return (double)(n + 1) * this.distanceRange / (double)this.bins;
    }

    public double getMidPointOfBin(int n) {
        return (this.getMaximumInBin(n) + this.getMinimumInBin(n)) / 2.0;
    }

    public int getN(int n) {
        return this.n[n];
    }
}

