/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.FloatMatrix;
import vib.InterpolatedImage;
import vib.VIB;

public class DiffusionInterpol2_
implements PlugInFilter {
    ImagePlus image;
    FloatMatrix[] labelTransformations;
    FloatMatrix globalTransformation;
    boolean reuse;
    boolean remember;
    float tolerance;
    static float[][] savedDisplace;
    InterpolatedImage template;
    InterpolatedImage templateLabels;
    InterpolatedImage model;
    float[][] displace;
    int level;
    float accumX;
    float accumY;
    float accumZ;
    float curX;
    float curY;
    float curZ;
    int changed;
    int bchanged;
    float mdelta;
    final float MAGIC = 40711.22f;

    public void initialize(ImagePlus imagePlus, ImagePlus imagePlus2, ImagePlus imagePlus3, FloatMatrix[] floatMatrixArray, boolean bl, boolean bl2, float f) {
        this.image = imagePlus;
        this.template = new InterpolatedImage(imagePlus);
        this.templateLabels = new InterpolatedImage(imagePlus2);
        this.model = new InterpolatedImage(imagePlus3);
        this.labelTransformations = floatMatrixArray;
        this.reuse = bl;
        this.remember = bl2;
        this.tolerance = f;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("DiffusionInterpol2");
        if (!AmiraParameters.addAmiraLabelsList(genericDialog, "TemplateLabels")) {
            return;
        }
        if (!AmiraParameters.addAmiraMeshList(genericDialog, "Model")) {
            return;
        }
        if (savedDisplace != null) {
            genericDialog.addCheckbox("reuseDistortion", true);
        }
        genericDialog.addCheckbox("rememberDistortion", false);
        genericDialog.addStringField("LabelTransformationList", "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1");
        genericDialog.addNumericField("tolerance", 0.5, 2);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.template = new InterpolatedImage(this.image);
        this.templateLabels = new InterpolatedImage(WindowManager.getImage((String)genericDialog.getNextChoice()));
        this.model = new InterpolatedImage(WindowManager.getImage((String)genericDialog.getNextChoice()));
        this.reuse = genericDialog.getNextBoolean();
        this.remember = genericDialog.getNextBoolean();
        this.labelTransformations = FloatMatrix.parseMatrices(genericDialog.getNextString());
        this.tolerance = (float)genericDialog.getNextNumber();
        this.doit();
    }

    public void doit() {
        try {
            int n;
            this.reuse = savedDisplace != null ? this.reuse : false;
            FloatMatrix floatMatrix = FloatMatrix.fromCalibration(this.template.image);
            FloatMatrix floatMatrix2 = FloatMatrix.fromCalibration(this.model.image).inverse();
            for (n = 1; n < this.labelTransformations.length; ++n) {
                if (this.labelTransformations[n] == null) continue;
                this.labelTransformations[n] = floatMatrix2.times(this.labelTransformations[n].inverse().times(floatMatrix));
            }
            this.labelTransformations[0] = null;
            this.globalTransformation = FloatMatrix.average(this.labelTransformations);
            if (this.reuse) {
                this.displace = savedDisplace;
            } else {
                if (savedDisplace != null) {
                    savedDisplace = null;
                    System.gc();
                    System.gc();
                }
                this.displace = new float[this.template.d][];
                for (n = 0; n < this.template.d; ++n) {
                    this.displace[n] = new float[3 * this.template.w * this.template.h];
                }
                this.init();
                this.iterate(this.tolerance, false);
            }
            this.apply();
            savedDisplace = this.remember ? this.displace : (float[][])null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("Out of Memory: DiffusionInterpol2 " + Macro.getOptions());
            outOfMemoryError.printStackTrace();
            throw outOfMemoryError;
        }
    }

    private final void accumAdd(int n, int n2, int n3) {
        this.accumX += this.displace[n3][3 * (n2 * this.template.w + n) + 0];
        this.accumY += this.displace[n3][3 * (n2 * this.template.w + n) + 1];
        this.accumZ += this.displace[n3][3 * (n2 * this.template.w + n) + 2];
    }

    final void iterateInnerPart(int n, int n2, int n3) {
        if (this.templateLabels.getNoInterpol(n, n2, n3) != 0) {
            return;
        }
        this.accumZ = 0.0f;
        this.accumY = 0.0f;
        this.accumX = 0.0f;
        this.curX = this.displace[n3][3 * (n2 * this.template.w + n) + 0];
        this.curY = this.displace[n3][3 * (n2 * this.template.w + n) + 1];
        this.curZ = this.displace[n3][3 * (n2 * this.template.w + n) + 2];
        if (n3 - this.level >= 0) {
            this.accumAdd(n, n2, n3 - this.level);
        } else {
            this.accumAdd(n, n2, n3 + this.level);
        }
        if (n2 - this.level >= 0) {
            this.accumAdd(n, n2 - this.level, n3);
        } else {
            this.accumAdd(n, n2 + this.level, n3);
        }
        if (n - this.level >= 0) {
            this.accumAdd(n - this.level, n2, n3);
        } else {
            this.accumAdd(n + this.level, n2, n3);
        }
        if (n3 + this.level < this.template.d) {
            this.accumAdd(n, n2, n3 + this.level);
        } else {
            this.accumAdd(n, n2, n3 - this.level);
        }
        if (n2 + this.level < this.template.h) {
            this.accumAdd(n, n2 + this.level, n3);
        } else {
            this.accumAdd(n, n2 - this.level, n3);
        }
        if (n + this.level < this.template.w) {
            this.accumAdd(n + this.level, n2, n3);
        } else {
            this.accumAdd(n - this.level, n2, n3);
        }
        this.accumX /= 6.0f;
        this.accumY /= 6.0f;
        this.accumZ /= 6.0f;
        float f = Math.abs(this.curX - this.accumX) + Math.abs(this.curY - this.accumY) + Math.abs(this.curZ - this.accumZ);
        if (f > 0.0f) {
            this.displace[n3][3 * (n2 * this.template.w + n) + 0] = this.accumX;
            this.displace[n3][3 * (n2 * this.template.w + n) + 1] = this.accumY;
            this.displace[n3][3 * (n2 * this.template.w + n) + 2] = this.accumZ;
            if ((double)f > 0.1) {
                ++this.changed;
            }
            if (f > 3.0f) {
                ++this.changed;
            }
            if (f > this.mdelta) {
                this.mdelta = f;
            }
        }
    }

    float iterateNormal() {
        int n;
        int n2;
        int n3;
        int n4;
        this.bchanged = 0;
        this.changed = 0;
        this.mdelta = 0.0f;
        int n5 = this.template.w - 1 - (this.template.w - 1) % this.level;
        int n6 = this.template.h - 1 - (this.template.h - 1) % this.level;
        for (n4 = n3 = this.template.d - 1 - (this.template.d - 1) % this.level; n4 >= 0; n4 -= this.level) {
            for (n2 = n6; n2 >= 0; n2 -= this.level) {
                for (n = n5; n >= 0; n -= this.level) {
                    this.iterateInnerPart(n, n2, n4);
                }
            }
            IJ.showProgress((int)(1 * this.template.d - n4), (int)(2 * this.template.d));
        }
        for (n4 = 0; n4 < this.template.d; n4 += this.level) {
            for (n2 = 0; n2 < this.template.h; n2 += this.level) {
                for (n = 0; n < this.template.w; n += this.level) {
                    this.iterateInnerPart(n, n2, n4);
                }
            }
            IJ.showProgress((int)(this.template.d + n4 + 1), (int)(this.template.d * 2));
        }
        IJ.showProgress((int)1, (int)1);
        return this.mdelta;
    }

    void propagateInitial() {
        int n;
        int n2;
        int n3;
        VIB.showStatus("initializing domain (1/2)");
        for (n3 = 0; n3 < this.template.d; ++n3) {
            IJ.showProgress((int)n3, (int)(this.template.d * 2));
            for (n2 = 0; n2 < this.template.h; ++n2) {
                for (n = 0; n < this.template.w; ++n) {
                    if (this.displace[n3][3 * (n2 * this.template.w + n)] != 40711.22f) continue;
                    if (n3 > 0 && this.displace[n3 - 1][3 * (n2 * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2, n3 - 1);
                        continue;
                    }
                    if (n2 > 0 && this.displace[n3][3 * ((n2 - 1) * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2 - 1, n3);
                        continue;
                    }
                    if (n > 0 && this.displace[n3][3 * (n2 * this.template.w + n - 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n - 1, n2, n3);
                        continue;
                    }
                    if (n > 0 && n2 > 0 && this.displace[n3][3 * ((n2 - 1) * this.template.w + n - 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n - 1, n2 - 1, n3);
                        continue;
                    }
                    if (n > 0 && n3 > 0 && this.displace[n3 - 1][3 * (n2 * this.template.w + n - 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n - 1, n2, n3 - 1);
                        continue;
                    }
                    if (n2 > 0 && n3 > 0 && this.displace[n3 - 1][3 * ((n2 - 1) * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2 - 1, n3 - 1);
                        continue;
                    }
                    if (n <= 0 || n2 <= 0 || n3 <= 0 || this.displace[n3 - 1][3 * ((n2 - 1) * this.template.w + n - 1)] == 40711.22f) continue;
                    this.copyDisplace(n, n2, n3, n - 1, n2 - 1, n3 - 1);
                }
            }
        }
        VIB.showStatus("initializing domain (2/2)");
        for (n3 = this.template.d - 1; n3 >= 0; --n3) {
            IJ.showProgress((int)(2 * this.template.d - n3), (int)(2 * this.template.d));
            for (n2 = this.template.h - 1; n2 >= 0; --n2) {
                for (n = this.template.w - 1; n >= 0; --n) {
                    if (this.displace[n3][3 * (n2 * this.template.w + n)] != 40711.22f) continue;
                    if (n3 < this.template.d - 1 && this.displace[n3 + 1][3 * (n2 * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2, n3 + 1);
                        continue;
                    }
                    if (n2 < this.template.h - 1 && this.displace[n3][3 * ((n2 + 1) * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2 + 1, n3);
                        continue;
                    }
                    if (n < this.template.w - 1 && this.displace[n3][3 * (n2 * this.template.w + n + 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n + 1, n2, n3);
                        continue;
                    }
                    if (n < this.template.w - 1 && n2 < this.template.h - 1 && this.displace[n3][3 * ((n2 + 1) * this.template.w + n + 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n + 1, n2 + 1, n3);
                        continue;
                    }
                    if (n < this.template.w - 1 && n3 < this.template.d - 1 && this.displace[n3 + 1][3 * (n2 * this.template.w + n + 1)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n + 1, n2, n3 + 1);
                        continue;
                    }
                    if (n3 < this.template.d - 1 && n2 < this.template.h - 1 && this.displace[n3 + 1][3 * ((n2 + 1) * this.template.w + n)] != 40711.22f) {
                        this.copyDisplace(n, n2, n3, n, n2 + 1, n3 + 1);
                        continue;
                    }
                    if (n >= this.template.w - 1 || n2 >= this.template.h - 1 || n3 >= this.template.d - 1 || this.displace[n3 + 1][3 * ((n2 + 1) * this.template.w + n + 1)] == 40711.22f) continue;
                    this.copyDisplace(n, n2, n3, n + 1, n2 + 1, n3 + 1);
                }
            }
        }
        IJ.showProgress((int)1, (int)1);
        for (n3 = 0; n3 < this.template.d; ++n3) {
            for (n2 = 0; n2 < this.template.h; ++n2) {
                for (n = 0; n < this.template.w; ++n) {
                    if (this.displace[n3][3 * (n2 * this.template.w + n)] != 40711.22f) continue;
                    throw new RuntimeException("Nonono: " + n + ", " + n2 + ", " + n3);
                }
            }
        }
    }

    void copyDisplace(int n, int n2, int n3, int n4, int n5, int n6) {
        this.displace[n3][3 * (n2 * this.template.w + n) + 0] = this.displace[n6][3 * (n5 * this.template.w + n4) + 0];
        this.displace[n3][3 * (n2 * this.template.w + n) + 1] = this.displace[n6][3 * (n5 * this.template.w + n4) + 1];
        this.displace[n3][3 * (n2 * this.template.w + n) + 2] = this.displace[n6][3 * (n5 * this.template.w + n4) + 2];
    }

    void iterate(float f, boolean bl) {
        VIB.showStatus("diffusion in progress");
        int n = this.level = bl ? 1 : 16;
        while (this.level >= 1) {
            int n2 = 1;
            while (true) {
                float f2 = f / (float)this.level;
                VIB.showStatus("Level " + this.level + ", Iteration " + n2 + " (delta was " + this.mdelta + ")");
                if (this.iterateNormal() < f2) break;
                ++n2;
            }
            if (this.level > 1) {
                VIB.showStatus("Level jump " + this.level + " -> " + this.level / 2);
                for (n2 = 0; n2 < this.template.d; n2 += this.level) {
                    for (int i = 0; i < this.template.h; i += this.level) {
                        for (int j = 0; j < this.template.w; j += this.level) {
                            int n3 = n2 + this.level >= this.template.d ? this.template.d : n2 + this.level;
                            int n4 = i + this.level >= this.template.h ? this.template.h : i + this.level;
                            int n5 = j + this.level >= this.template.w ? this.template.w : j + this.level;
                            for (int k = n2; k < n3; ++k) {
                                for (int i2 = i; i2 < n4; ++i2) {
                                    for (int i3 = j; i3 < n5; ++i3) {
                                        if (this.templateLabels.getNoInterpol(i3, i2, k) != 0) continue;
                                        this.copyDisplace(i3, i2, k, j, i, n2);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.level /= 2;
        }
    }

    void apply() {
        VIB.showStatus("Applying displacement");
        for (int i = 0; i < this.template.d; ++i) {
            for (int j = 0; j < this.template.h; ++j) {
                for (int k = 0; k < this.template.w; ++k) {
                    this.globalTransformation.apply(k, j, i);
                    this.template.set(k, j, i, (byte)this.model.interpol.get(this.displace[i][3 * (j * this.template.w + k) + 0] + this.globalTransformation.x, this.displace[i][3 * (j * this.template.w + k) + 1] + this.globalTransformation.y, this.displace[i][3 * (j * this.template.w + k) + 2] + this.globalTransformation.z));
                }
            }
            IJ.showProgress((int)(i + 1), (int)this.template.d);
        }
        new AmiraParameters(this.model.image).setParameters(this.template.image, false);
    }

    void init() {
        VIB.showStatus("Initializing displacement");
        for (int i = 0; i < this.template.d; ++i) {
            IJ.showProgress((int)i, (int)this.template.d);
            for (int j = 0; j < this.template.h; ++j) {
                for (int k = 0; k < this.template.w; ++k) {
                    int n = this.templateLabels.getNoInterpol(k, j, i);
                    if (n > 0 && n < this.labelTransformations.length && this.labelTransformations[n] != null) {
                        this.labelTransformations[n].apply(k, j, i);
                        this.globalTransformation.apply(k, j, i);
                        this.displace[i][3 * (j * this.template.w + k) + 0] = this.labelTransformations[n].x - this.globalTransformation.x;
                        this.displace[i][3 * (j * this.template.w + k) + 1] = this.labelTransformations[n].y - this.globalTransformation.y;
                        this.displace[i][3 * (j * this.template.w + k) + 2] = this.labelTransformations[n].z - this.globalTransformation.z;
                        continue;
                    }
                    this.displace[i][3 * (j * this.template.w + k) + 0] = 0.0f;
                    this.displace[i][3 * (j * this.template.w + k) + 1] = 0.0f;
                    this.displace[i][3 * (j * this.template.w + k) + 2] = 0.0f;
                }
            }
        }
        IJ.showProgress((int)1, (int)1);
        this.propagateInitial();
    }

    public ImagePlus[] getDisplacementField() {
        int n;
        ImagePlus[] imagePlusArray = new ImagePlus[3];
        ImageStack[] imageStackArray = new ImageStack[3];
        for (n = 0; n < 3; ++n) {
            imageStackArray[n] = new ImageStack(this.template.w, this.template.h);
        }
        for (n = 0; n < this.template.d; ++n) {
            int n2;
            float[][] fArrayArray = new float[3][];
            for (n2 = 0; n2 < 3; ++n2) {
                fArrayArray[n2] = new float[this.template.w * this.template.h];
            }
            for (n2 = 0; n2 < this.template.w * this.template.h; ++n2) {
                for (int i = 0; i < 3; ++i) {
                    fArrayArray[i][n2] = this.displace[n][3 * n2 + i];
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                imageStackArray[n2].addSlice("", (Object)fArrayArray[n2]);
            }
        }
        for (n = 0; n < 3; ++n) {
            imagePlusArray[n] = new ImagePlus("displace " + n, imageStackArray[n]);
        }
        return imagePlusArray;
    }

    private void debugDisplace() {
        ImagePlus[] imagePlusArray = this.getDisplacementField();
        for (int i = 0; i < 3; ++i) {
            imagePlusArray[i].show();
        }
        throw new RuntimeException("debugDisplace");
    }
}

