/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import math3d.Point3d;
import vib.ElasticTransformedImage;
import vib.InterpolatedImage;

public class ElasticTransform_
implements PlugInFilter {
    ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Transform Parameters");
        AmiraParameters.addAmiraMeshList(genericDialog, "imageToTransform");
        genericDialog.addStringField("origPoints", "");
        genericDialog.addStringField("transPoints", "");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        ImagePlus imagePlus = WindowManager.getImage((String)genericDialog.getNextChoice());
        Point3d[] point3dArray = this.parsePoints(genericDialog.getNextString());
        Point3d[] point3dArray2 = this.parsePoints(genericDialog.getNextString());
        ElasticTransformedImage elasticTransformedImage = new ElasticTransformedImage(new InterpolatedImage(this.image), new InterpolatedImage(imagePlus), point3dArray, point3dArray2);
        elasticTransformedImage.getTransformed().image.show();
    }

    Point3d[] parsePoints(String string) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Point3d(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())));
        }
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = (Point3d)arrayList.get(i);
        }
        return point3dArray;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }
}

