/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.PixelPairs;
import ij.IJ;
import math3d.Bookstein;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;

public class ElasticTransformedImage {
    InterpolatedImage orig;
    InterpolatedImage trans;
    FastMatrix fromOrig;
    FastMatrix toTrans;
    Point3d[] origPoints;
    Point3d[] transPoints;
    PixelPairs measure;
    Bookstein b;
    double x;
    double y;
    double z;

    public ElasticTransformedImage(InterpolatedImage interpolatedImage, InterpolatedImage interpolatedImage2, Point3d[] point3dArray, FastMatrix fastMatrix) {
        this(interpolatedImage, interpolatedImage2, point3dArray, ElasticTransformedImage.transformPoints(point3dArray, fastMatrix));
    }

    public ElasticTransformedImage(InterpolatedImage interpolatedImage, InterpolatedImage interpolatedImage2, Point3d[] point3dArray, Point3d[] point3dArray2) {
        this.orig = interpolatedImage;
        this.trans = interpolatedImage2;
        this.fromOrig = FastMatrix.fromCalibration(interpolatedImage.image);
        this.toTrans = FastMatrix.fromCalibration(interpolatedImage2.image).inverse();
        this.origPoints = point3dArray;
        this.transPoints = point3dArray2;
        this.b = new Bookstein(point3dArray, point3dArray2);
    }

    public static Point3d[] transformPoints(Point3d[] point3dArray, FastMatrix fastMatrix) {
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            fastMatrix.apply(point3dArray[i]);
            point3dArray2[i] = fastMatrix.getResult();
        }
        return point3dArray2;
    }

    void apply(Point3d point3d) {
        this.b.apply(point3d);
        this.x = this.b.x;
        this.y = this.b.y;
        this.z = this.b.z;
    }

    void apply(int n, int n2, int n3) {
        this.fromOrig.apply(n, n2, n3);
        this.apply(this.fromOrig.getResult());
        this.toTrans.apply(this.x, this.y, this.z);
        this.x = this.toTrans.x;
        this.y = this.toTrans.y;
        this.z = this.toTrans.z;
    }

    InterpolatedImage getTransformed() {
        InterpolatedImage interpolatedImage = this.orig.cloneDimensionsOnly();
        for (int i = 0; i < interpolatedImage.d; ++i) {
            for (int j = 0; j < interpolatedImage.h; ++j) {
                for (int k = 0; k < interpolatedImage.w; ++k) {
                    this.apply(k, j, i);
                    double d = this.trans.interpol.get(this.x, this.y, this.z);
                    interpolatedImage.set(k, j, i, (byte)d);
                }
            }
            IJ.showProgress((int)(i + 1), (int)interpolatedImage.d);
        }
        return interpolatedImage;
    }

    double getDistance() {
        this.measure.reset();
        for (int i = 0; i < this.orig.d; ++i) {
            for (int j = 0; j < this.orig.h; ++j) {
                for (int k = 0; k < this.orig.w; ++k) {
                    double d = this.orig.getNoInterpol(k, j, i);
                    this.apply(k, j, i);
                    double d2 = this.trans.interpol.get(this.x, this.y, this.z);
                    this.measure.add((float)d, (float)d2);
                }
            }
        }
        return this.measure.distance();
    }
}

