/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.StringTokenizer;
import java.util.Vector;
import math3d.FastMatrixN;
import math3d.JacobiDouble;
import math3d.Point3d;
import math3d.Triangle;
import vib.FloatMatrix;

public class FastMatrix {
    public double x;
    public double y;
    public double z;
    protected double a00;
    protected double a01;
    protected double a02;
    protected double a03;
    protected double a10;
    protected double a11;
    protected double a12;
    protected double a13;
    protected double a20;
    protected double a21;
    protected double a22;
    protected double a23;

    public FastMatrix() {
    }

    public FastMatrix(double d) {
        this.a11 = this.a22 = d;
        this.a00 = this.a22;
    }

    public FastMatrix(double[][] dArray) {
        if (dArray.length != 3 && dArray.length != 4 || dArray[0].length != 4) {
            throw new RuntimeException("Wrong dimensions: " + dArray.length + "x" + dArray[0].length);
        }
        this.a00 = dArray[0][0];
        this.a01 = dArray[0][1];
        this.a02 = dArray[0][2];
        this.a03 = dArray[0][3];
        this.a10 = dArray[1][0];
        this.a11 = dArray[1][1];
        this.a12 = dArray[1][2];
        this.a13 = dArray[1][3];
        this.a20 = dArray[2][0];
        this.a21 = dArray[2][1];
        this.a22 = dArray[2][2];
        this.a23 = dArray[2][3];
    }

    public FastMatrix(FastMatrix fastMatrix) {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.a00 = fastMatrix.a00;
        this.a01 = fastMatrix.a01;
        this.a02 = fastMatrix.a02;
        this.a03 = fastMatrix.a03;
        this.a10 = fastMatrix.a10;
        this.a11 = fastMatrix.a11;
        this.a12 = fastMatrix.a12;
        this.a13 = fastMatrix.a13;
        this.a20 = fastMatrix.a20;
        this.a21 = fastMatrix.a21;
        this.a22 = fastMatrix.a22;
        this.a23 = fastMatrix.a23;
    }

    public FastMatrix copyFrom(FloatMatrix floatMatrix) {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.a00 = floatMatrix.a00;
        this.a01 = floatMatrix.a01;
        this.a02 = floatMatrix.a02;
        this.a03 = floatMatrix.a03;
        this.a10 = floatMatrix.a10;
        this.a11 = floatMatrix.a11;
        this.a12 = floatMatrix.a12;
        this.a13 = floatMatrix.a13;
        this.a20 = floatMatrix.a20;
        this.a21 = floatMatrix.a21;
        this.a22 = floatMatrix.a22;
        this.a23 = floatMatrix.a23;
        return this;
    }

    public boolean isJustTranslation() {
        FastMatrix fastMatrix = new FastMatrix(this);
        fastMatrix.a03 -= this.a03;
        fastMatrix.a13 -= this.a13;
        fastMatrix.a23 -= this.a23;
        return fastMatrix.isIdentity();
    }

    public boolean noTranslation() {
        double d = 1.0E-10;
        return Math.abs(this.a03) < d && Math.abs(this.a13) < d && Math.abs(this.a23) < d;
    }

    public FastMatrix composeWith(FastMatrix fastMatrix) {
        FastMatrix fastMatrix2 = this;
        FastMatrix fastMatrix3 = fastMatrix;
        FastMatrix fastMatrix4 = new FastMatrix();
        fastMatrix4.a00 = fastMatrix2.a00 * fastMatrix3.a00 + fastMatrix2.a10 * fastMatrix3.a01 + fastMatrix2.a20 * fastMatrix3.a02;
        fastMatrix4.a10 = fastMatrix2.a00 * fastMatrix3.a10 + fastMatrix2.a10 * fastMatrix3.a11 + fastMatrix2.a20 * fastMatrix3.a12;
        fastMatrix4.a20 = fastMatrix2.a00 * fastMatrix3.a20 + fastMatrix2.a10 * fastMatrix3.a21 + fastMatrix2.a20 * fastMatrix3.a22;
        fastMatrix4.a01 = fastMatrix2.a01 * fastMatrix3.a00 + fastMatrix2.a11 * fastMatrix3.a01 + fastMatrix2.a21 * fastMatrix3.a02;
        fastMatrix4.a11 = fastMatrix2.a01 * fastMatrix3.a10 + fastMatrix2.a11 * fastMatrix3.a11 + fastMatrix2.a21 * fastMatrix3.a12;
        fastMatrix4.a21 = fastMatrix2.a01 * fastMatrix3.a20 + fastMatrix2.a11 * fastMatrix3.a21 + fastMatrix2.a21 * fastMatrix3.a22;
        fastMatrix4.a02 = fastMatrix2.a02 * fastMatrix3.a00 + fastMatrix2.a12 * fastMatrix3.a01 + fastMatrix2.a22 * fastMatrix3.a02;
        fastMatrix4.a12 = fastMatrix2.a02 * fastMatrix3.a10 + fastMatrix2.a12 * fastMatrix3.a11 + fastMatrix2.a22 * fastMatrix3.a12;
        fastMatrix4.a22 = fastMatrix2.a02 * fastMatrix3.a20 + fastMatrix2.a12 * fastMatrix3.a21 + fastMatrix2.a22 * fastMatrix3.a22;
        fastMatrix4.a03 = fastMatrix2.a03 * fastMatrix3.a00 + fastMatrix2.a13 * fastMatrix3.a01 + fastMatrix2.a23 * fastMatrix3.a02 + fastMatrix3.a03;
        fastMatrix4.a13 = fastMatrix2.a03 * fastMatrix3.a10 + fastMatrix2.a13 * fastMatrix3.a11 + fastMatrix2.a23 * fastMatrix3.a12 + fastMatrix3.a13;
        fastMatrix4.a23 = fastMatrix2.a03 * fastMatrix3.a20 + fastMatrix2.a13 * fastMatrix3.a21 + fastMatrix2.a23 * fastMatrix3.a22 + fastMatrix3.a23;
        return fastMatrix4;
    }

    public FastMatrix[] decompose() {
        FastMatrix[] fastMatrixArray = new FastMatrix[2];
        fastMatrixArray[0].a00 = this.a00;
        fastMatrixArray[0].a01 = this.a01;
        fastMatrixArray[0].a02 = this.a02;
        fastMatrixArray[0].a10 = this.a10;
        fastMatrixArray[0].a11 = this.a11;
        fastMatrixArray[0].a12 = this.a12;
        fastMatrixArray[0].a20 = this.a20;
        fastMatrixArray[0].a21 = this.a21;
        fastMatrixArray[0].a22 = this.a22;
        fastMatrixArray[1].a03 = this.a03;
        fastMatrixArray[1].a13 = this.a13;
        fastMatrixArray[1].a23 = this.a23;
        return fastMatrixArray;
    }

    public FastMatrix plus(FastMatrix fastMatrix) {
        FastMatrix fastMatrix2 = new FastMatrix();
        fastMatrix2.a00 = fastMatrix.a00 + this.a00;
        fastMatrix2.a01 = fastMatrix.a01 + this.a01;
        fastMatrix2.a02 = fastMatrix.a02 + this.a02;
        fastMatrix2.a03 = fastMatrix.a03 + this.a03;
        fastMatrix2.a10 = fastMatrix.a10 + this.a10;
        fastMatrix2.a11 = fastMatrix.a11 + this.a11;
        fastMatrix2.a12 = fastMatrix.a12 + this.a12;
        fastMatrix2.a13 = fastMatrix.a13 + this.a13;
        fastMatrix2.a20 = fastMatrix.a20 + this.a20;
        fastMatrix2.a21 = fastMatrix.a21 + this.a21;
        fastMatrix2.a22 = fastMatrix.a22 + this.a22;
        fastMatrix2.a23 = fastMatrix.a23 + this.a23;
        return fastMatrix2;
    }

    public void apply(double d, double d2, double d3) {
        this.x = d * this.a00 + d2 * this.a01 + d3 * this.a02 + this.a03;
        this.y = d * this.a10 + d2 * this.a11 + d3 * this.a12 + this.a13;
        this.z = d * this.a20 + d2 * this.a21 + d3 * this.a22 + this.a23;
    }

    public void apply(Point3d point3d) {
        this.x = point3d.x * this.a00 + point3d.y * this.a01 + point3d.z * this.a02 + this.a03;
        this.y = point3d.x * this.a10 + point3d.y * this.a11 + point3d.z * this.a12 + this.a13;
        this.z = point3d.x * this.a20 + point3d.y * this.a21 + point3d.z * this.a22 + this.a23;
    }

    public void apply(double[] dArray) {
        this.x = dArray[0] * this.a00 + dArray[1] * this.a01 + dArray[2] * this.a02 + this.a03;
        this.y = dArray[0] * this.a10 + dArray[1] * this.a11 + dArray[2] * this.a12 + this.a13;
        this.z = dArray[0] * this.a20 + dArray[1] * this.a21 + dArray[2] * this.a22 + this.a23;
    }

    public void applyWithoutTranslation(double d, double d2, double d3) {
        this.x = d * this.a00 + d2 * this.a01 + d3 * this.a02;
        this.y = d * this.a10 + d2 * this.a11 + d3 * this.a12;
        this.z = d * this.a20 + d2 * this.a21 + d3 * this.a22;
    }

    public void applyWithoutTranslation(Point3d point3d) {
        this.x = point3d.x * this.a00 + point3d.y * this.a01 + point3d.z * this.a02;
        this.y = point3d.x * this.a10 + point3d.y * this.a11 + point3d.z * this.a12;
        this.z = point3d.x * this.a20 + point3d.y * this.a21 + point3d.z * this.a22;
    }

    public Point3d getResult() {
        return new Point3d(this.x, this.y, this.z);
    }

    public FastMatrix scale(double d, double d2, double d3) {
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = this.a00 * d;
        fastMatrix.a01 = this.a01 * d;
        fastMatrix.a02 = this.a02 * d;
        fastMatrix.a03 = this.a03 * d;
        fastMatrix.a10 = this.a10 * d2;
        fastMatrix.a11 = this.a11 * d2;
        fastMatrix.a12 = this.a12 * d2;
        fastMatrix.a13 = this.a13 * d2;
        fastMatrix.a20 = this.a20 * d3;
        fastMatrix.a21 = this.a21 * d3;
        fastMatrix.a22 = this.a22 * d3;
        fastMatrix.a23 = this.a23 * d3;
        return fastMatrix;
    }

    public FastMatrix times(FastMatrix fastMatrix) {
        FastMatrix fastMatrix2 = new FastMatrix();
        fastMatrix2.a00 = fastMatrix.a00 * this.a00 + fastMatrix.a10 * this.a01 + fastMatrix.a20 * this.a02;
        fastMatrix2.a10 = fastMatrix.a00 * this.a10 + fastMatrix.a10 * this.a11 + fastMatrix.a20 * this.a12;
        fastMatrix2.a20 = fastMatrix.a00 * this.a20 + fastMatrix.a10 * this.a21 + fastMatrix.a20 * this.a22;
        fastMatrix2.a01 = fastMatrix.a01 * this.a00 + fastMatrix.a11 * this.a01 + fastMatrix.a21 * this.a02;
        fastMatrix2.a11 = fastMatrix.a01 * this.a10 + fastMatrix.a11 * this.a11 + fastMatrix.a21 * this.a12;
        fastMatrix2.a21 = fastMatrix.a01 * this.a20 + fastMatrix.a11 * this.a21 + fastMatrix.a21 * this.a22;
        fastMatrix2.a02 = fastMatrix.a02 * this.a00 + fastMatrix.a12 * this.a01 + fastMatrix.a22 * this.a02;
        fastMatrix2.a12 = fastMatrix.a02 * this.a10 + fastMatrix.a12 * this.a11 + fastMatrix.a22 * this.a12;
        fastMatrix2.a22 = fastMatrix.a02 * this.a20 + fastMatrix.a12 * this.a21 + fastMatrix.a22 * this.a22;
        this.apply(fastMatrix.a03, fastMatrix.a13, fastMatrix.a23);
        fastMatrix2.a03 = this.x;
        fastMatrix2.a13 = this.y;
        fastMatrix2.a23 = this.z;
        return fastMatrix2;
    }

    public double det() {
        double d = this.a11 * this.a22 - this.a12 * this.a21;
        double d2 = this.a10 * this.a22 - this.a12 * this.a20;
        double d3 = this.a10 * this.a21 - this.a11 * this.a20;
        double d4 = this.a01 * this.a22 - this.a02 * this.a21;
        double d5 = this.a00 * this.a22 - this.a02 * this.a20;
        double d6 = this.a00 * this.a21 - this.a01 * this.a20;
        double d7 = this.a01 * this.a12 - this.a02 * this.a11;
        double d8 = this.a00 * this.a12 - this.a02 * this.a10;
        double d9 = this.a00 * this.a11 - this.a01 * this.a10;
        return this.a00 * d - this.a01 * d2 + this.a02 * d3;
    }

    private FastMatrix invert3x3() {
        double d = this.a11 * this.a22 - this.a12 * this.a21;
        double d2 = this.a10 * this.a22 - this.a12 * this.a20;
        double d3 = this.a10 * this.a21 - this.a11 * this.a20;
        double d4 = this.a01 * this.a22 - this.a02 * this.a21;
        double d5 = this.a00 * this.a22 - this.a02 * this.a20;
        double d6 = this.a00 * this.a21 - this.a01 * this.a20;
        double d7 = this.a01 * this.a12 - this.a02 * this.a11;
        double d8 = this.a00 * this.a12 - this.a02 * this.a10;
        double d9 = this.a00 * this.a11 - this.a01 * this.a10;
        double d10 = this.a00 * d - this.a01 * d2 + this.a02 * d3;
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = d / d10;
        fastMatrix.a01 = -d4 / d10;
        fastMatrix.a02 = d7 / d10;
        fastMatrix.a10 = -d2 / d10;
        fastMatrix.a11 = d5 / d10;
        fastMatrix.a12 = -d8 / d10;
        fastMatrix.a20 = d3 / d10;
        fastMatrix.a21 = -d6 / d10;
        fastMatrix.a22 = d9 / d10;
        return fastMatrix;
    }

    public FastMatrix inverse() {
        FastMatrix fastMatrix = this.invert3x3();
        fastMatrix.apply(-this.a03, -this.a13, -this.a23);
        fastMatrix.a03 = fastMatrix.x;
        fastMatrix.a13 = fastMatrix.y;
        fastMatrix.a23 = fastMatrix.z;
        return fastMatrix;
    }

    public static FastMatrix rotate(double d, int n) {
        FastMatrix fastMatrix = new FastMatrix();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        switch (n) {
            case 0: {
                fastMatrix.a11 = fastMatrix.a22 = d2;
                fastMatrix.a21 = d3;
                fastMatrix.a12 = -fastMatrix.a21;
                fastMatrix.a00 = 1.0;
                break;
            }
            case 1: {
                fastMatrix.a00 = fastMatrix.a22 = d2;
                fastMatrix.a20 = d3;
                fastMatrix.a02 = -fastMatrix.a20;
                fastMatrix.a11 = 1.0;
                break;
            }
            case 2: {
                fastMatrix.a00 = fastMatrix.a11 = d2;
                fastMatrix.a10 = d3;
                fastMatrix.a01 = -fastMatrix.a10;
                fastMatrix.a22 = 1.0;
                break;
            }
            default: {
                throw new RuntimeException("Illegal axis: " + n);
            }
        }
        return fastMatrix;
    }

    public static FastMatrix rotateFromTo(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= d7;
        d2 /= d7;
        d3 /= d7;
        d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d8 = d2 * (d6 /= d7) - d3 * (d5 /= d7);
        double d9 = d3 * (d4 /= d7) - d * d6;
        double d10 = d * d5 - d2 * d4;
        double d11 = d9 * d3 - d10 * d2;
        double d12 = d10 * d - d8 * d3;
        double d13 = d8 * d2 - d9 * d;
        double d14 = d9 * d6 - d10 * d5;
        double d15 = d10 * d4 - d8 * d6;
        double d16 = d8 * d5 - d9 * d4;
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = d;
        fastMatrix.a01 = d2;
        fastMatrix.a02 = d3;
        fastMatrix.a10 = d8;
        fastMatrix.a11 = d9;
        fastMatrix.a12 = d10;
        fastMatrix.a20 = d11;
        fastMatrix.a21 = d12;
        fastMatrix.a22 = d13;
        FastMatrix fastMatrix2 = new FastMatrix();
        fastMatrix2.a00 = d4;
        fastMatrix2.a01 = d8;
        fastMatrix2.a02 = d14;
        fastMatrix2.a10 = d5;
        fastMatrix2.a11 = d9;
        fastMatrix2.a12 = d15;
        fastMatrix2.a20 = d6;
        fastMatrix2.a21 = d10;
        fastMatrix2.a22 = d16;
        return fastMatrix2.times(fastMatrix);
    }

    public static double dotProduct(double[] dArray, double[] dArray2) {
        double d = 0.0;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("In dotProduct, the vectors must be of the same length.");
        }
        if (dArray.length < 1) {
            throw new IllegalArgumentException("Can't dotProduct vectors of zero length.");
        }
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double sizeSquared(double[] dArray) {
        return FastMatrix.dotProduct(dArray, dArray);
    }

    public static double size(double[] dArray) {
        return Math.sqrt(FastMatrix.dotProduct(dArray, dArray));
    }

    public static double angleBetween(double[] dArray, double[] dArray2) {
        return Math.acos(FastMatrix.dotProduct(dArray, dArray2) / (FastMatrix.size(dArray) * FastMatrix.size(dArray2)));
    }

    public static double[] crossProduct(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public static double[] normalize(double[] dArray) {
        double d = FastMatrix.size(dArray);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public static FastMatrix rotateToAlignVectors(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d = FastMatrix.angleBetween(dArray3, dArray);
        double[] dArray5 = FastMatrix.crossProduct(dArray3, dArray);
        double[] dArray6 = FastMatrix.normalize(dArray5);
        FastMatrix fastMatrix = FastMatrix.rotateAround(dArray6[0], dArray6[1], dArray6[2], d);
        double d2 = FastMatrix.dotProduct(dArray4, dArray3) / FastMatrix.sizeSquared(dArray3);
        double[] dArray7 = new double[]{dArray4[0] - d2 * dArray3[0], dArray4[1] - d2 * dArray3[1], dArray4[2] - d2 * dArray3[2]};
        double d3 = FastMatrix.dotProduct(dArray2, dArray) / FastMatrix.sizeSquared(dArray);
        double[] dArray8 = new double[]{dArray2[0] - d3 * dArray[0], dArray2[1] - d3 * dArray[1], dArray2[2] - d3 * dArray[2]};
        fastMatrix.apply(dArray7[0], dArray7[1], dArray7[2]);
        double[] dArray9 = new double[]{fastMatrix.x, fastMatrix.y, fastMatrix.z};
        double d4 = FastMatrix.angleBetween(dArray9, dArray8);
        double[] dArray10 = FastMatrix.crossProduct(dArray9, dArray8);
        double[] dArray11 = FastMatrix.normalize(dArray10);
        FastMatrix fastMatrix2 = FastMatrix.rotateAround(dArray11[0], dArray11[1], dArray11[2], d4);
        return fastMatrix.composeWith(fastMatrix2);
    }

    public static FastMatrix rotateAround(double d, double d2, double d3, double d4) {
        FastMatrix fastMatrix = new FastMatrix();
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        fastMatrix.a00 = -(d5 - 1.0) * d * d + d5;
        fastMatrix.a01 = -(d5 - 1.0) * d * d2 - d6 * d3;
        fastMatrix.a02 = -(d5 - 1.0) * d * d3 + d6 * d2;
        fastMatrix.a03 = 0.0;
        fastMatrix.a10 = -(d5 - 1.0) * d * d2 + d6 * d3;
        fastMatrix.a11 = -(d5 - 1.0) * d2 * d2 + d5;
        fastMatrix.a12 = -(d5 - 1.0) * d2 * d3 - d6 * d;
        fastMatrix.a13 = 0.0;
        fastMatrix.a20 = -(d5 - 1.0) * d * d3 - d6 * d2;
        fastMatrix.a21 = -(d5 - 1.0) * d2 * d3 + d6 * d;
        fastMatrix.a22 = -(d5 - 1.0) * d3 * d3 + d5;
        fastMatrix.a23 = 0.0;
        return fastMatrix;
    }

    public static FastMatrix rotateEuler(double d, double d2, double d3) {
        FastMatrix fastMatrix = new FastMatrix();
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        fastMatrix.a00 = d8 * d4 - d6 * d5 * d9;
        fastMatrix.a01 = -d9 * d4 - d6 * d5 * d8;
        fastMatrix.a02 = d7 * d5;
        fastMatrix.a03 = 0.0;
        fastMatrix.a10 = d8 * d5 + d6 * d4 * d9;
        fastMatrix.a11 = -d9 * d5 + d6 * d4 * d8;
        fastMatrix.a12 = -d7 * d4;
        fastMatrix.a13 = 0.0;
        fastMatrix.a20 = d7 * d9;
        fastMatrix.a21 = d7 * d8;
        fastMatrix.a22 = d6;
        fastMatrix.a23 = 0.0;
        return fastMatrix;
    }

    public static FastMatrix rotateEulerAt(double d, double d2, double d3, double d4, double d5, double d6) {
        FastMatrix fastMatrix = new FastMatrix();
        double d7 = Math.cos(d);
        double d8 = Math.sin(d);
        double d9 = Math.cos(d2);
        double d10 = Math.sin(d2);
        double d11 = Math.cos(d3);
        double d12 = Math.sin(d3);
        fastMatrix.a00 = d11 * d7 - d9 * d8 * d12;
        fastMatrix.a01 = -d12 * d7 - d9 * d8 * d11;
        fastMatrix.a02 = d10 * d8;
        fastMatrix.a03 = 0.0;
        fastMatrix.a10 = d11 * d8 + d9 * d7 * d12;
        fastMatrix.a11 = -d12 * d8 + d9 * d7 * d11;
        fastMatrix.a12 = -d10 * d7;
        fastMatrix.a13 = 0.0;
        fastMatrix.a20 = d10 * d12;
        fastMatrix.a21 = d10 * d11;
        fastMatrix.a22 = d9;
        fastMatrix.a23 = 0.0;
        fastMatrix.apply(d4, d5, d6);
        fastMatrix.a03 = d4 - fastMatrix.x;
        fastMatrix.a13 = d5 - fastMatrix.y;
        fastMatrix.a23 = d6 - fastMatrix.z;
        return fastMatrix;
    }

    public void guessEulerParameters(double[] dArray) {
        if (dArray.length != 6) {
            throw new IllegalArgumentException("Need 6 parameters, got " + dArray.length);
        }
        this.guessEulerParameters(dArray, null);
    }

    public void guessEulerParameters(double[] dArray, Point3d point3d) {
        if (point3d != null && dArray.length != 9) {
            throw new IllegalArgumentException("Need 9 parameters, got " + dArray.length);
        }
        if (this.a21 == 0.0 && this.a20 == 0.0) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = Math.atan2(this.a10, this.a00);
        } else {
            dArray[2] = Math.atan2(this.a20, this.a21);
            dArray[1] = Math.atan2(Math.sqrt(this.a21 * this.a21 + this.a20 * this.a20), this.a22);
            dArray[0] = Math.atan2(this.a02, -this.a12);
        }
        if (point3d != null) {
            dArray[6] = point3d.x;
            dArray[7] = point3d.y;
            dArray[8] = point3d.z;
            this.apply(point3d);
            dArray[3] = this.x - point3d.x;
            dArray[4] = this.y - point3d.y;
            dArray[5] = this.z - point3d.z;
            return;
        }
        if (this.a03 == 0.0 && this.a13 == 0.0 && this.a23 == 0.0) {
            dArray[5] = 0.0;
            dArray[4] = 0.0;
            dArray[3] = 0.0;
        } else {
            this.apply(this.a03, this.a13, this.a23);
            Triangle triangle = new Triangle(new Point3d(0.0, 0.0, 0.0), new Point3d(this.a03, this.a13, this.a23), new Point3d(this.x, this.y, this.z));
            triangle.calculateCircumcenter2();
            dArray[3] = triangle.center.x;
            dArray[4] = triangle.center.y;
            dArray[5] = triangle.center.z;
        }
    }

    public static FastMatrix translate(double d, double d2, double d3) {
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a22 = 1.0;
        fastMatrix.a11 = 1.0;
        fastMatrix.a00 = 1.0;
        fastMatrix.a03 = d;
        fastMatrix.a13 = d2;
        fastMatrix.a23 = d3;
        return fastMatrix;
    }

    public static FastMatrix bestLinear(Point3d[] point3dArray, Point3d[] point3dArray2) {
        if (point3dArray.length != point3dArray2.length) {
            throw new RuntimeException("different lengths");
        }
        if (point3dArray.length != 4) {
            throw new RuntimeException("The arrays passed to bestLinear must be of length 4");
        }
        double[][] dArray = new double[4][4];
        double[][] dArray2 = new double[4][4];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[0];
            dArray3[0] = dArray3[0] + point3dArray[i].x * point3dArray[i].x;
            double[] dArray4 = dArray[0];
            dArray4[1] = dArray4[1] + point3dArray[i].x * point3dArray[i].y;
            double[] dArray5 = dArray[0];
            dArray5[2] = dArray5[2] + point3dArray[i].x * point3dArray[i].z;
            double[] dArray6 = dArray[0];
            dArray6[3] = dArray6[3] + point3dArray[i].x;
            double[] dArray7 = dArray[1];
            dArray7[1] = dArray7[1] + point3dArray[i].y * point3dArray[i].y;
            double[] dArray8 = dArray[1];
            dArray8[2] = dArray8[2] + point3dArray[i].y * point3dArray[i].z;
            double[] dArray9 = dArray[1];
            dArray9[3] = dArray9[3] + point3dArray[i].y;
            double[] dArray10 = dArray[2];
            dArray10[2] = dArray10[2] + point3dArray[i].z * point3dArray[i].z;
            double[] dArray11 = dArray[2];
            dArray11[3] = dArray11[3] + point3dArray[i].z;
            double[] dArray12 = dArray2[0];
            dArray12[0] = dArray12[0] + point3dArray[i].x * point3dArray2[i].x;
            double[] dArray13 = dArray2[0];
            dArray13[1] = dArray13[1] + point3dArray[i].y * point3dArray2[i].x;
            double[] dArray14 = dArray2[0];
            dArray14[2] = dArray14[2] + point3dArray[i].z * point3dArray2[i].x;
            double[] dArray15 = dArray2[0];
            dArray15[3] = dArray15[3] + point3dArray2[i].x;
            double[] dArray16 = dArray2[1];
            dArray16[0] = dArray16[0] + point3dArray[i].x * point3dArray2[i].y;
            double[] dArray17 = dArray2[1];
            dArray17[1] = dArray17[1] + point3dArray[i].y * point3dArray2[i].y;
            double[] dArray18 = dArray2[1];
            dArray18[2] = dArray18[2] + point3dArray[i].z * point3dArray2[i].y;
            double[] dArray19 = dArray2[1];
            dArray19[3] = dArray19[3] + point3dArray2[i].y;
            double[] dArray20 = dArray2[2];
            dArray20[0] = dArray20[0] + point3dArray[i].x * point3dArray2[i].z;
            double[] dArray21 = dArray2[2];
            dArray21[1] = dArray21[1] + point3dArray[i].y * point3dArray2[i].z;
            double[] dArray22 = dArray2[2];
            dArray22[2] = dArray22[2] + point3dArray[i].z * point3dArray2[i].z;
            double[] dArray23 = dArray2[2];
            dArray23[3] = dArray23[3] + point3dArray2[i].z;
        }
        dArray[1][0] = dArray[0][1];
        dArray[2][0] = dArray[0][2];
        dArray[2][1] = dArray[1][2];
        dArray[3][0] = dArray[0][3];
        dArray[3][1] = dArray[1][3];
        dArray[3][2] = dArray[2][3];
        dArray[3][3] = 1.0;
        FastMatrixN.invert(dArray);
        double[][] dArray24 = FastMatrixN.times(dArray2, dArray);
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = dArray24[0][0];
        fastMatrix.a01 = dArray24[0][1];
        fastMatrix.a02 = dArray24[0][2];
        fastMatrix.a03 = dArray24[0][3];
        fastMatrix.a10 = dArray24[1][0];
        fastMatrix.a11 = dArray24[1][1];
        fastMatrix.a12 = dArray24[1][2];
        fastMatrix.a13 = dArray24[1][3];
        fastMatrix.a20 = dArray24[2][0];
        fastMatrix.a21 = dArray24[2][1];
        fastMatrix.a22 = dArray24[2][2];
        fastMatrix.a23 = dArray24[2][3];
        return fastMatrix;
    }

    public static FastMatrix bestRigid(Point3d[] point3dArray, Point3d[] point3dArray2) {
        return FastMatrix.bestRigid(point3dArray, point3dArray2, true);
    }

    public static FastMatrix bestRigid(Point3d[] point3dArray, Point3d[] point3dArray2, boolean bl) {
        double d;
        double d2;
        if (point3dArray.length != point3dArray2.length) {
            throw new RuntimeException("different lengths");
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < point3dArray.length; ++i) {
            d8 += point3dArray[i].x;
            d7 += point3dArray[i].y;
            d6 += point3dArray[i].z;
            d5 += point3dArray2[i].x;
            d4 += point3dArray2[i].y;
            d3 += point3dArray2[i].z;
        }
        d8 /= (double)point3dArray.length;
        d7 /= (double)point3dArray.length;
        d6 /= (double)point3dArray.length;
        d5 /= (double)point3dArray.length;
        d4 /= (double)point3dArray.length;
        d3 /= (double)point3dArray.length;
        double d9 = 1.0;
        if (bl) {
            d2 = 0.0;
            d = 0.0;
            for (int i = 0; i < point3dArray.length; ++i) {
                double d10 = point3dArray[i].x - d8;
                double d11 = point3dArray[i].y - d7;
                double d12 = point3dArray[i].z - d6;
                double d13 = point3dArray2[i].x - d5;
                double d14 = point3dArray2[i].y - d4;
                double d15 = point3dArray2[i].z - d3;
                d += d10 * d10 + d11 * d11 + d12 * d12;
                d2 += d13 * d13 + d14 * d14 + d15 * d15;
            }
            d9 = Math.sqrt(d2 / d);
        }
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        d2 = 0.0;
        d = 0.0;
        for (int i = 0; i < point3dArray.length; ++i) {
            double d23 = (point3dArray[i].x - d8) * d9;
            double d24 = (point3dArray[i].y - d7) * d9;
            double d25 = (point3dArray[i].z - d6) * d9;
            double d26 = point3dArray2[i].x - d5;
            double d27 = point3dArray2[i].y - d4;
            double d28 = point3dArray2[i].z - d3;
            d += d23 * d26;
            d2 += d23 * d27;
            d22 += d23 * d28;
            d21 += d24 * d26;
            d20 += d24 * d27;
            d19 += d24 * d28;
            d18 += d25 * d26;
            d17 += d25 * d27;
            d16 += d25 * d28;
        }
        double[][] dArray = new double[4][4];
        dArray[0][0] = d + d20 + d16;
        dArray[0][1] = d19 - d17;
        dArray[0][2] = d18 - d22;
        dArray[0][3] = d2 - d21;
        dArray[1][0] = d19 - d17;
        dArray[1][1] = d - d20 - d16;
        dArray[1][2] = d2 + d21;
        dArray[1][3] = d18 + d22;
        dArray[2][0] = d18 - d22;
        dArray[2][1] = d2 + d21;
        dArray[2][2] = -d + d20 - d16;
        dArray[2][3] = d19 + d17;
        dArray[3][0] = d2 - d21;
        dArray[3][1] = d18 + d22;
        dArray[3][2] = d19 + d17;
        dArray[3][3] = -d - d20 + d16;
        JacobiDouble jacobiDouble = new JacobiDouble(dArray);
        double[][] dArray2 = jacobiDouble.getEigenVectors();
        double[] dArray3 = jacobiDouble.getEigenValues();
        int n = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(dArray3[i] > dArray3[n])) continue;
            n = i;
        }
        double[] dArray4 = dArray2[n];
        double d29 = dArray4[0];
        double d30 = dArray4[1];
        double d31 = dArray4[2];
        double d32 = dArray4[3];
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = d9 * (d29 * d29 + d30 * d30 - d31 * d31 - d32 * d32);
        fastMatrix.a01 = d9 * 2.0 * (d30 * d31 - d29 * d32);
        fastMatrix.a02 = d9 * 2.0 * (d30 * d32 + d29 * d31);
        fastMatrix.a10 = d9 * 2.0 * (d31 * d30 + d29 * d32);
        fastMatrix.a11 = d9 * (d29 * d29 - d30 * d30 + d31 * d31 - d32 * d32);
        fastMatrix.a12 = d9 * 2.0 * (d31 * d32 - d29 * d30);
        fastMatrix.a20 = d9 * 2.0 * (d32 * d30 - d29 * d31);
        fastMatrix.a21 = d9 * 2.0 * (d32 * d31 + d29 * d30);
        fastMatrix.a22 = d9 * (d29 * d29 - d30 * d30 - d31 * d31 + d32 * d32);
        fastMatrix.apply(d8, d7, d6);
        fastMatrix.a03 = d5 - fastMatrix.x;
        fastMatrix.a13 = d4 - fastMatrix.y;
        fastMatrix.a23 = d3 - fastMatrix.z;
        return fastMatrix;
    }

    public static FastMatrix average(FastMatrix[] fastMatrixArray) {
        FastMatrix fastMatrix = new FastMatrix();
        int n = 0;
        for (int i = 0; i < fastMatrixArray.length; ++i) {
            if (fastMatrixArray[i] == null) continue;
            ++n;
            fastMatrix.a00 += fastMatrixArray[i].a00;
            fastMatrix.a01 += fastMatrixArray[i].a01;
            fastMatrix.a02 += fastMatrixArray[i].a02;
            fastMatrix.a03 += fastMatrixArray[i].a03;
            fastMatrix.a10 += fastMatrixArray[i].a10;
            fastMatrix.a11 += fastMatrixArray[i].a11;
            fastMatrix.a12 += fastMatrixArray[i].a12;
            fastMatrix.a13 += fastMatrixArray[i].a13;
            fastMatrix.a20 += fastMatrixArray[i].a20;
            fastMatrix.a21 += fastMatrixArray[i].a21;
            fastMatrix.a22 += fastMatrixArray[i].a22;
            fastMatrix.a23 += fastMatrixArray[i].a23;
        }
        if (n > 0) {
            fastMatrix.a00 /= (double)n;
            fastMatrix.a01 /= (double)n;
            fastMatrix.a02 /= (double)n;
            fastMatrix.a03 /= (double)n;
            fastMatrix.a10 /= (double)n;
            fastMatrix.a11 /= (double)n;
            fastMatrix.a12 /= (double)n;
            fastMatrix.a13 /= (double)n;
            fastMatrix.a20 /= (double)n;
            fastMatrix.a21 /= (double)n;
            fastMatrix.a22 /= (double)n;
            fastMatrix.a23 /= (double)n;
        }
        return fastMatrix;
    }

    public double[] rowwise16() {
        return new double[]{this.a00, this.a01, this.a02, this.a03, this.a10, this.a11, this.a12, this.a13, this.a20, this.a21, this.a22, this.a23, 0.0, 0.0, 0.0, 1.0};
    }

    public static FastMatrix parseMatrix(String string) {
        FastMatrix fastMatrix = new FastMatrix();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            boolean bl = true;
            fastMatrix.a00 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a10 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a20 = Double.parseDouble(stringTokenizer.nextToken());
            double d = Double.parseDouble(stringTokenizer.nextToken());
            if (d != 0.0) {
                bl = false;
                fastMatrix.a03 = d;
            }
            fastMatrix.a01 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a11 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a21 = Double.parseDouble(stringTokenizer.nextToken());
            d = Double.parseDouble(stringTokenizer.nextToken());
            if (bl && d != 0.0) {
                bl = false;
            }
            if (!bl) {
                fastMatrix.a13 = d;
            }
            fastMatrix.a02 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a12 = Double.parseDouble(stringTokenizer.nextToken());
            fastMatrix.a22 = Double.parseDouble(stringTokenizer.nextToken());
            d = Double.parseDouble(stringTokenizer.nextToken());
            if (bl && d != 0.0) {
                bl = false;
            }
            if (!bl) {
                fastMatrix.a23 = d;
            }
            if (bl) {
                if (!stringTokenizer.hasMoreTokens()) {
                    bl = false;
                }
            } else if (stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("Not a uniform matrix: " + string);
            }
            if (bl) {
                fastMatrix.a03 = Double.parseDouble(stringTokenizer.nextToken());
                fastMatrix.a13 = Double.parseDouble(stringTokenizer.nextToken());
                fastMatrix.a23 = Double.parseDouble(stringTokenizer.nextToken());
                if (Double.parseDouble(stringTokenizer.nextToken()) != 1.0) {
                    throw new RuntimeException("Not a uniform matrix: " + string);
                }
            } else {
                d = fastMatrix.a01;
                fastMatrix.a01 = fastMatrix.a10;
                fastMatrix.a10 = d;
                d = fastMatrix.a02;
                fastMatrix.a02 = fastMatrix.a20;
                fastMatrix.a20 = d;
                d = fastMatrix.a12;
                fastMatrix.a12 = fastMatrix.a21;
                fastMatrix.a21 = d;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return fastMatrix;
    }

    public static FastMatrix[] parseMatrices(String string) {
        FastMatrix[] fastMatrixArray;
        Vector<FastMatrix> vector = new Vector<FastMatrix>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            fastMatrixArray = stringTokenizer.nextToken().trim();
            if (fastMatrixArray.equals("")) {
                vector.add(null);
                continue;
            }
            vector.add(FastMatrix.parseMatrix((String)fastMatrixArray));
        }
        fastMatrixArray = new FastMatrix[vector.size()];
        for (int i = 0; i < fastMatrixArray.length; ++i) {
            fastMatrixArray[i] = (FastMatrix)vector.get(i);
        }
        return fastMatrixArray;
    }

    public static FastMatrix fromCalibration(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = Math.abs(calibration.pixelWidth);
        fastMatrix.a11 = Math.abs(calibration.pixelHeight);
        fastMatrix.a22 = Math.abs(calibration.pixelDepth);
        fastMatrix.a03 = calibration.xOrigin;
        fastMatrix.a13 = calibration.yOrigin;
        fastMatrix.a23 = calibration.zOrigin;
        return fastMatrix;
    }

    public static FastMatrix translateToCenter(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        FastMatrix fastMatrix = new FastMatrix();
        fastMatrix.a00 = 1.0;
        fastMatrix.a11 = 1.0;
        fastMatrix.a22 = 1.0;
        fastMatrix.a03 = calibration.xOrigin + calibration.pixelWidth * (double)imagePlus.getWidth() / 2.0;
        fastMatrix.a13 = calibration.yOrigin + calibration.pixelHeight * (double)imagePlus.getHeight() / 2.0;
        fastMatrix.a23 = calibration.yOrigin + calibration.pixelDepth * (double)imagePlus.getStack().getSize() / 2.0;
        return fastMatrix;
    }

    public final boolean isIdentity() {
        return this.isIdentity(1.0E-10);
    }

    public final boolean equals(FastMatrix fastMatrix) {
        double d = 1.0E-10;
        return d > Math.abs(this.a00 - fastMatrix.a00) && d > Math.abs(this.a01 - fastMatrix.a01) && d > Math.abs(this.a02 - fastMatrix.a02) && d > Math.abs(this.a03 - fastMatrix.a03) && d > Math.abs(this.a10 - fastMatrix.a10) && d > Math.abs(this.a11 - fastMatrix.a11) && d > Math.abs(this.a12 - fastMatrix.a12) && d > Math.abs(this.a13 - fastMatrix.a13) && d > Math.abs(this.a20 - fastMatrix.a20) && d > Math.abs(this.a21 - fastMatrix.a21) && d > Math.abs(this.a22 - fastMatrix.a22) && d > Math.abs(this.a23 - fastMatrix.a23);
    }

    public final boolean isIdentity(double d) {
        return d > Math.abs(this.a00 - 1.0) && d > Math.abs(this.a11 - 1.0) && d > Math.abs(this.a22 - 1.0) && d > Math.abs(this.a01) && d > Math.abs(this.a02) && d > Math.abs(this.a03) && d > Math.abs(this.a10) && d > Math.abs(this.a12) && d > Math.abs(this.a13) && d > Math.abs(this.a20) && d > Math.abs(this.a21) && d > Math.abs(this.a23);
    }

    public void copyToFlatDoubleArray(double[] dArray) {
        dArray[0] = this.a00;
        dArray[1] = this.a01;
        dArray[2] = this.a02;
        dArray[3] = this.a03;
        dArray[4] = this.a10;
        dArray[5] = this.a11;
        dArray[6] = this.a12;
        dArray[7] = this.a13;
        dArray[8] = this.a20;
        dArray[9] = this.a21;
        dArray[10] = this.a22;
        dArray[11] = this.a23;
    }

    public void setFromFlatDoubleArray(double[] dArray) {
        this.a00 = dArray[0];
        this.a01 = dArray[1];
        this.a02 = dArray[2];
        this.a03 = dArray[3];
        this.a10 = dArray[4];
        this.a11 = dArray[5];
        this.a12 = dArray[6];
        this.a13 = dArray[7];
        this.a20 = dArray[8];
        this.a21 = dArray[9];
        this.a22 = dArray[10];
        this.a23 = dArray[11];
    }

    public String resultToString() {
        return "" + this.x + " " + this.y + " " + this.z;
    }

    public String toStringIndented(String string) {
        String string2 = string + this.a00 + ", " + this.a01 + ", " + this.a02 + ", " + this.a03 + "\n";
        string2 = string2 + string + this.a10 + ", " + this.a11 + ", " + this.a12 + ", " + this.a13 + "\n";
        string2 = string2 + string + this.a20 + ", " + this.a21 + ", " + this.a22 + ", " + this.a23 + "\n";
        return string2;
    }

    public String toString() {
        return "" + this.a00 + " " + this.a01 + " " + this.a02 + " " + this.a03 + "   " + this.a10 + " " + this.a11 + " " + this.a12 + " " + this.a13 + "   " + this.a20 + " " + this.a21 + " " + this.a22 + " " + this.a23 + "   ";
    }

    public String toStringForAmira() {
        return "" + this.a00 + " " + this.a10 + " " + this.a20 + " 0 " + this.a01 + " " + this.a11 + " " + this.a21 + " 0 " + this.a02 + " " + this.a12 + " " + this.a22 + " 0 " + this.a03 + " " + this.a13 + " " + this.a23 + " 1";
    }

    public static void main(String[] stringArray) {
        FastMatrix fastMatrix = FastMatrix.rotateFromTo(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        fastMatrix.apply(0.0, 0.0, 1.0);
        System.err.println("expect 0 0 1: " + fastMatrix.x + " " + fastMatrix.y + " " + fastMatrix.z);
        fastMatrix.apply(1.0, 0.0, 0.0);
        System.err.println("expect 0 1 0: " + fastMatrix.x + " " + fastMatrix.y + " " + fastMatrix.z);
        fastMatrix.apply(0.0, 1.0, 0.0);
        System.err.println("expect -1 0 0: " + fastMatrix.x + " " + fastMatrix.y + " " + fastMatrix.z);
    }
}

