/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class IDT_Interpolate_Binary
implements PlugInFilter {
    ImagePlus image;
    int[][] idt;
    int w;
    int h;

    public void run(ImageProcessor imageProcessor) {
        ImageStack imageStack = this.image.getStack();
        this.run(imageStack);
    }

    public void run(ImagePlus imagePlus, Roi[] roiArray) {
        ByteProcessor byteProcessor;
        int n;
        this.w = imagePlus.getWidth();
        this.h = imagePlus.getHeight();
        ImageStack imageStack = new ImageStack(this.w, this.h);
        int n2 = -1;
        int n3 = -1;
        for (n = 1; n < roiArray.length; ++n) {
            if (roiArray[n] == null) continue;
            n2 = n2 == -1 ? n : n2;
            n3 = n;
        }
        if (n2 == -1) {
            IJ.error((String)"There must be at least one selection in order to interpolate.");
            return;
        }
        for (n = n2; n <= n3; ++n) {
            byteProcessor = new ByteProcessor(this.w, this.h);
            if (roiArray[n] != null) {
                byteProcessor.copyBits(roiArray[n].getMask(), roiArray[n].getBounds().x, roiArray[n].getBounds().y, 3);
            }
            imageStack.addSlice("", (ImageProcessor)byteProcessor);
        }
        this.run(imageStack);
        ImagePlus imagePlus2 = new ImagePlus("bla", imageStack);
        byteProcessor = new ThresholdToSelection();
        byteProcessor.setup("", imagePlus2);
        for (int i = n2; i <= n3; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            int n4 = 255;
            imageProcessor.setThreshold((double)n4, (double)n4, 2);
            byteProcessor.run(imageProcessor);
            roiArray[i] = imagePlus2.getRoi();
        }
    }

    public void run(ImageStack imageStack) {
        int n;
        int n2 = imageStack.getSize();
        if (n2 < 3) {
            IJ.error((String)"Too few slices to interpolate!");
            return;
        }
        IJ.showStatus((String)"getting signed integer distance transform");
        this.w = imageStack.getWidth();
        this.h = imageStack.getHeight();
        this.idt = new int[n2][];
        int n3 = n2;
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            this.idt[n] = this.getIDT(imageStack.getProcessor(n + 1).getPixels());
            if (this.idt[n] == null) continue;
            if (n < n3) {
                n3 = n;
            }
            n4 = n;
        }
        if (n3 == n4 || n4 < 0) {
            IJ.error((String)"Not enough to interpolate");
            return;
        }
        IJ.showStatus((String)"calculating weights");
        n = 0;
        int n5 = n3;
        for (int i = n3; i < n4; ++i) {
            if (i == n5) {
                n = i;
                n5 = i + 1;
                while (this.idt[n5] == null) {
                    ++n5;
                }
                continue;
            }
            byte[] byArray = (byte[])imageStack.getProcessor(i + 1).getPixels();
            for (int j = 0; j < this.w * this.h; ++j) {
                if (0 > this.idt[n][j] * (n5 - i) + this.idt[n5][j] * (i - n)) continue;
                byArray[j] = -1;
            }
            IJ.showProgress((int)(i - n3 + 1), (int)(n4 - i));
        }
    }

    int[] getIDT(Object object) {
        IDT iDT = new IDT();
        if (iDT.init((byte[])object) == 0) {
            return null;
        }
        iDT.propagate();
        return iDT.result;
    }

    final boolean isBoundary(byte[] byArray, int n, int n2) {
        if (byArray[n + this.w * n2] == 0) {
            return false;
        }
        if (n <= 0 || byArray[n - 1 + this.w * n2] == 0) {
            return true;
        }
        if (n >= this.w - 1 || byArray[n + 1 + this.w * n2] == 0) {
            return true;
        }
        if (n2 <= 0 || byArray[n + this.w * (n2 - 1)] == 0) {
            return true;
        }
        if (n2 >= this.h - 1 || byArray[n + this.w * (n2 + 1)] == 0) {
            return true;
        }
        if (n <= 0 || n2 <= 0 || byArray[n - 1 + this.w * (n2 - 1)] == 0) {
            return true;
        }
        if (n <= 0 || n2 >= this.h - 1 || byArray[n - 1 + this.w * (n2 + 1)] == 0) {
            return true;
        }
        if (n >= this.w - 1 || n2 <= 0 || byArray[n + 1 + this.w * (n2 - 1)] == 0) {
            return true;
        }
        return n >= this.w - 1 || n2 >= this.h - 1 || byArray[n + 1 + this.w * (n2 + 1)] == 0;
    }

    final boolean isJustOutside(byte[] byArray, int n, int n2) {
        if (byArray[n + this.w * n2] != 0) {
            return false;
        }
        if (n > 0 && byArray[n - 1 + this.w * n2] != 0) {
            return true;
        }
        if (n < this.w - 1 && byArray[n + 1 + this.w * n2] != 0) {
            return true;
        }
        if (n2 > 0 && byArray[n + this.w * (n2 - 1)] != 0) {
            return true;
        }
        if (n2 < this.h - 1 && byArray[n + this.w * (n2 + 1)] != 0) {
            return true;
        }
        if (n > 0 && n2 > 0 && byArray[n - 1 + this.w * (n2 - 1)] != 0) {
            return true;
        }
        if (n > 0 && n2 < this.h - 1 && byArray[n - 1 + this.w * (n2 + 1)] != 0) {
            return true;
        }
        if (n < this.w - 1 && n2 > 0 && byArray[n + 1 + this.w * (n2 - 1)] != 0) {
            return true;
        }
        return n < this.w - 1 && n2 < this.h - 1 && byArray[n + 1 + this.w * (n2 + 1)] != 0;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    class IDT {
        int[] result;

        IDT() {
            this.result = new int[IDT_Interpolate_Binary.this.w * IDT_Interpolate_Binary.this.h];
            int n = (IDT_Interpolate_Binary.this.w + IDT_Interpolate_Binary.this.h) * 9;
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = n;
            }
        }

        int init(byte[] byArray) {
            int n = 0;
            for (int i = 0; i < IDT_Interpolate_Binary.this.h; ++i) {
                for (int j = 0; j < IDT_Interpolate_Binary.this.w; ++j) {
                    int n2 = j + IDT_Interpolate_Binary.this.w * i;
                    if (IDT_Interpolate_Binary.this.isBoundary(byArray, j, i)) {
                        this.result[n2] = 0;
                        ++n;
                        continue;
                    }
                    if (!IDT_Interpolate_Binary.this.isJustOutside(byArray, j, i)) continue;
                    this.result[n2] = -1;
                }
            }
            return n;
        }

        final void idt(int n, int n2, int n3, int n4) {
            if (n + n3 < 0 || n2 + n4 < 0 || n + n3 >= IDT_Interpolate_Binary.this.w || n2 + n4 >= IDT_Interpolate_Binary.this.h) {
                return;
            }
            int n5 = this.result[n + n3 + IDT_Interpolate_Binary.this.w * (n2 + n4)];
            int n6 = n3 == 0 || n4 == 0 ? 3 : 4;
            if (Math.abs(this.result[n + IDT_Interpolate_Binary.this.w * n2]) > Math.abs(n5 += n6 * (n5 < 0 ? -1 : 1))) {
                this.result[n + IDT_Interpolate_Binary.this.w * n2] = n5;
            }
        }

        void propagate() {
            int n;
            int n2;
            for (n2 = 0; n2 < IDT_Interpolate_Binary.this.h; ++n2) {
                for (n = 0; n < IDT_Interpolate_Binary.this.w; ++n) {
                    this.idt(n, n2, -1, 0);
                    this.idt(n, n2, -1, -1);
                    this.idt(n, n2, 0, -1);
                }
            }
            for (n2 = IDT_Interpolate_Binary.this.h - 1; n2 >= 0; --n2) {
                for (n = IDT_Interpolate_Binary.this.w - 1; n >= 0; --n) {
                    this.idt(n, n2, 1, 0);
                    this.idt(n, n2, 1, 1);
                    this.idt(n, n2, 0, 1);
                }
            }
            for (n2 = IDT_Interpolate_Binary.this.w - 1; n2 >= 0; --n2) {
                for (n = IDT_Interpolate_Binary.this.h - 1; n >= 0; --n) {
                    this.idt(n2, n, 1, 0);
                    this.idt(n2, n, 1, 1);
                    this.idt(n2, n, 0, 1);
                }
            }
            for (n2 = 0; n2 < IDT_Interpolate_Binary.this.w; ++n2) {
                for (n = 0; n < IDT_Interpolate_Binary.this.h; ++n) {
                    this.idt(n2, n, -1, 0);
                    this.idt(n2, n, -1, -1);
                    this.idt(n2, n, 0, -1);
                }
            }
        }
    }
}

