/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import math3d.Point3d;

public class InterpolatedImage {
    public ImagePlus image;
    int w;
    int h;
    int d;
    private byte[][] pixels;
    private float[][] pixelsFloat;
    private short[][] pixelsShort;
    public Interpolate interpol;
    int type;

    public InterpolatedImage(ImagePlus imagePlus) {
        this.image = imagePlus;
        ImageStack imageStack = imagePlus.getStack();
        this.d = imageStack.getSize();
        this.h = imageStack.getHeight();
        this.w = imageStack.getWidth();
        this.type = imagePlus.getType();
        if (this.type == 0 || this.type == 3) {
            this.pixels = new byte[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixels[i] = (byte[])imageStack.getPixels(i + 1);
            }
            this.interpol = this.type == 0 && !imagePlus.getProcessor().isColorLut() ? new AverageByte() : new NearestNeighbourByte();
        } else if (this.type == 2) {
            this.pixelsFloat = new float[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixelsFloat[i] = (float[])imageStack.getPixels(i + 1);
            }
            this.interpol = new AverageFloat();
        } else if (this.type == 1) {
            this.pixelsShort = new short[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixelsShort[i] = (short[])imageStack.getPixels(i + 1);
            }
            this.interpol = new AverageShort();
        }
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getDepth() {
        return this.d;
    }

    protected InterpolatedImage() {
    }

    public ImagePlus getImage() {
        return this.image;
    }

    Point3d getCenter() {
        Calibration calibration = this.image.getCalibration();
        return new Point3d(calibration.xOrigin + (double)this.w * calibration.pixelWidth / 2.0, calibration.yOrigin + (double)this.h * calibration.pixelHeight / 2.0, calibration.zOrigin + (double)this.d * calibration.pixelDepth / 2.0);
    }

    Point3d getCenterOfGravity() {
        return this.getCenterOfGravity(0, 0, 0, this.w, this.h, this.d);
    }

    Point3d getCenterOfGravity(int n, int n2, int n3, int n4, int n5, int n6) {
        Calibration calibration = this.image.getCalibration();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = n3; i < n6; ++i) {
            for (int j = n2; j < n5; ++j) {
                for (int k = n; k < n4; ++k) {
                    if (this.type == 2) {
                        double d5 = this.getNoInterpolFloat(k, j, i);
                        d4 += (double)k * d5;
                        d3 += (double)j * d5;
                        d2 += (double)i * d5;
                        d += d5;
                        continue;
                    }
                    int n7 = -1;
                    if (this.type == 0 || this.type == 3) {
                        n7 = this.getNoInterpol(k, j, i);
                    } else if (this.type == 1) {
                        n7 = this.getNoInterpolShort(k, j, i);
                    }
                    l4 += (long)(k * n7);
                    l3 += (long)(j * n7);
                    l2 += (long)(i * n7);
                    l += (long)n7;
                }
            }
        }
        if (this.type == 2) {
            if (d == 0.0) {
                d4 = (n + n4) / 2;
                d3 = (n2 + n5) / 2;
                d2 = (n3 + n6) / 2;
                d = 1.0;
            }
            return new Point3d(calibration.xOrigin + calibration.pixelWidth * d4 / d, calibration.yOrigin + calibration.pixelHeight * d3 / d, calibration.zOrigin + calibration.pixelDepth * d2 / d);
        }
        if (l == 0L) {
            l4 = (n + n4) / 2;
            l3 = (n2 + n5) / 2;
            l2 = (n3 + n6) / 2;
            l = 1L;
        }
        return new Point3d(calibration.xOrigin + calibration.pixelWidth * (double)l4 / (double)l, calibration.yOrigin + calibration.pixelHeight * (double)l3 / (double)l, calibration.zOrigin + calibration.pixelDepth * (double)l2 / (double)l);
    }

    Point3d getCenterOfGravity(int n) {
        if (this.type != 0 && this.type != 3) {
            throw new RuntimeException("InterpolatedImage.getCenterOfGravity(int) only makes sense with 8 bit images. (Probably.)");
        }
        Calibration calibration = this.image.getCalibration();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    int n2 = this.getNoInterpol(k, j, i);
                    if (n2 != n) continue;
                    l4 += (long)k;
                    l3 += (long)j;
                    l2 += (long)i;
                    ++l;
                }
            }
        }
        return new Point3d(calibration.xOrigin + calibration.pixelWidth * (double)l4 / (double)l, calibration.yOrigin + calibration.pixelHeight * (double)l3 / (double)l, calibration.zOrigin + calibration.pixelDepth * (double)l2 / (double)l);
    }

    public final int getNoCheck(int n, int n2, int n3) {
        return this.pixels[n3][n + this.w * n2] & 0xFF;
    }

    public final int getNoInterpol(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return 0;
        }
        return this.getNoCheck(n, n2, n3);
    }

    public final byte getNearestByte(double d, double d2, double d3) {
        int n = (int)Math.round(d);
        if (n < 0 || n >= this.w) {
            return 0;
        }
        int n2 = (int)Math.round(d2);
        if (n2 < 0 || n2 >= this.h) {
            return 0;
        }
        int n3 = (int)Math.round(d3);
        if (n3 < 0 || n3 >= this.d) {
            return 0;
        }
        return this.pixels[n3][n + this.w * n2];
    }

    public void set(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return;
        }
        this.pixels[n3][n + this.w * n2] = (byte)n4;
    }

    public Iterator iterator() {
        return this.iterator(false);
    }

    public Iterator iterator(boolean bl) {
        return this.iterator(bl, 0, 0, 0, this.w, this.h, this.d);
    }

    public Iterator iterator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        return new Iterator(bl, n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = Math.abs(n - n4);
        int n9 = Math.abs(n2 - n5);
        int n10 = Math.abs(n3 - n6);
        if (n9 > n8) {
            n8 = n9;
        }
        if (n10 > n8) {
            n8 = n10;
        }
        if (n8 == 0) {
            this.set(n, n2, n3, n7);
            return;
        }
        for (int i = 0; i <= n8; ++i) {
            this.set(n + i * (n4 - n) / n8, n2 + i * (n5 - n2) / n8, n3 + i * (n6 - n3) / n8, n7);
        }
    }

    public float getNoCheckFloat(int n, int n2, int n3) {
        return this.pixelsFloat[n3][n + this.w * n2];
    }

    public float getNoInterpolFloat(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return 0.0f;
        }
        return this.getNoCheckFloat(n, n2, n3);
    }

    public void setFloat(int n, int n2, int n3, float f) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return;
        }
        this.pixelsFloat[n3][n + this.w * n2] = f;
    }

    public short getNoCheckShort(int n, int n2, int n3) {
        return this.pixelsShort[n3][n + this.w * n2];
    }

    public short getNoInterpolShort(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return 0;
        }
        return this.getNoCheckShort(n, n2, n3);
    }

    public void setShort(int n, int n2, int n3, short s) {
        if (n < 0 || n2 < 0 || n3 < 0 || n >= this.w || n2 >= this.h || n3 >= this.d) {
            return;
        }
        this.pixelsShort[n3][n + this.w * n2] = s;
    }

    public InterpolatedImage cloneDimensionsOnly() {
        return InterpolatedImage.cloneDimensionsOnly(this.image, this.type);
    }

    public static InterpolatedImage cloneDimensionsOnly(ImagePlus imagePlus, int n) {
        InterpolatedImage interpolatedImage = new InterpolatedImage();
        interpolatedImage.w = imagePlus.getWidth();
        interpolatedImage.h = imagePlus.getHeight();
        interpolatedImage.d = imagePlus.getStack().getSize();
        switch (n) {
            case 0: 
            case 3: {
                interpolatedImage.pixels = new byte[interpolatedImage.d][];
                break;
            }
            case 2: {
                interpolatedImage.pixelsFloat = new float[interpolatedImage.d][];
                break;
            }
            case 1: {
                interpolatedImage.pixelsShort = new short[interpolatedImage.d][];
            }
        }
        ImageStack imageStack = new ImageStack(interpolatedImage.w, interpolatedImage.h, null);
        block10: for (int i = 0; i < interpolatedImage.d; ++i) {
            switch (n) {
                case 0: 
                case 3: {
                    interpolatedImage.pixels[i] = new byte[interpolatedImage.w * interpolatedImage.h];
                    imageStack.addSlice("", (Object)interpolatedImage.pixels[i]);
                    continue block10;
                }
                case 2: {
                    interpolatedImage.pixelsFloat[i] = new float[interpolatedImage.w * interpolatedImage.h];
                    imageStack.addSlice("", (Object)interpolatedImage.pixelsFloat[i]);
                    continue block10;
                }
                case 1: {
                    interpolatedImage.pixelsShort[i] = new short[interpolatedImage.w * interpolatedImage.h];
                    imageStack.addSlice("", (Object)interpolatedImage.pixelsShort[i]);
                }
            }
        }
        interpolatedImage.image = new ImagePlus("", imageStack);
        interpolatedImage.image.setCalibration(imagePlus.getCalibration());
        return interpolatedImage;
    }

    public InterpolatedImage cloneImage() {
        InterpolatedImage interpolatedImage = this.cloneDimensionsOnly();
        block5: for (int i = 0; i < this.d; ++i) {
            switch (this.type) {
                case 0: 
                case 3: {
                    System.arraycopy(this.pixels[i], 0, interpolatedImage.pixels[i], 0, this.w * this.h);
                    continue block5;
                }
                case 2: {
                    System.arraycopy(this.pixelsFloat[i], 0, interpolatedImage.pixelsFloat[i], 0, this.w * this.h);
                    continue block5;
                }
                case 1: {
                    System.arraycopy(this.pixelsShort[i], 0, interpolatedImage.pixelsShort[i], 0, this.w * this.h);
                }
            }
        }
        return interpolatedImage;
    }

    class AverageShort
    implements Interpolate {
        AverageShort() {
        }

        public double get(double d, double d2, double d3) {
            int n = (int)Math.floor(d);
            int n2 = (int)Math.floor(d2);
            int n3 = (int)Math.floor(d3);
            double d4 = (double)(n + 1) - d;
            double d5 = (double)(n2 + 1) - d2;
            double d6 = (double)(n3 + 1) - d3;
            double d7 = InterpolatedImage.this.getNoInterpolShort(n, n2, n3);
            double d8 = InterpolatedImage.this.getNoInterpolShort(n, n2, n3 + 1);
            double d9 = InterpolatedImage.this.getNoInterpolShort(n, n2 + 1, n3);
            double d10 = InterpolatedImage.this.getNoInterpolShort(n, n2 + 1, n3 + 1);
            double d11 = InterpolatedImage.this.getNoInterpolShort(n + 1, n2, n3);
            double d12 = InterpolatedImage.this.getNoInterpolShort(n + 1, n2, n3 + 1);
            double d13 = InterpolatedImage.this.getNoInterpolShort(n + 1, n2 + 1, n3);
            double d14 = InterpolatedImage.this.getNoInterpolShort(n + 1, n2 + 1, n3 + 1);
            double d15 = d4 * (d5 * (d6 * d7 + (1.0 - d6) * d8) + (1.0 - d5) * (d6 * d9 + (1.0 - d6) * d10)) + (1.0 - d4) * (d5 * (d6 * d11 + (1.0 - d6) * d12) + (1.0 - d5) * (d6 * d13 + (1.0 - d6) * d14));
            return d15;
        }
    }

    class AverageFloat
    implements Interpolate {
        AverageFloat() {
        }

        public double get(double d, double d2, double d3) {
            int n = (int)Math.floor(d);
            int n2 = (int)Math.floor(d2);
            int n3 = (int)Math.floor(d3);
            double d4 = (double)(n + 1) - d;
            double d5 = (double)(n2 + 1) - d2;
            double d6 = (double)(n3 + 1) - d3;
            double d7 = InterpolatedImage.this.getNoInterpolFloat(n, n2, n3);
            double d8 = InterpolatedImage.this.getNoInterpolFloat(n, n2, n3 + 1);
            double d9 = InterpolatedImage.this.getNoInterpolFloat(n, n2 + 1, n3);
            double d10 = InterpolatedImage.this.getNoInterpolFloat(n, n2 + 1, n3 + 1);
            double d11 = InterpolatedImage.this.getNoInterpolFloat(n + 1, n2, n3);
            double d12 = InterpolatedImage.this.getNoInterpolFloat(n + 1, n2, n3 + 1);
            double d13 = InterpolatedImage.this.getNoInterpolFloat(n + 1, n2 + 1, n3);
            double d14 = InterpolatedImage.this.getNoInterpolFloat(n + 1, n2 + 1, n3 + 1);
            double d15 = d4 * (d5 * (d6 * d7 + (1.0 - d6) * d8) + (1.0 - d5) * (d6 * d9 + (1.0 - d6) * d10)) + (1.0 - d4) * (d5 * (d6 * d11 + (1.0 - d6) * d12) + (1.0 - d5) * (d6 * d13 + (1.0 - d6) * d14));
            return d15;
        }
    }

    public class Iterator
    implements java.util.Iterator {
        public int i;
        public int j;
        public int k;
        boolean showProgress = false;
        int x0;
        int x1;
        int y0;
        int y1;
        int z0;
        int z1;
        int xd;
        int zd;

        public Iterator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
            this.showProgress = bl;
            this.x0 = n;
            this.y0 = n2;
            this.z0 = n3;
            this.x1 = n4;
            this.y1 = n5;
            this.z1 = n6;
            this.xd = n4 - n;
            this.zd = n6 - n3;
            this.i = n - 1;
            this.j = n2;
            this.k = n3;
        }

        public boolean hasNext() {
            return this.i + 1 < this.x1 || this.j + 1 < this.y1 || this.k + 1 < this.z1;
        }

        public Object next() {
            if (++this.i >= this.x1) {
                this.i = this.x0;
                if (++this.j >= this.y1) {
                    this.j = this.y0;
                    if (++this.k >= this.z1) {
                        return null;
                    }
                    if (this.showProgress) {
                        IJ.showProgress((int)(this.k - this.z0 + 1), (int)this.zd);
                    }
                }
            }
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class NearestNeighbourByte
    implements Interpolate {
        public final double get(double d, double d2, double d3) {
            return this.getInt(d, d2, d3);
        }

        public final int getInt(double d, double d2, double d3) {
            double d4 = Math.round(d);
            double d5 = Math.round(d2);
            double d6 = Math.round(d3);
            return InterpolatedImage.this.getNoInterpol((int)d4, (int)d5, (int)d6);
        }
    }

    class MaxLikelihoodByte
    implements Interpolate {
        int[] value = new int[8];
        double[] histo = new double[256];
        double xF;
        double yF;
        double zF;
        double xR;
        double yR;
        double zR;
        final double eps = 1.0E-10;

        public MaxLikelihoodByte(double d, double d2, double d3) {
            this.xF = d;
            this.yF = d2;
            this.zF = d3;
        }

        final double factor(int n, int n2, int n3) {
            double d = n == 0 ? this.xR : 1.0 - this.xR;
            double d2 = n2 == 0 ? this.yR : 1.0 - this.yR;
            double d3 = n3 == 0 ? this.zR : 1.0 - this.zR;
            return 1.0 / (1.0E-10 + d * d + d2 * d2 + d3 * d3);
        }

        public final double get(double d, double d2, double d3) {
            int n;
            int n2;
            int n3 = (int)Math.floor(d);
            int n4 = (int)Math.floor(d2);
            int n5 = (int)Math.floor(d3);
            this.xR = (double)(n3 + 1) - d;
            this.yR = (double)(n4 + 1) - d2;
            this.zR = (double)(n5 + 1) - d3;
            for (n2 = 0; n2 < 2; ++n2) {
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < 2; ++i) {
                        int n6 = n2 + 2 * (n + 2 * i);
                        this.value[n6] = InterpolatedImage.this.getNoInterpol(n3 + n2, n4 + n, n5 + i);
                        int n7 = this.value[n6];
                        this.histo[n7] = this.histo[n7] + 1.0;
                    }
                }
            }
            n2 = this.value[0];
            for (n = 1; n < 8; ++n) {
                if (this.value[n] < n2) continue;
                n2 = this.value[n];
            }
            for (n = 0; n < 8; ++n) {
                this.histo[this.value[n]] = 0.0;
            }
            return n2;
        }
    }

    class AverageByte
    implements Interpolate {
        AverageByte() {
        }

        public final double get(double d, double d2, double d3) {
            int n = (int)Math.floor(d);
            int n2 = (int)Math.floor(d2);
            int n3 = (int)Math.floor(d3);
            double d4 = (double)(n + 1) - d;
            double d5 = (double)(n2 + 1) - d2;
            double d6 = (double)(n3 + 1) - d3;
            double d7 = InterpolatedImage.this.getNoInterpol(n, n2, n3);
            double d8 = InterpolatedImage.this.getNoInterpol(n, n2, n3 + 1);
            double d9 = InterpolatedImage.this.getNoInterpol(n, n2 + 1, n3);
            double d10 = InterpolatedImage.this.getNoInterpol(n, n2 + 1, n3 + 1);
            double d11 = InterpolatedImage.this.getNoInterpol(n + 1, n2, n3);
            double d12 = InterpolatedImage.this.getNoInterpol(n + 1, n2, n3 + 1);
            double d13 = InterpolatedImage.this.getNoInterpol(n + 1, n2 + 1, n3);
            double d14 = InterpolatedImage.this.getNoInterpol(n + 1, n2 + 1, n3 + 1);
            double d15 = d4 * (d5 * (d6 * d7 + (1.0 - d6) * d8) + (1.0 - d5) * (d6 * d9 + (1.0 - d6) * d10)) + (1.0 - d4) * (d5 * (d6 * d11 + (1.0 - d6) * d12) + (1.0 - d5) * (d6 * d13 + (1.0 - d6) * d14));
            return d15;
        }
    }

    public static interface Interpolate {
        public double get(double var1, double var3, double var5);
    }
}

