/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Euclidean;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.AugmentedLandmarkWarp_;
import vib.BenesNamedPoint;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.PointList;
import vib.RigidRegistration_;
import vib.TransformedImage;
import vib.VIB;

public class LocalRigidRegistration_
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = WindowManager.getImage((int)nArray[i]).getTitle();
        }
        GenericDialog genericDialog = new GenericDialog("Registration parameters");
        genericDialog.addChoice("Template", stringArray, WindowManager.getCurrentImage().getTitle());
        genericDialog.addChoice("Image", stringArray, stringArray[0]);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        ImagePlus imagePlus = WindowManager.getImage((String)genericDialog.getNextChoice());
        this.image = WindowManager.getImage((String)genericDialog.getNextChoice());
        TransformedImage transformedImage = new TransformedImage(imagePlus, this.image);
        transformedImage.measure = new Euclidean();
        try {
            RigidRegistration_ rigidRegistration_ = new RigidRegistration_();
            FastMatrix fastMatrix = rigidRegistration_.rigidRegistration(transformedImage, null, null, -1, -1, false, 4, 2, 1.0, 1, true, true, false, null);
            PointList pointList = PointList.load(this.image);
            PointList pointList2 = PointList.load(imagePlus);
            if (pointList == null || pointList2 == null) {
                IJ.error((String)"Landmarks could not be loaded. Abort");
            }
            PointList pointList3 = PointList.pointsInBoth(pointList, pointList2);
            int n = pointList3.size();
            System.out.println("Number of landmarks: " + n);
            if (n == 0) {
                IJ.error((String)"No common landmarks. Abort");
            }
            VIB.println("Common landmarks:\n" + pointList3);
            String string = fastMatrix.toStringForAmira();
            FastMatrix[] fastMatrixArray = new FastMatrix[n];
            for (int i = 0; i < n; ++i) {
                BenesNamedPoint benesNamedPoint = pointList3.get(i);
                System.out.println("LANDMARK " + benesNamedPoint);
                String string2 = benesNamedPoint.x + " " + benesNamedPoint.y + " " + benesNamedPoint.z + " " + (benesNamedPoint.x - 50.0) + " " + (benesNamedPoint.y - 50.0) + " " + (benesNamedPoint.z - 50.0) + " " + (benesNamedPoint.x + 50.0) + " " + (benesNamedPoint.y + 50.0) + " " + (benesNamedPoint.z + 50.0);
                fastMatrixArray[i] = new RigidRegistration_().rigidRegistration(transformedImage, string2, string, -1, -1, false, 4, 2, 1.0, 1, false, false, false, null);
            }
            AugmentedLandmarkWarp_ augmentedLandmarkWarp_ = new AugmentedLandmarkWarp_();
            augmentedLandmarkWarp_.setCenter(pointList3.toArray());
            augmentedLandmarkWarp_.matrix = fastMatrixArray;
            augmentedLandmarkWarp_.ii = new InterpolatedImage(imagePlus);
            augmentedLandmarkWarp_.model = new InterpolatedImage(this.image);
            augmentedLandmarkWarp_.run();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }
}

