/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class Local_Threshold
implements PlugInFilter {
    private ImagePlus image;
    private static ImageProcessor copy;
    private static int lastMinThreshold;
    private static int lastMaxThreshold;

    public void run(final ImageProcessor imageProcessor) {
        if (this.image.getRoi() == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi roi = (Roi)this.image.getRoi().clone();
        copy = imageProcessor.duplicate();
        GenericDialog genericDialog = new GenericDialog("Adjust local threshold");
        genericDialog.addSlider("min value", 0.0, 255.0, (double)lastMinThreshold);
        genericDialog.addSlider("max value", 0.0, 255.0, (double)lastMaxThreshold);
        final Scrollbar scrollbar = (Scrollbar)genericDialog.getSliders().get(0);
        final Scrollbar scrollbar2 = (Scrollbar)genericDialog.getSliders().get(1);
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Local_Threshold.applyThreshold(imageProcessor, Local_Threshold.this.image.getRoi(), scrollbar.getValue(), scrollbar2.getValue());
                lastMinThreshold = scrollbar.getValue();
                lastMaxThreshold = scrollbar2.getValue();
                Local_Threshold.this.image.updateAndDraw();
            }
        };
        scrollbar.addAdjustmentListener(adjustmentListener);
        scrollbar2.addAdjustmentListener(adjustmentListener);
        Local_Threshold.applyThreshold(imageProcessor, this.image.getRoi(), lastMinThreshold, lastMaxThreshold);
        this.image.updateAndDraw();
        genericDialog.showDialog();
        imageProcessor.setRoi(this.image.getRoi());
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        imageProcessor2.setThreshold(255.0, 255.0, 2);
        ImagePlus imagePlus = new ImagePlus("", imageProcessor2);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run(imageProcessor2);
        imageProcessor2.resetThreshold();
        imageProcessor.insert(copy, 0, 0);
        Rectangle rectangle = roi.getBounds();
        if (imagePlus.getRoi() != null) {
            int n;
            int n2;
            Rectangle rectangle2 = imagePlus.getRoi().getBounds();
            int n3 = n2 = rectangle.x > 0 ? rectangle.x : 0;
            if (rectangle2.x > 0) {
                n2 += rectangle2.x;
            }
            int n4 = n = rectangle.y > 0 ? rectangle.y : 0;
            if (rectangle2.y > 0) {
                n += rectangle2.y;
            }
            imagePlus.getRoi().setLocation(n2, n);
            this.image.setRoi(imagePlus.getRoi());
        }
    }

    public static void applyThreshold(ImageProcessor imageProcessor, Roi roi, int n, int n2) {
        boolean bl;
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        boolean bl2 = bl = copy == null;
        if (copy == null) {
            copy = imageProcessor.duplicate();
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        byte[] byArray2 = (byte[])copy.getPixels();
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = roi.getBoundingRect();
        int n5 = rectangle.x > 0 ? rectangle.x : 0;
        int n6 = rectangle.y > 0 ? rectangle.y : 0;
        int n7 = n5 + rectangle.width <= n3 ? n5 + rectangle.width : n3;
        int n8 = n6 + rectangle.height <= n4 ? n6 + rectangle.height : n4;
        for (int i = n6; i < n8; ++i) {
            for (int j = n5; j < n7; ++j) {
                if (!roi.contains(j, i)) continue;
                int n9 = i * imageProcessor.getWidth() + j;
                byArray[n9] = (byArray2[n9] & 0xFF) >= n && (byArray2[n9] & 0xFF) <= n2 ? -1 : byArray2[n9];
            }
        }
        if (bl) {
            copy = null;
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    static {
        lastMinThreshold = 10;
        lastMaxThreshold = 255;
    }
}

