/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;

public class MaxEntHistogram {
    private static final boolean debug = false;
    private long[] values = new long[256];
    private long total;
    int[] boundaries;

    public MaxEntHistogram(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            this.initHistogram((ByteProcessor)imageStack.getProcessor(i));
        }
        this.total = imageStack.getWidth() * imageStack.getHeight() * imageStack.getSize();
    }

    public MaxEntHistogram(int[][] nArray) {
        this.total = 0L;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n = i;
                this.values[n] = this.values[n] + (long)nArray[j][i];
                this.total += this.values[i];
            }
        }
    }

    private void initHistogram(ByteProcessor byteProcessor) {
        byte[] byArray = (byte[])byteProcessor.getPixels();
        int n = byteProcessor.getWidth();
        int n2 = byteProcessor.getHeight();
        for (int i = 0; i < n * n2; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            int n4 = n3;
            this.values[n4] = this.values[n4] + 1L;
        }
    }

    private int getMean(int n, int n2) {
        long l = 0L;
        long l2 = 0L;
        for (int i = n; i < n2; ++i) {
            l += (long)i * this.values[i];
            l2 += this.values[i];
        }
        if (l2 == 0L) {
            return (n2 - n) / 2;
        }
        return (int)(l / l2);
    }

    private double getPartialEntropy(int n, int n2) {
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l += this.values[i];
        }
        if (l == 0L) {
            return 0.0;
        }
        return -Math.log((double)l / (double)this.total) * (double)l / (double)this.total;
    }

    public double quantize(int n) {
        int[][][] nArray = new int[n][256][n];
        double[][] dArray = new double[n][256];
        for (int i = 1; i <= n; ++i) {
            int n2 = i < n ? i : 256;
            int n3 = 256 - n + i;
            for (int j = n2; j <= n3; ++j) {
                if (i == 1) {
                    dArray[0][j - 1] = this.getPartialEntropy(0, j);
                    nArray[0][j - 1][0] = j;
                } else {
                    int n4 = -1;
                    double d = -1.7976931348623157E308;
                    for (int k = i - 1; k < j; ++k) {
                        double d2 = dArray[i - 2][k - 1] + this.getPartialEntropy(k, j);
                        if (!(d2 > d)) continue;
                        n4 = k;
                        d = d2;
                    }
                    dArray[i - 1][j - 1] = d;
                    System.arraycopy(nArray[i - 2][n4 - 1], 0, nArray[i - 1][j - 1], 0, i - 1);
                    nArray[i - 1][j - 1][i - 1] = j;
                }
                IJ.showProgress((double)((double)i / (double)n));
            }
        }
        this.boundaries = nArray[n - 1][255];
        return dArray[n - 1][255];
    }

    public void quantizeNaive(int n) {
        this.boundaries = new int[n];
        long l = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            l += this.values[i];
        }
        long l2 = 0L;
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            while (n2 < this.values.length - (n - 1 - i) && l2 < l * (long)(i + 1) / (long)n) {
                l2 += this.values[n2];
                ++n2;
            }
            this.boundaries[i] = n2;
            System.err.println(i + ": " + n2);
        }
        this.boundaries[n - 1] = this.values.length;
        System.err.println(n - 1 + ": " + this.boundaries[n - 1]);
    }

    public byte[] getMapping(boolean bl) {
        byte[] byArray = new byte[256];
        int n = 0;
        for (int i = 0; i < this.boundaries.length; ++i) {
            int n2 = bl ? i : this.getMean(n, this.boundaries[i]);
            for (int j = n; j < this.boundaries[i]; ++j) {
                byArray[j] = (byte)n2;
            }
            n = this.boundaries[i];
        }
        return byArray;
    }

    public int[][] get(int[][] nArray) {
        int[][] nArray2 = new int[nArray.length][this.boundaries.length];
        for (int i = 0; i < this.boundaries.length; ++i) {
            for (int j = 0; j < this.boundaries[i]; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    int[] nArray3 = nArray2[k];
                    int n = i;
                    nArray3[n] = nArray3[n] + nArray[k][j];
                }
            }
        }
        return nArray2;
    }
}

