/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import vib.MaxEntHistogram;
import vib.ShowHistogram;

public class MaxEntQuantization_
implements PlugInFilter {
    ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        ImageStack imageStack = this.image.getStack();
        GenericDialog genericDialog = new GenericDialog("Maximum Entropy Parameters");
        genericDialog.addNumericField("numberOfBins", 16.0, 0);
        genericDialog.addCheckbox("showIndex", false);
        genericDialog.addCheckbox("useNaive", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        MaxEntHistogram maxEntHistogram = new MaxEntHistogram(this.image);
        if (n == -7) {
            this.calculateEntropyHistogram(maxEntHistogram);
            return;
        }
        if (bl2) {
            maxEntHistogram.quantizeNaive(n);
        } else {
            maxEntHistogram.quantize(n);
        }
        byte[] byArray = maxEntHistogram.getMapping(bl);
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            imageStack2.addSlice("", (ImageProcessor)this.doit(imageStack.getProcessor(i), byArray));
            IJ.showProgress((double)((double)i / (double)imageStack.getSize()));
        }
        ImagePlus imagePlus = new ImagePlus("Maximum entropy quantized " + this.image.getTitle() + " " + n + " bins", imageStack2);
        imagePlus.setCalibration(this.image.getCalibration());
        imagePlus.show();
    }

    private ByteProcessor doit(ImageProcessor imageProcessor, byte[] byArray) {
        byte[] byArray2 = (byte[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        byte[] byArray3 = new byte[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            int n3 = byArray2[i];
            if (n3 < 0) {
                n3 += 256;
            }
            byArray3[i] = byArray[n3];
        }
        return new ByteProcessor(n, n2, byArray3, null);
    }

    private void calculateEntropyHistogram(MaxEntHistogram maxEntHistogram) {
        double[] dArray = new double[255];
        for (int i = 1; i < 256; ++i) {
            dArray[i - 1] = maxEntHistogram.quantize(i);
            System.err.println("Entropy for " + i + ": " + dArray[i - 1]);
            IJ.showProgress((int)i, (int)255);
        }
        new ShowHistogram(dArray, 1.0, 1.0);
    }
}

