/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import vib.BenesNamedPoint;
import vib.PointList;

public class Points_Dialog
extends Dialog
implements ActionListener,
PlugIn,
PointList.PointListListener {
    private PointsPanel panel;
    private final PopupMenu popup = this.createPopup();
    private Calibration cal;
    private ImagePlus imp;
    private PointList points;
    private BenesNamedPoint current;

    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"There's no image to annotate.");
            return;
        }
        new Points_Dialog(imagePlus);
    }

    public Points_Dialog(ImagePlus imagePlus) {
        this(imagePlus, null);
    }

    public Points_Dialog(ImagePlus imagePlus, PointList pointList) {
        super((Frame)IJ.getInstance(), "Marking up: " + imagePlus.getTitle(), false);
        this.imp = imagePlus;
        this.cal = imagePlus.getCalibration();
        this.points = pointList;
        if (this.points == null) {
            this.points = new PointList();
        }
        this.points.addPointListListener(this);
        this.add(this.popup);
        this.setLayout(new BorderLayout());
        this.add((Component)new Label("Mark the current point selection as:"), "North");
        this.panel = new PointsPanel();
        this.panel.update();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.panel);
        this.add((Component)scrollPane, "Center");
        Panel panel = new Panel();
        Button button = new Button("Load");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Add point");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Save");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Reset");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Close");
        button.addActionListener(this);
        panel.add(button);
        this.add((Component)panel, "South");
        GUI.center((Window)this);
        this.pack();
        this.setVisible(true);
    }

    private PopupMenu createPopup() {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem("Rename point");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Remove point");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Reset point");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        return popupMenu;
    }

    public PointList getPointList() {
        return this.points;
    }

    public void setPoints(PointList pointList) {
        this.points = pointList;
        this.panel.update();
    }

    public void addEmptyPoint() {
        BenesNamedPoint benesNamedPoint = new BenesNamedPoint("point" + this.points.size());
        this.points.add(benesNamedPoint);
    }

    public void removePoint(BenesNamedPoint benesNamedPoint) {
        this.points.remove(benesNamedPoint);
    }

    public void renamePoint(BenesNamedPoint benesNamedPoint) {
        String string = IJ.getString((String)"New name", (String)benesNamedPoint.name);
        if (string.equals("")) {
            return;
        }
        this.points.rename(benesNamedPoint, string);
    }

    public void resetPoint(BenesNamedPoint benesNamedPoint) {
        benesNamedPoint.set = false;
        this.panel.update();
    }

    public void resetAll() {
        for (BenesNamedPoint benesNamedPoint : this.points) {
            benesNamedPoint.set = false;
        }
        this.panel.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.dispose();
        } else if (string.equals("Save")) {
            this.save();
        } else if (string.equals("Reset")) {
            this.resetAll();
        } else if (string.equals("Add point")) {
            this.addEmptyPoint();
        } else if (string.equals("Rename point")) {
            this.renamePoint(this.current);
        } else if (string.equals("Remove point")) {
            this.removePoint(this.current);
        } else if (string.equals("Reset point")) {
            this.resetPoint(this.current);
        } else if (string.equals("Load")) {
            this.load();
        }
    }

    public void save() {
        FileInfo fileInfo = this.imp.getOriginalFileInfo();
        if (fileInfo == null) {
            IJ.error((String)"There's no original file name that these points refer to.");
            return;
        }
        String string = fileInfo.fileName;
        String string2 = fileInfo.directory;
        IJ.showStatus((String)("Saving point annotations to " + string2 + string));
        this.points.save(string2, string);
        IJ.showStatus((String)"Saved point annotations.");
    }

    public void showPoint(BenesNamedPoint benesNamedPoint) {
        if (this.imp.getWindow() == null) {
            return;
        }
        if (!benesNamedPoint.set) {
            IJ.error((String)"Point is not set yet");
            return;
        }
        int n = (int)(benesNamedPoint.z / this.cal.pixelDepth);
        if (n < 0) {
            n = 0;
        }
        if (n > this.imp.getStackSize()) {
            n = this.imp.getStackSize() - 1;
        }
        this.imp.setSlice(n + 1);
        PointRoi pointRoi = new PointRoi((int)(benesNamedPoint.x / this.cal.pixelWidth), (int)(benesNamedPoint.y / this.cal.pixelHeight), this.imp);
        this.imp.setRoi((Roi)pointRoi);
    }

    public void load() {
        PointList pointList = PointList.load(this.imp);
        if (pointList == null) {
            return;
        }
        for (BenesNamedPoint benesNamedPoint : pointList) {
            boolean bl = false;
            for (BenesNamedPoint benesNamedPoint2 : this.points) {
                if (!benesNamedPoint.name.equals(benesNamedPoint2.name)) continue;
                benesNamedPoint2.set(benesNamedPoint.x, benesNamedPoint.y, benesNamedPoint.z);
                benesNamedPoint2.set = true;
                bl = true;
            }
            if (bl) continue;
            this.points.add(benesNamedPoint);
        }
    }

    public void mark(BenesNamedPoint benesNamedPoint) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            Polygon polygon = roi.getPolygon();
            if (polygon.npoints > 1) {
                IJ.error((String)"You can only have one point selected to mark.");
                return;
            }
            double d = (double)polygon.xpoints[0] * this.cal.pixelWidth;
            double d2 = (double)polygon.ypoints[0] * this.cal.pixelHeight;
            double d3 = (double)(this.imp.getCurrentSlice() - 1) * this.cal.pixelDepth;
            this.points.placePoint(benesNamedPoint, d, d2, d3);
        } else {
            IJ.error((String)("You must have a current point selection in " + this.imp.getTitle() + " in order to mark points."));
        }
    }

    public void added(BenesNamedPoint benesNamedPoint) {
        this.panel.update();
    }

    public void removed(BenesNamedPoint benesNamedPoint) {
        this.panel.update();
    }

    public void renamed(BenesNamedPoint benesNamedPoint) {
        this.panel.update();
    }

    public void moved(BenesNamedPoint benesNamedPoint) {
        this.panel.update();
    }

    public void highlighted(BenesNamedPoint benesNamedPoint) {
    }

    public void reordered() {
        this.panel.update();
    }

    private class PointsPanel
    extends Panel {
        private PointsPanel() {
        }

        public void update() {
            if (Points_Dialog.this.points.size() == 0) {
                Points_Dialog.this.addEmptyPoint();
            }
            Points_Dialog.this.panel.removeAll();
            Points_Dialog.this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            for (BenesNamedPoint benesNamedPoint : Points_Dialog.this.points) {
                this.addRow(benesNamedPoint, gridBagConstraints);
            }
            Points_Dialog.this.pack();
        }

        private void addRow(final BenesNamedPoint benesNamedPoint, GridBagConstraints gridBagConstraints) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.anchor = 21;
            final Button button = new Button(benesNamedPoint.name);
            button.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Points_Dialog.this.current = benesNamedPoint;
                        Points_Dialog.this.popup.show(button, mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Points_Dialog.this.current = benesNamedPoint;
                        Points_Dialog.this.popup.show(button, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Points_Dialog.this.mark(benesNamedPoint);
                }
            });
            Points_Dialog.this.panel.add((Component)button, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 1;
            Label label = benesNamedPoint.set ? new Label(benesNamedPoint.coordinatesAsString()) : new Label("     <unset>     ");
            Points_Dialog.this.panel.add((Component)label, gridBagConstraints);
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 2;
            Button button2 = new Button("Show");
            button2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Points_Dialog.this.showPoint(benesNamedPoint);
                }
            });
            button2.setEnabled(benesNamedPoint.set);
            Points_Dialog.this.panel.add((Component)button2, gridBagConstraints);
        }
    }
}

