/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Euclidean;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.Vector;
import math3d.Point3d;
import process3d.Gradient_;
import process3d.Rebin_;
import process3d.Smooth_;
import vib.AugmentedLandmarkWarp_;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.Resample_;
import vib.RigidRegistration_;
import vib.TransformedImage;

public class Raster_Rigid
implements PlugIn {
    ImagePlus templ;
    ImagePlus model;
    ImagePlus warped;
    private static final int INIT_WIDTH = 512;
    private static final double TOLERANCE = 1.0;
    private static final float SMOOTH = 4.0f;
    private static final int GRID_W = 3;
    private static final int GRID_H = 3;
    private static final int GRID_D = 2;
    private static final int STARTL = 3;
    private static final int STOPL = 1;
    private boolean verbose = false;
    private Vector transformations;
    private Vector centers;
    private FastMatrix globalRigid;

    public void run(String string) {
        GenericDialog genericDialog = new GenericDialog("Raster Rigid Registration");
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = WindowManager.getImage((int)nArray[i]).getTitle();
        }
        genericDialog.addChoice("Template", stringArray, stringArray[0]);
        genericDialog.addChoice("Model", stringArray, stringArray[0]);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.templ = WindowManager.getImage((String)genericDialog.getNextChoice());
        this.model = WindowManager.getImage((String)genericDialog.getNextChoice());
        this.register();
        this.warp(this.model);
        this.warped.show();
    }

    public void register() {
        ImagePlus imagePlus = this.preprocess(this.templ);
        ImagePlus imagePlus2 = this.preprocess(this.model);
        TransformedImage transformedImage = new TransformedImage(imagePlus, imagePlus2);
        transformedImage.measure = new Euclidean();
        this.globalRigid = new RigidRegistration_().rigidRegistration(transformedImage, "", "", -1, -1, false, 4, 2, 1.0, 1, false, false, false, null);
        this.transformations = new Vector();
        this.centers = new Vector();
        int n = this.templ.getWidth();
        int n2 = this.templ.getHeight();
        int n3 = this.templ.getStackSize();
        int n4 = n / 3;
        int n5 = n2 / 3;
        int n6 = n3 / 2;
        for (int i = 0; i < 3; ++i) {
            int n7 = i * (n6 / 2);
            if (n7 + 2 > n3) {
                n7 = n3 - 2;
            }
            for (int j = 0; j < 5; ++j) {
                int n8 = j * (n5 / 2);
                if (n8 + 3 > n2) {
                    n8 = n2 - 3;
                }
                for (int k = 0; k < 5; ++k) {
                    int n9 = k * (n4 / 2);
                    if (n9 + 3 > n) {
                        n9 = n - 3;
                    }
                    transformedImage.narrowBBox(n9, n9 + n4, n8, n8 + n5, n7, n7 + n6);
                    float f = this.getMeanValue(transformedImage.orig.image, n9, n8, n7, n4, n5, n6);
                    if ((double)f <= 10.0) continue;
                    FastMatrix fastMatrix = new RigidRegistration_().rigidRegistration(transformedImage, "", this.globalRigid.toString(), -1, -1, false, 3, 3, 1.0, 1, false, false, false, null);
                    fastMatrix = fastMatrix.times(this.globalRigid);
                    this.transformations.add(fastMatrix);
                    this.centers.add(new Point3d(n9 + n4 / 2, n8 + n5 / 2, n7 + n6 / 2));
                    if (!this.verbose) continue;
                    transformedImage.setTransformation(fastMatrix);
                    ImagePlus imagePlus3 = transformedImage.getTransformed();
                    imagePlus3.setTitle("transformed_" + k + "_" + j + "_" + i);
                    imagePlus3.show();
                }
            }
        }
    }

    private ImagePlus preprocess(ImagePlus imagePlus) {
        int n = Math.round(imagePlus.getWidth() / 512);
        int n2 = Math.round(imagePlus.getHeight() / 512);
        int n3 = Math.round(2 * imagePlus.getStackSize() / 512);
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n != 1 || n2 != 1 || n3 != 1) {
            imagePlus = Resample_.resample(imagePlus, n, n2, n3);
        }
        imagePlus = Smooth_.smooth(imagePlus, true, 4.0f, true);
        imagePlus = Gradient_.calculateGrad(imagePlus, true);
        imagePlus = Rebin_.rebin(imagePlus, 256);
        return imagePlus;
    }

    private void warp(ImagePlus imagePlus) {
        AugmentedLandmarkWarp_ augmentedLandmarkWarp_ = new AugmentedLandmarkWarp_();
        augmentedLandmarkWarp_.ii = new InterpolatedImage(this.templ).cloneDimensionsOnly();
        augmentedLandmarkWarp_.model = new InterpolatedImage(imagePlus);
        FastMatrix[] fastMatrixArray = new FastMatrix[this.transformations.size()];
        this.transformations.toArray(fastMatrixArray);
        augmentedLandmarkWarp_.matrix = fastMatrixArray;
        Point3d[] point3dArray = new Point3d[this.centers.size()];
        this.centers.toArray(point3dArray);
        augmentedLandmarkWarp_.setCenter(point3dArray);
        augmentedLandmarkWarp_.run();
        augmentedLandmarkWarp_.ii.image.setTitle(imagePlus + "_warped");
        this.warped = augmentedLandmarkWarp_.ii.image;
    }

    private float getMeanValue(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n7 = imagePlus.getWidth();
        for (int i = n3; i < n3 + n6; ++i) {
            byte[] byArray = (byte[])imagePlus.getStack().getPixels(i + 1);
            for (int j = n2; j < n2 + n5; ++j) {
                for (int k = n; k < n + n5; ++k) {
                    f += (float)(byArray[j * n7 + k] & 0xFF);
                    f2 += 1.0f;
                }
            }
        }
        return f / f2;
    }
}

