/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

class ShellsCanvas
extends ImageCanvas {
    private ImagePlus imagePlus;
    private double x_spacing;
    private double y_spacing;
    private double z_spacing;
    private double centre_x;
    private double centre_y;
    private double centre_z;
    private int width;
    private int height;
    private int depth;
    private ArrayList<Double> radii;

    public ShellsCanvas(ImagePlus imagePlus, double d, double d2, double d3) {
        super(imagePlus);
        this.imagePlus = imagePlus;
        this.centre_x = d;
        this.centre_y = d2;
        this.centre_z = d3;
        System.out.println("Creating canvas with shells centred around: " + d + "," + d2 + "," + d3);
        this.radii = new ArrayList();
        Calibration calibration = imagePlus.getCalibration();
        this.x_spacing = calibration.pixelWidth;
        this.y_spacing = calibration.pixelHeight;
        this.z_spacing = calibration.pixelDepth;
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
    }

    public void addRadius(double d) {
        System.out.println("Added radius: " + d);
        this.radii.add(new Double(d));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawOverlay(graphics);
    }

    public void drawOverlay(Graphics graphics) {
        graphics.setColor(Color.RED);
        int n = (int)Math.ceil(this.getMagnification());
        int n2 = this.imp.getCurrentSlice() - 1;
        for (int i = 0; i < this.radii.size(); ++i) {
            double d = this.radii.get(i);
            double d2 = this.z_spacing * (double)n2;
            double d3 = d2 - this.centre_z;
            double d4 = d * d - d3 * d3;
            double d5 = Math.sqrt(d4);
            double d6 = (this.centre_x - d5) / this.x_spacing;
            double d7 = (this.centre_x + d5) / this.x_spacing;
            double d8 = (this.centre_y - d5) / this.y_spacing;
            double d9 = (this.centre_y + d5) / this.y_spacing;
            int n3 = this.screenX((int)Math.round(d6));
            int n4 = this.screenX((int)Math.round(d7));
            int n5 = this.screenY((int)Math.round(d8));
            int n6 = this.screenY((int)Math.round(d9));
            graphics.drawOval(n3, n5, n4 - n3, n6 - n5);
        }
    }
}

