/*
 * Decompiled with CFR 0.152.
 */
package vib.app;

import amira.AmiraMeshDecoder;
import amira.AmiraTable;
import amira.AmiraTableEncoder;
import ij.text.TextPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import vib.FloatMatrix;

public class ImageMetaData {
    public Material[] materials = new Material[0];
    public Transformation[] transformations = new Transformation[0];
    private String statisticsPath;
    private static final String AMIRA_HEADINGS = "Nr\tMaterial\tCount\tVolume\tCenterX\tCenterY\tCenterZ";

    public ImageMetaData() {
    }

    public ImageMetaData(String string) {
        this();
        this.loadFrom(string);
    }

    public FloatMatrix getMatrix(String string) {
        for (int i = 0; i < this.transformations.length; ++i) {
            if (!this.transformations[i].name.equals(string)) continue;
            return this.transformations[i].matrix;
        }
        return null;
    }

    public void setMatrix(String string, FloatMatrix floatMatrix) {
        for (int i = 0; i < this.transformations.length; ++i) {
            if (!this.transformations[i].name.equals(string)) continue;
            this.transformations[i].matrix = floatMatrix;
            return;
        }
        Transformation[] transformationArray = new Transformation[this.transformations.length + 1];
        System.arraycopy(this.transformations, 0, transformationArray, 0, this.transformations.length);
        Transformation transformation = new Transformation();
        transformation.name = string;
        transformation.matrix = floatMatrix;
        transformationArray[this.transformations.length] = transformation;
        this.transformations = transformationArray;
    }

    public Material getMaterial(String string) {
        for (int i = 0; i < this.materials.length; ++i) {
            if (!this.materials[i].name.equals(string)) continue;
            return this.materials[i];
        }
        return null;
    }

    public int getMaterialIndex(String string) {
        for (int i = 0; i < this.materials.length; ++i) {
            if (!this.materials[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setMaterial(String string, int n, double d, double d2, double d3, double d4) {
        Material[] materialArray;
        int n2 = this.getMaterialIndex(string);
        if (n2 < 0) {
            materialArray = new Material[this.materials.length + 1];
            n2 = this.materials.length;
            System.arraycopy(this.materials, 0, materialArray, 0, n2);
            this.materials = materialArray;
            this.materials[n2] = new Material();
        }
        materialArray = this.materials[n2];
        materialArray.name = string;
        materialArray.count = n;
        materialArray.volume = d;
        materialArray.centerX = d2;
        materialArray.centerY = d3;
        materialArray.centerZ = d4;
    }

    public void loadFrom(String string) {
        Object object;
        this.statisticsPath = string;
        if (!new File(string).exists()) {
            return;
        }
        AmiraMeshDecoder amiraMeshDecoder = new AmiraMeshDecoder();
        if (!amiraMeshDecoder.open(string) || !amiraMeshDecoder.isTable()) {
            return;
        }
        AmiraTable amiraTable = amiraMeshDecoder.getTable();
        TextPanel textPanel = amiraTable.getTextPanel();
        this.materials = new Material[textPanel.getLineCount()];
        for (int i = 0; i < this.materials.length; ++i) {
            object = ImageMetaData.split(textPanel.getLine(i));
            this.materials[i] = new Material();
            this.materials[i].name = object[1];
            this.materials[i].count = Integer.parseInt((String)object[2]);
            this.materials[i].volume = Double.parseDouble((String)object[3]);
            this.materials[i].centerX = Double.parseDouble((String)object[4]);
            this.materials[i].centerY = Double.parseDouble((String)object[5]);
            this.materials[i].centerZ = Double.parseDouble((String)object[6]);
        }
        Hashtable hashtable = amiraTable.getParameters();
        amiraTable.close();
        object = new ArrayList();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf("Transformation") < 0) continue;
            Transformation transformation = new Transformation();
            transformation.name = string2;
            String string3 = (String)hashtable.get(string2);
            transformation.matrix = FloatMatrix.parseMatrix(string3);
            ((ArrayList)object).add(transformation);
        }
        this.transformations = new Transformation[((ArrayList)object).size()];
        for (int i = 0; i < this.transformations.length; ++i) {
            this.transformations[i] = (Transformation)((ArrayList)object).get(i);
        }
    }

    public boolean saveTo(String string) {
        Object object;
        this.statisticsPath = string;
        String string2 = "";
        for (int i = 0; i < this.materials.length; ++i) {
            object = this.materials[i];
            string2 = string2 + "" + (i + 1) + "\t" + ((Material)object).name + "\t" + ((Material)object).count + "\t" + ((Material)object).volume + "\t" + ((Material)object).centerX + "\t" + ((Material)object).centerY + "\t" + ((Material)object).centerZ + "\n";
        }
        AmiraTable amiraTable = new AmiraTable("Statistics for " + string, AMIRA_HEADINGS, string2, true);
        object = amiraTable.getParameters();
        for (int i = 0; i < this.transformations.length; ++i) {
            Transformation transformation = this.transformations[i];
            ((Hashtable)object).put(transformation.name, transformation.matrix.toStringForAmira());
        }
        AmiraTableEncoder amiraTableEncoder = new AmiraTableEncoder(amiraTable);
        return amiraTableEncoder.write(string);
    }

    private static String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        do {
            int n2 = n;
            if ((n = string.indexOf(9, n + 1)) >= 0) {
                arrayList.add(string.substring(n2 + 1, n));
                continue;
            }
            arrayList.add(string.substring(n2 + 1));
        } while (n >= 0);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public boolean upToDate(String string, String string2) {
        File file = new File(this.statisticsPath);
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(string);
        if (file2.exists() && file.lastModified() < file2.lastModified()) {
            return false;
        }
        return this.getMatrix(string2) != null;
    }

    public static class Transformation {
        public String name;
        FloatMatrix matrix;
    }

    public static class Material {
        public String name;
        public int count;
        public double volume;
        public double centerX;
        public double centerY;
        public double centerZ;
    }
}

