/*
 * Decompiled with CFR 0.152.
 */
package vib.app;

import ij.IJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import vib.app.FileGroup;

public class Options {
    public static final String CONFIG_FILE = "options.config";
    public static final int GREY = 0;
    public static final int LABEL_SURFACE = 1;
    public static final int CENTER = 2;
    public static final int LABEL_DIFFUSION = 3;
    public static final String[] TRANSFORMS = new String[]{"VIBgreyTransformation", "VIBlabelSurfaceTransformation", "VIBcenterTransformation", "VIBlabelDiffusionTransformation"};
    public static final String[] TRANSFORM_LABELS = new String[]{"RegistrationTransformation", "LabelSurfaceTransformation", "SCenterTransformation", "SLabelTransformation"};
    public String workingDirectory;
    public FileGroup fileGroup;
    public String templatePath;
    public int numChannels = 2;
    public int refChannel = 2;
    public int resamplingFactor = 1;
    public int transformationMethod = 3;

    public Options() {
        this.fileGroup = new FileGroup("NewFilegroup");
    }

    public Options(String string) {
        this.workingDirectory = string;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        } else {
            File file2 = new File(string, CONFIG_FILE);
            if (file2.exists()) {
                this.loadFrom(file2.getAbsolutePath());
            }
        }
        if (this.fileGroup == null) {
            this.fileGroup = new FileGroup("NewFilegroup");
        }
    }

    public Options(File file) {
        this(file.getAbsolutePath());
    }

    public void setTransformationMethod(String string) {
        for (int i = 0; i < TRANSFORMS.length; ++i) {
            if (!TRANSFORMS[i].equals(string)) continue;
            this.transformationMethod = i;
            return;
        }
        throw new RuntimeException("Unknown method: " + string);
    }

    public boolean needsLabels() {
        return Options.needsLabels(this.transformationMethod);
    }

    public static boolean needsLabels(int n) {
        return n != 0;
    }

    public boolean isTransformationValid(String string) {
        for (int i = 0; i < TRANSFORMS.length; ++i) {
            if (!TRANSFORMS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        File file = new File(this.workingDirectory);
        return !this.fileGroup.isEmpty() && this.templatePath != null && new File(this.templatePath).exists() && this.numChannels > 0 && this.refChannel > 0 && this.refChannel <= this.numChannels && file.exists() && file.isDirectory() && this.transformationMethod >= 0 && this.transformationMethod <= 3;
    }

    public Options clone() {
        Options options = new Options();
        options.copy(this);
        return options;
    }

    public void copy(Options options) {
        this.workingDirectory = options.workingDirectory;
        this.templatePath = options.templatePath;
        this.numChannels = options.numChannels;
        this.refChannel = options.refChannel;
        this.fileGroup = options.fileGroup;
        this.transformationMethod = options.transformationMethod;
        this.resamplingFactor = options.resamplingFactor;
    }

    public void saveTo(String string) {
        Properties properties = new Properties();
        properties.setProperty("template", this.templatePath);
        properties.setProperty("numChannels", "" + this.numChannels);
        properties.setProperty("refChannel", "" + this.refChannel);
        properties.setProperty("resamplingFactor", "" + this.resamplingFactor);
        properties.setProperty("transformationMethod", TRANSFORMS[this.transformationMethod]);
        properties.setProperty("fileGroup", this.fileGroup.toCSV());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, "Created by the VIB application");
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.showMessage((String)("Can't find file " + string));
        }
        catch (IOException iOException) {
            IJ.showMessage((String)("Can't write to file " + string));
        }
    }

    static int getInt(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public void loadFrom(String string) {
        Object object;
        Properties properties = new Properties();
        try {
            object = new File(string);
            properties.load(new FileInputStream((File)object));
            this.workingDirectory = ((File)object).getParentFile().getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.showMessage((String)("Can't find file " + string));
            return;
        }
        catch (IOException iOException) {
            IJ.showMessage((String)("Can't read from file " + string));
            return;
        }
        this.templatePath = properties.getProperty("template", "");
        this.numChannels = Options.getInt(properties, "numChannels", 2);
        this.refChannel = Options.getInt(properties, "refChannel", 2);
        object = properties.getProperty("transformationMethod");
        try {
            this.setTransformationMethod((String)object);
        }
        catch (Exception exception) {
            this.transformationMethod = 3;
        }
        this.resamplingFactor = Options.getInt(properties, "resamplingFactor", 1);
        if (!this.fileGroup.fromCSV(properties.getProperty("fileGroup", ""))) {
            IJ.showMessage((String)"Not all files specified in the file group exist.");
        }
        if (!this.isValid()) {
            IJ.showMessage((String)"There occured an error while setting the options. I set some of them, but you should check them manually.");
            return;
        }
    }

    public String toString() {
        return "Options:\nworkingDirectory = " + this.workingDirectory + "\n" + "template = " + this.templatePath + "\n" + "numChannels = " + this.numChannels + "\n" + "refChannel = " + this.refChannel + "\n" + "transformationMethod = " + this.transformationMethod + "\n" + "resamplingFactor = " + this.resamplingFactor + "\n" + "fileGroup: " + this.fileGroup;
    }

    public void debug() {
        System.out.print("\n" + this);
    }

    public static void main(String[] stringArray) {
        System.out.println("Options");
        if (stringArray.length > 0) {
            Options options = new Options();
            if (stringArray[0].equals("--save") && stringArray.length > 1) {
                options.saveTo(stringArray[1]);
            } else {
                options.loadFrom(stringArray[0]);
            }
            options.debug();
        }
    }
}

