/*
 * Decompiled with CFR 0.152.
 */
package vib.app.gui;

import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import vib.app.FileGroup;

public class FileGroupDialog
extends Panel
implements ActionListener,
DropTargetListener {
    private FileGroup files;
    private boolean showWholePath = false;
    private List list;
    private TextField nameTF;
    private Button add;
    private Button delete;
    private Button template;
    private Checkbox wholePath;
    private boolean showTemplateButton;

    public FileGroupDialog(FileGroup fileGroup) {
        this(fileGroup, true);
    }

    public FileGroupDialog(FileGroup fileGroup, boolean bl) {
        this.files = fileGroup;
        this.showTemplateButton = bl;
        this.list = new List();
        this.list.setDropTarget(null);
        DropTarget dropTarget = new DropTarget(this.list, this);
        this.createList();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        Label label = new Label("Files: ");
        label.setFont(new Font("Monospace", 1, 14));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.list);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(scrollPane, gridBagConstraints);
        this.add(scrollPane);
        Panel panel = new Panel(new GridLayout(3, 1));
        this.add = new Button("Add to files");
        this.add.addActionListener(this);
        panel.add(this.add);
        this.delete = new Button("Delete from files");
        this.delete.addActionListener(this);
        panel.add(this.delete);
        this.template = new Button("Use as template");
        this.template.addActionListener(this);
        if (bl) {
            panel.add(this.template);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.wholePath = new Checkbox("Show absolute path", this.showWholePath);
        this.wholePath.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FileGroupDialog.this.showWholePath = FileGroupDialog.this.wholePath.getState();
                FileGroupDialog.this.createList();
                FileGroupDialog.this.repaint();
            }
        });
        ++gridBagConstraints.gridy;
        --gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.wholePath, gridBagConstraints);
        this.add(this.wholePath);
    }

    public File getSelected() {
        int n = this.list.getSelectedIndex();
        if (n != -1) {
            return (File)this.files.get(n);
        }
        return null;
    }

    public Button getTemplateButton() {
        return this.template;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.add) {
            OpenDialog openDialog = new OpenDialog("Add file...", "");
            String string = openDialog.getDirectory() + openDialog.getFileName();
            if (string != null && !this.files.add(string)) {
                System.out.println("File " + string + " could not be added to the filegroup");
            }
            this.createList();
            this.repaint();
        } else if (actionEvent.getSource() == this.delete) {
            int[] nArray = this.list.getSelectedIndexes();
            for (int i = 0; i < nArray.length; ++i) {
                this.files.remove(nArray[i]);
            }
            this.createList();
            this.repaint();
        }
    }

    public void update() {
        this.createList();
        this.repaint();
    }

    private void createList() {
        this.list.clear();
        for (int i = 0; i < this.files.size(); ++i) {
            if (this.showWholePath) {
                this.list.add(((File)this.files.get(i)).getAbsolutePath());
                continue;
            }
            this.list.add(((File)this.files.get(i)).getName());
        }
    }

    private static java.util.List textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            java.util.List list = null;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                list = (java.util.List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            } else {
                DataFlavor dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(dataFlavor)) {
                    Object object = (String)transferable.getTransferData(dataFlavor);
                    System.out.println("got data: " + (String)object);
                    list = FileGroupDialog.textURIListToFileList((String)object);
                }
            }
            if (list != null) {
                for (Object object : list) {
                    this.files.add(((File)object).getAbsolutePath());
                }
                this.update();
            }
            dropTargetDropEvent.dropComplete(true);
        }
        catch (Exception exception) {
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public static void main(String[] stringArray) {
        FileGroup fileGroup = new FileGroup("TestGroup");
        fileGroup.add("/home/bene/apt_list");
        fileGroup.add("/home/bene/tmp.java");
        fileGroup.add("/home/bene/tmp.class");
        Frame frame = new Frame();
        FileGroupDialog fileGroupDialog = new FileGroupDialog(fileGroup);
        frame.add(fileGroupDialog);
        frame.pack();
        frame.show();
        fileGroup.debug();
    }
}

