/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.AverageBrain_;
import vib.FastMatrix;
import vib.app.module.Module;
import vib.app.module.Resample;
import vib.app.module.State;
import vib.app.module.TransformImages;

public class AverageBrain
extends Module {
    private FastMatrix[] matrices;
    private ImagePlus scratch;

    public String getName() {
        return "AverageBrain";
    }

    protected String getMessage() {
        return "Averaging brain";
    }

    protected boolean runsOnce() {
        return true;
    }

    protected void run(State state, int n) {
        if (n != 0) {
            return;
        }
        new TransformImages().runOnAllImages(state);
        new Resample().runOnAllImages(state);
        this.prereqsDone(state, n);
        new AverageBrain().doit(state);
    }

    private void doit(State state) {
        this.matrices = null;
        this.scratch = null;
        for (int i = -1; i < state.options.numChannels; ++i) {
            String string = state.getOutputPath(i);
            this.doit(state, this.getCompleteChannel(state, i), string);
        }
    }

    public void doit(State state, String[] stringArray, String string) {
        if (State.upToDate(stringArray, string)) {
            return;
        }
        AverageBrain_ averageBrain_ = new AverageBrain_();
        if (this.matrices == null) {
            this.matrices = this.getMatrices(state);
        }
        if (this.scratch == null) {
            this.scratch = state.options.needsLabels() ? state.getTemplateLabels() : state.getTemplate();
        }
        averageBrain_.doit(this.scratch, stringArray, this.matrices);
        if (!state.save(this.scratch, string)) {
            throw new RuntimeException("Could not save " + string);
        }
    }

    private FastMatrix[] getMatrices(State state) {
        FastMatrix[] fastMatrixArray = new FastMatrix[state.getImageCount()];
        for (int i = 0; i < fastMatrixArray.length; ++i) {
            fastMatrixArray[i] = new FastMatrix();
            fastMatrixArray[i].copyFrom(state.getTransformMatrix(i));
        }
        return fastMatrixArray;
    }

    private String[] getCompleteChannel(State state, int n) {
        String[] stringArray = new String[state.getImageCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = state.getWarpedPath(n, i);
        }
        return stringArray;
    }
}

