/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import java.util.ArrayList;
import math3d.Point3d;
import vib.FloatMatrix;
import vib.app.ImageMetaData;
import vib.app.module.Module;
import vib.app.module.State;
import vib.app.module.TissueStatistics;

public class CenterTransformation
extends Module {
    public String getName() {
        return "CenterTransformation";
    }

    protected String getMessage() {
        return "Calculating center transformation";
    }

    protected void run(State state, int n) {
        Point3d[] point3dArray;
        new TissueStatistics().runOnOneImage(state, -1);
        new TissueStatistics().runOnOneImage(state, n);
        this.prereqsDone(state, n);
        String string = state.getStatisticsPath(n);
        String string2 = state.getStatisticsPath(-1);
        ImageMetaData imageMetaData = new ImageMetaData(string);
        String string3 = state.getTransformLabel(2);
        if (imageMetaData.upToDate(string2, string3)) {
            return;
        }
        ImageMetaData imageMetaData2 = new ImageMetaData(string2);
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        ArrayList<Point3d> arrayList2 = new ArrayList<Point3d>();
        for (int i = 1; i < imageMetaData2.materials.length; ++i) {
            String string4;
            ImageMetaData.Material material;
            point3dArray = imageMetaData2.materials[i];
            if (point3dArray.count == 0 || (material = imageMetaData.getMaterial(string4 = point3dArray.name)) == null || material.count == 0) continue;
            Point3d point3d = new Point3d(point3dArray.centerX, point3dArray.centerY, point3dArray.centerZ);
            arrayList.add(point3d);
            point3d = new Point3d(material.centerX, material.centerY, material.centerZ);
            arrayList2.add(point3d);
        }
        if (arrayList2.size() == 0) {
            return;
        }
        Point3d[] point3dArray2 = new Point3d[arrayList2.size()];
        point3dArray = new Point3d[arrayList2.size()];
        for (int i = 0; i < point3dArray2.length; ++i) {
            point3dArray2[i] = (Point3d)arrayList.get(i);
            point3dArray[i] = (Point3d)arrayList2.get(i);
        }
        FloatMatrix floatMatrix = FloatMatrix.bestRigid(point3dArray, point3dArray2);
        imageMetaData.setMatrix(string3, floatMatrix);
        if (!imageMetaData.saveTo(string)) {
            throw new RuntimeException("Could not save " + string);
        }
    }
}

