/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.DiffusionInterpol2_;
import vib.FloatMatrix;
import vib.InterpolatedImage;
import vib.app.ImageMetaData;
import vib.app.module.LabelCenterTransformation;
import vib.app.module.Module;
import vib.app.module.Resample;
import vib.app.module.State;

public class LabelDiffusionTransformation
extends Module {
    public String getName() {
        return "LabelDiffusionTransformation";
    }

    protected String getMessage() {
        return "Calculating label diffusion transformation";
    }

    protected void run(State state, int n) {
        new Resample().runOnOneImage(state, n);
        new LabelCenterTransformation().runOnOneImage(state, n);
        this.prereqsDone(state, n);
        ImagePlus imagePlus = null;
        DiffusionInterpol2_ diffusionInterpol2_ = new DiffusionInterpol2_();
        boolean bl = true;
        boolean bl2 = false;
        float f = 0.5f;
        FloatMatrix[] floatMatrixArray = null;
        for (int i = -1; i < state.options.numChannels; ++i) {
            String string = state.getResampledPath(i, n);
            String string2 = state.getWarpedPath(i, n);
            String string3 = state.getStatisticsPath(n);
            if (State.upToDate(new String[]{string, string3}, string2)) continue;
            if (imagePlus == null) {
                imagePlus = state.getTemplateLabels();
            }
            InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
            ImagePlus imagePlus2 = interpolatedImage.cloneDimensionsOnly().getImage();
            if (floatMatrixArray == null) {
                floatMatrixArray = LabelDiffusionTransformation.readTransformations(state, n);
            }
            ImagePlus imagePlus3 = state.getImage(string);
            FloatMatrix[] floatMatrixArray2 = LabelDiffusionTransformation.copyMatrices(floatMatrixArray);
            diffusionInterpol2_.initialize(imagePlus2, imagePlus, imagePlus3, floatMatrixArray2, bl2, bl, f);
            diffusionInterpol2_.doit();
            bl2 = true;
            if (state.save(imagePlus2, string2)) continue;
            throw new RuntimeException("Could not save " + string2);
        }
    }

    private static FloatMatrix[] readTransformations(State state, int n) {
        ImageMetaData imageMetaData = state.getStatistics(-1);
        ImageMetaData imageMetaData2 = state.getStatistics(n);
        FloatMatrix[] floatMatrixArray = new FloatMatrix[imageMetaData.materials.length];
        for (int i = 0; i < floatMatrixArray.length; ++i) {
            String string = imageMetaData.materials[i].name;
            String string2 = state.getTransformLabel() + string;
            floatMatrixArray[i] = imageMetaData2.getMatrix(string2);
        }
        return floatMatrixArray;
    }

    private static FloatMatrix[] copyMatrices(FloatMatrix[] floatMatrixArray) {
        FloatMatrix[] floatMatrixArray2 = new FloatMatrix[floatMatrixArray.length];
        System.arraycopy(floatMatrixArray, 0, floatMatrixArray2, 0, floatMatrixArray.length);
        return floatMatrixArray2;
    }
}

