/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import java.util.Iterator;
import java.util.Vector;
import vib.app.gui.Console;
import vib.app.module.ModuleListener;
import vib.app.module.State;

public abstract class Module {
    protected Console console;
    protected static Vector listeners = new Vector();
    private static boolean exception = false;

    public abstract String getName();

    protected abstract String getMessage();

    protected abstract void run(State var1, int var2);

    protected boolean runsOnce() {
        return false;
    }

    public void runOnOneImage(State state, int n) {
        this.console = Console.instance();
        try {
            this.run(state, n);
        }
        catch (Exception exception) {
            if (!Module.exception) {
                Module.exception = true;
                this.exceptionOccurred(n);
            }
            throw new RuntimeException("Exception in " + this.getName(), exception);
        }
        this.finished(n);
    }

    public void runOnAllImages(State state) {
        for (int i = 0; i < state.getImageCount(); ++i) {
            this.runOnOneImage(state, i);
        }
    }

    public void runOnAllImagesAndTemplate(State state) {
        for (int i = -1; i < state.getImageCount(); ++i) {
            this.runOnOneImage(state, i);
        }
    }

    public void prereqsDone(State state, int n) {
        String string = this.getMessage();
        if (!this.runsOnce()) {
            string = string + ": " + state.getBaseName(n) + " (" + (n + 1) + "/" + state.getImageCount() + ")";
        }
        this.console.append(string);
    }

    public void finished(int n) {
        Iterator iterator = Module.listeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).moduleFinished(this, n);
        }
    }

    public void exceptionOccurred(int n) {
        Iterator iterator = Module.listeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).exceptionOccurred(this, n);
        }
    }

    public static void addModuleListener(ModuleListener moduleListener) {
        listeners.add(moduleListener);
    }

    public static Iterator listeners() {
        return listeners.iterator();
    }
}

