/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.Resample_;
import vib.app.module.Module;
import vib.app.module.SplitChannels;
import vib.app.module.State;

public class Resample
extends Module {
    public String getName() {
        return "Resample";
    }

    protected String getMessage() {
        return "Resampling";
    }

    protected void run(State state, int n) {
        if (state.options.numChannels > 1) {
            new SplitChannels().runOnOneImage(state, n);
        }
        this.prereqsDone(state, n);
        if (state.options.resamplingFactor == 1) {
            return;
        }
        for (int i = 0; i < state.options.numChannels; ++i) {
            if (i == state.options.refChannel - 1) continue;
            this.run(state, i, n);
        }
        this.run(state, state.options.refChannel - 1, n);
    }

    private void run(State state, int n, int n2) {
        String string = state.getImagePath(n, n2);
        String string2 = state.getResampledPath(n, n2);
        if (State.upToDate(string, string2)) {
            return;
        }
        ImagePlus imagePlus = state.getImage(string);
        if (imagePlus == null) {
            return;
        }
        ImagePlus imagePlus2 = Resample_.resample(imagePlus, state.options.resamplingFactor);
        if (!state.save(imagePlus2, string2)) {
            throw new RuntimeException("Could not save " + string2);
        }
    }
}

