/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.IJ;
import ij.ImagePlus;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import vib.app.module.Module;
import vib.app.module.State;

public class Show
extends Module {
    private static final int[] redSteps = new int[]{0, 45, 25, 0, 40, 0, 65, 25, 140, 20, 170, 150, 190, 210, 255, 255};
    private static final int[] greenSteps = new int[]{0, 2, 30, 0, 100, 180, 190, 210, 255, 35};
    private static final int[] blueSteps = new int[]{0, 125, 70, 170, 100, 180, 140, 25, 255, 20};

    public String getName() {
        return "Show";
    }

    protected String getMessage() {
        return "Displaying the results";
    }

    protected boolean runsOnce() {
        return true;
    }

    protected void run(State state, int n) {
        if (n != 0) {
            return;
        }
        this.prereqsDone(state, n);
        for (int i = -1; i < state.options.numChannels; ++i) {
            IJ.open((String)state.getOutputPath(i));
            if (i >= 0) continue;
            Show.setPhysicsLUT(IJ.getImage());
            IJ.setMinAndMax((double)0.0, (double)100.0);
        }
    }

    private static byte[] makeColorChannel(int[] nArray) {
        byte[] byArray = new byte[256];
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (i > nArray[n + 2]) {
                n += 2;
            }
            byArray[i] = (byte)(nArray[n + 1] + (i - nArray[n]) * (nArray[n + 3] - nArray[n + 1]) / (nArray[n + 2] - nArray[n]));
        }
        return byArray;
    }

    private static void setPhysicsLUT(ImagePlus imagePlus) {
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, Show.makeColorChannel(redSteps), Show.makeColorChannel(greenSteps), Show.makeColorChannel(blueSteps));
        imagePlus.getProcessor().setColorModel((ColorModel)indexColorModel);
        if (imagePlus.getStackSize() > 1) {
            imagePlus.getStack().setColorModel((ColorModel)indexColorModel);
        }
    }
}

