/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import ij.process.StackConverter;
import java.io.File;
import util.BatchOpener;
import vib.app.module.Module;
import vib.app.module.State;

public class SplitChannels
extends Module {
    public String getName() {
        return "SplitChannels";
    }

    protected String getMessage() {
        return "Splitting channels";
    }

    protected void run(State state, int n) {
        int n2;
        this.prereqsDone(state, n);
        int n3 = state.options.numChannels;
        if (n3 < 2) {
            return;
        }
        int n4 = state.options.refChannel - 1;
        File file = n < 0 ? new File(state.options.templatePath) : (File)state.options.fileGroup.get(n);
        String string = file.getAbsolutePath();
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            if (State.upToDate(string, state.getImagePath(i, n))) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        ImagePlus[] imagePlusArray = BatchOpener.open(string);
        for (n2 = 0; n2 < imagePlusArray.length; ++n2) {
            new StackConverter(imagePlusArray[n2]).convertToGray8();
        }
        n2 = imagePlusArray.length;
        if (n2 < n3) {
            if (n < 0 && n2 == 1) {
                string = state.getImagePath(n4, n);
                if (!state.save(imagePlusArray[0], string)) {
                    throw new RuntimeException("Could not save " + string);
                }
                return;
            }
            throw new RuntimeException("Found unexpectedly " + n2 + " channels " + " in " + string);
        }
        for (int i = 0; i < n3; ++i) {
            if (i == n4) continue;
            ImagePlus imagePlus = imagePlusArray[i];
            string = state.getImagePath(i, n);
            if (!state.save(imagePlus, string)) {
                throw new RuntimeException("Could not save " + string);
            }
            new File(string).setLastModified(file.lastModified());
        }
        string = state.getImagePath(n4, n);
        if (!state.save(imagePlusArray[n4], string)) {
            throw new RuntimeException("Could not save " + string);
        }
        new File(string).setLastModified(file.lastModified());
    }
}

