/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import vib.edge.DistanceComparator;
import vib.edge.PointComparator;

public class CircleIterators {
    public static int[][] FullCircle(double d) {
        return CircleIterators.FullCircle(d, true);
    }

    public static int[][] FullCircle(double d, boolean bl) {
        int[] nArray;
        int n;
        int n2;
        int n3;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n3 = (int)d; n3 >= 0; --n3) {
            n2 = (int)Math.sqrt(d * d - (double)(n3 * n3));
            for (n = -n2; n <= n2; ++n) {
                if (!bl && n3 == 0 && n == 0) continue;
                nArray = new int[]{n, n3};
                arrayList.add(nArray);
            }
        }
        for (n3 = 1; n3 <= (int)d; ++n3) {
            n2 = (int)Math.sqrt(d * d - (double)(n3 * n3));
            n = -n2;
            while (n <= n2) {
                nArray = new int[]{n++, -n3};
                arrayList.add(nArray);
            }
        }
        n3 = arrayList.size();
        int[][] nArray2 = new int[n3][2];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = (int[])arrayList.get(n3 - 1 - n);
        }
        return nArray2;
    }

    public static int[][] FullCircleSortedByDistance(double d, boolean bl) {
        int[][] nArray = CircleIterators.FullCircle(d, true);
        DistanceComparator distanceComparator = new DistanceComparator(bl);
        Arrays.sort(nArray, distanceComparator);
        return nArray;
    }

    public static int[][] SortedHalfCircle(double d) {
        int n;
        int n2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n2 = (int)d; n2 >= 0; --n2) {
            int n3 = (int)Math.sqrt(d * d - (double)(n2 * n2));
            int n4 = n = n2 > 0 ? -n3 : 1;
            while (n <= n3) {
                int[] nArray = new int[]{n++, n2};
                arrayList.add(nArray);
            }
        }
        Collections.sort(arrayList, new PointComparator());
        n2 = arrayList.size();
        int[][] nArray = new int[n2][2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = (int[])arrayList.get(n2 - 1 - n);
        }
        return nArray;
    }

    public static int[][][] Edgelets(int[][] nArray, double d) {
        int[][][] nArrayArray = new int[nArray.length][][];
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2;
            double d2 = Math.sqrt(nArray[i][0] * nArray[i][0] + nArray[i][1] * nArray[i][1]);
            double d3 = (double)nArray[i][0] / d2;
            double d4 = (double)nArray[i][1] / d2;
            int n3 = n2 = -2 * (int)d;
            boolean bl = false;
            int[] nArray2 = new int[2];
            for (n = -((int)d); n <= (int)d; ++n) {
                nArray2[0] = (int)(d3 * (double)n);
                nArray2[1] = (int)(d4 * (double)n);
                if (nArray2[0] == n2 && nArray2[1] == n3) continue;
                n2 = nArray2[0];
                n3 = nArray2[1];
                arrayList.add(nArray2);
                nArray2 = new int[2];
            }
            nArrayArray[i] = new int[arrayList.size()][2];
            for (n = 0; n < arrayList.size(); ++n) {
                nArrayArray[i][n] = (int[])arrayList.get(n);
            }
            arrayList.clear();
        }
        return nArrayArray;
    }

    public static int[][] RightSickle(double d) {
        int n = (int)d;
        int[][] nArray = new int[2 * n + 1][2];
        for (int i = n; i >= -n; --i) {
            nArray[i + n][0] = (int)Math.sqrt(d * d - (double)(i * i));
            nArray[i + n][1] = i;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        int n;
        int[][] nArray = CircleIterators.SortedHalfCircle(5.0);
        int[][] nArray2 = new int[11][11];
        for (n = 0; n < nArray.length; ++n) {
            System.out.print("(" + nArray[n][0] + "," + nArray[n][1] + ") ");
            nArray2[5 + nArray[n][0]][5 + nArray[n][1]] = n + 1;
        }
        System.out.println("");
        for (n = -5; n <= 5; ++n) {
            for (int i = -5; i <= 5; ++i) {
                System.out.print((char)(64 + nArray2[5 + i][5 + n]));
            }
            System.out.println("");
        }
        int[][] nArray3 = CircleIterators.SortedHalfCircle(5.0);
        int[][][] nArray4 = CircleIterators.Edgelets(nArray3, 5.0);
        for (int i = 0; i < nArray3.length; ++i) {
            System.out.println("Point (" + nArray3[i][0] + "," + nArray3[i][1] + ")");
            for (int j = 0; j < nArray4[i].length; ++j) {
                System.out.print("(" + nArray4[i][j][0] + "," + nArray4[i][j][1] + ")");
            }
            System.out.println();
        }
    }
}

