/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import inference.LogFuncs;
import vib.InterpolatedImage;
import vib.MaxEntHistogram;
import vib.VIB;
import vib.edge.CircleIterators;
import vib.edge.Harmonic;
import vib.edge.SphereIterators;

public class Dirichlet_Edge
implements PlugInFilter {
    ImagePlus image;
    ImageStack angleStack;
    static final String[] types = new String[]{"MutualInformation", "DirichletMutualInformation", "Dirichlet", "Jensen", "Endres", "Euclidean", "DirichletVarianceMutualInformation", "Dirichlet2"};
    private int maxBin = 255;
    static final Harmonic _harmonic = new Harmonic();

    public void run(ImageProcessor imageProcessor) {
        ImageStack imageStack = this.image.getStack();
        GenericDialog genericDialog = new GenericDialog("Parameters");
        genericDialog.addChoice("measure", types, "DirichletMutualInformation");
        genericDialog.addNumericField("radius", 7.0, 2);
        genericDialog.addCheckbox("useSelection", false);
        genericDialog.addCheckbox("showSelection", false);
        genericDialog.addCheckbox("3d", imageStack.getSize() > 1);
        String[] stringArray = new String[]{"none", "constant", "binom", "maxEnt"};
        genericDialog.addChoice("histogramPostProcessing", stringArray, "none");
        genericDialog.addCheckbox("showAngles", false);
        genericDialog.addCheckbox("showEdgelets", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextChoice();
        Measure measure = string.equals("DirichletMutualInformation") ? new DirichletMutualInformation() : (string.equals("Endres") ? new Endres() : (string.equals("MutualInformation") ? new MutualInformation() : (string.equals("Jensen") ? new Jensen() : (string.equals("Euclidean") ? new Euclidean() : (string.equals("DirichletVarianceMutualInformation") ? new DirichletVarianceMutualInformation() : (string.equals("Dirichlet2") ? new Dirichlet2() : new Dirichlet()))))));
        double d = genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        int n = genericDialog.getNextChoiceIndex();
        boolean bl4 = genericDialog.getNextBoolean();
        boolean bl5 = genericDialog.getNextBoolean();
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        if (this.angleStack == null) {
            this.angleStack = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        }
        InterpolatedImage interpolatedImage = new InterpolatedImage(this.image);
        if (bl3) {
            this.do3d(this.image, imageStack2, measure, d);
        } else {
            for (int i = 1; i <= imageStack.getSize(); ++i) {
                if (bl) {
                    imageStack2.addSlice("", (ImageProcessor)this.doitWithSelection(imageStack.getProcessor(i), measure, d, bl2));
                    continue;
                }
                imageStack2.addSlice("", (ImageProcessor)this.doit(interpolatedImage, i - 1, measure, d, n, bl4, bl5));
            }
        }
        if (bl4) {
            new ImagePlus("Angles of " + string + d, this.angleStack).show();
        }
        new ImagePlus(string + d, imageStack2).show();
    }

    private FloatProcessor doit(InterpolatedImage interpolatedImage, int n, Measure measure, double d, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        int n5 = interpolatedImage.getWidth();
        int n6 = interpolatedImage.getHeight();
        double[] dArray = new double[n5 * n6];
        int n7 = 0;
        boolean[] blArray = new boolean[256];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                blArray[interpolatedImage.getNoInterpol((int)n4, (int)n3, (int)n)] = true;
            }
        }
        this.maxBin = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            if (!blArray[n4]) continue;
            ++n7;
            this.maxBin = n4;
        }
        VIB.println("Number of values in image is " + n7);
        EdgeInformation edgeInformation = new EdgeInformation(interpolatedImage, measure, d, this.maxBin, n7);
        edgeInformation.slice = n;
        edgeInformation.setPostProc(n2);
        if (measure instanceof DirichletVarianceMutualInformation) {
            edgeInformation.var = (DirichletVarianceMutualInformation)measure;
        }
        if (bl) {
            edgeInformation.angles = new double[n5 * n6];
        }
        if (bl2) {
            edgeInformation.initEdgelets();
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (int i = 0; i < n5; ++i) {
                dArray[i + n3 * n5] = edgeInformation.getEdgeInformation(i, n3);
            }
            IJ.showProgress((int)(n3 + 1), (int)n6);
        }
        edgeInformation.postLudium();
        if (bl) {
            this.angleStack.addSlice("", (ImageProcessor)new FloatProcessor(n5, n6, edgeInformation.angles));
        }
        FloatProcessor floatProcessor = new FloatProcessor(n5, n6, dArray);
        return floatProcessor;
    }

    public void do3d(ImagePlus imagePlus, ImageStack imageStack, Measure measure, double d) {
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        int[][] nArray = SphereIterators.SphereIterator(d);
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        GenericDialog genericDialog = new GenericDialog("Normal Coordinates");
        genericDialog.addNumericField("x", dArray[0], 3);
        genericDialog.addNumericField("y", dArray[1], 3);
        genericDialog.addNumericField("z", dArray[2], 3);
        genericDialog.showDialog();
        if (!genericDialog.wasCanceled()) {
            dArray[0] = genericDialog.getNextNumber();
            dArray[1] = genericDialog.getNextNumber();
            dArray[2] = genericDialog.getNextNumber();
        }
        int n = interpolatedImage.getWidth();
        int n2 = interpolatedImage.getHeight();
        int n3 = interpolatedImage.getDepth();
        IJ.showProgress((double)0.0);
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = new double[n * n2];
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n4;
                    double d2 = 0.0;
                    int[][] nArray2 = new int[3][this.maxBin + 1];
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        try {
                            int n5 = interpolatedImage.getNoInterpol(k + nArray[n4][0], j + nArray[n4][1], i + nArray[n4][2]);
                            int[] nArray3 = nArray2[SphereIterators.isUpperHalf(nArray[n4], dArray) ? 0 : 1];
                            int n6 = n5;
                            nArray3[n6] = nArray3[n6] + 1;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (n4 = 0; n4 < nArray2[0].length; ++n4) {
                        d2 += measure.doit(nArray2[0][n4], nArray2[1][n4]);
                    }
                    dArray2[k + n * j] = d2;
                }
                IJ.showProgress((double)(((double)j + 1.0) / (double)n2));
            }
            imageStack.addSlice("", (ImageProcessor)new FloatProcessor(n, n2, dArray2));
            IJ.showProgress((double)(((double)i + 1.0) / (double)n3));
        }
        IJ.showProgress((double)1.0);
    }

    public void do3d_complete(ImagePlus imagePlus, ImageStack imageStack, Measure measure, double d) {
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        int[][] nArray = SphereIterators.SphereIterator(d);
        double[][] dArray = SphereIterators.SampleSphereSurface(d, 10.0);
        int[][][] nArray2 = SphereIterators.HalfSphereIteratorsIterator(d, dArray);
        int n = interpolatedImage.getWidth();
        int n2 = interpolatedImage.getHeight();
        int n3 = interpolatedImage.getDepth();
        IJ.showProgress((double)0.0);
        for (int i = n3 / 2; i < n3 / 2 + 1; ++i) {
            double[] dArray2 = new double[n * n2];
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n4;
                    double d2 = 0.0;
                    int[][] nArray3 = new int[2][this.maxBin + 1];
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        try {
                            int n5 = interpolatedImage.getNoInterpol(k + nArray[n4][0], j + nArray[n4][1], i + nArray[n4][2]);
                            int[] nArray4 = nArray3[SphereIterators.isUpperHalf(nArray[n4], dArray[0]) ? 0 : 1];
                            int n6 = n5;
                            nArray4[n6] = nArray4[n6] + 1;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (n4 = 0; n4 < nArray3[0].length; ++n4) {
                        d2 += measure.doit(nArray3[0][n4], nArray3[1][n4]);
                    }
                    double d3 = d2;
                    for (int i2 = 0; i2 < nArray2.length; ++i2) {
                        for (int i3 = 0; i3 < nArray2[i2].length; ++i3) {
                            int n7;
                            int n8 = interpolatedImage.getNoInterpol(k + nArray2[i2][i3][0], j + nArray2[i2][i3][1], i + nArray2[i2][i3][2]);
                            if (n8 == (n7 = interpolatedImage.getNoInterpol(k - nArray2[i2][i3][0], j - nArray2[i2][i3][1], i - nArray2[i2][i3][2]))) continue;
                            double d4 = measure.doit(nArray3[0][n8], nArray3[1][n8]) + measure.doit(nArray3[0][n7], nArray3[1][n7]);
                            int[] nArray5 = nArray3[0];
                            int n9 = n8;
                            nArray5[n9] = nArray5[n9] - 1;
                            int[] nArray6 = nArray3[1];
                            int n10 = n8;
                            nArray6[n10] = nArray6[n10] + 1;
                            int[] nArray7 = nArray3[0];
                            int n11 = n7;
                            nArray7[n11] = nArray7[n11] + 1;
                            int[] nArray8 = nArray3[1];
                            int n12 = n7;
                            nArray8[n12] = nArray8[n12] - 1;
                            double d5 = measure.doit(nArray3[0][n8], nArray3[1][n8]) + measure.doit(nArray3[0][n7], nArray3[1][n7]) - d4;
                            d2 += d5;
                        }
                        if (!(d2 > d3)) continue;
                        d3 = d2;
                    }
                    dArray2[k + n * j] = d3;
                }
                IJ.showProgress((double)(((double)j + 1.0) / (double)n2));
            }
            imageStack.addSlice("", (ImageProcessor)new FloatProcessor(n, n2, dArray2));
            IJ.showProgress((double)(((double)i + 1.0) / (double)n3));
        }
        IJ.showProgress((double)1.0);
    }

    private void line(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, double d) {
        float f;
        float f2 = Math.abs(n5 - n3);
        double d2 = f2 > (f = (float)Math.abs(n6 - n4)) ? f2 : f;
        for (double d3 = 0.0; d3 < d2; d3 += 1.0) {
            int n7 = (int)((double)n3 + (double)(n5 - n3) * d3 / d2);
            int n8 = (int)((double)n4 + (double)(n6 - n4) * d3 / d2);
            if (n7 < 0 || n8 < 0 || n7 >= n || n8 >= n2 || !(d > dArray[n7 + n8 * n])) continue;
            dArray[n7 + n8 * n] = d;
        }
    }

    private FloatProcessor doitWithSelection(ImageProcessor imageProcessor, Measure measure, double d, boolean bl) {
        return null;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    static class EdgeInformation {
        InterpolatedImage ii;
        Measure measure;
        MeasureWithNullModel nullMeasure;
        double radius;
        int maxBin;
        int numberOfBins;
        private PostProcessHistogram postProc;
        int slice;
        int[][] fullCircle;
        int[][] halfCircle;
        int[][] histograms;
        private int angleIndex;
        double[] angles;
        DirichletVarianceMutualInformation var = null;
        double maxMutInf = 1.0E-300;
        double maxVarMutInf = 1.0E-300;
        double maxMutInfRatio = 1.0E-300;
        int[][][] edgelets = null;
        double[] res3 = null;

        public EdgeInformation(ImagePlus imagePlus, Measure measure, double d, int n, int n2) {
            this(new InterpolatedImage(imagePlus), measure, d, n, n2);
            this.slice = imagePlus.getCurrentSlice() - 1;
        }

        public EdgeInformation(InterpolatedImage interpolatedImage, Measure measure, double d, int n, int n2) {
            this.ii = interpolatedImage;
            this.measure = measure;
            if (measure instanceof MeasureWithNullModel) {
                this.nullMeasure = (MeasureWithNullModel)measure;
            }
            this.radius = d;
            this.maxBin = n;
            this.numberOfBins = n2;
            this.histograms = new int[2][n + 1];
            this.fullCircle = CircleIterators.FullCircle(d, false);
            this.halfCircle = CircleIterators.SortedHalfCircle(d);
            int[][] nArray = CircleIterators.RightSickle(d);
        }

        void setPostProc(int n) {
            if (n != 0) {
                this.postProc = new PostProcessHistogram(n);
            }
        }

        void resetHistograms() {
            this.histograms = new int[2][this.maxBin + 1];
        }

        void calculateHistograms(int n, int n2, int n3) {
            this.resetHistograms();
            for (int i = 0; i < this.fullCircle.length; ++i) {
                int n4 = n + this.fullCircle[i][0];
                int n5 = n2 + this.fullCircle[i][1];
                int n6 = this.ii.getNoInterpol(n4, n5, n3);
                if (this.fullCircle[i][1] > 0 || this.fullCircle[i][1] == 0 && this.fullCircle[i][0] > 0) {
                    int[] nArray = this.histograms[0];
                    int n7 = n6;
                    nArray[n7] = nArray[n7] + 1;
                    continue;
                }
                int[] nArray = this.histograms[1];
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
            }
            if (this.postProc != null) {
                this.histograms = this.postProc.postProcessHisto(this.histograms);
                System.err.println("quantized for " + n + ", " + n2 + ", " + n3);
            }
        }

        void calculateHistograms(int n, int n2, int n3, double d, double d2) {
            this.resetHistograms();
            for (int i = 0; i < this.fullCircle.length; ++i) {
                int n4 = n + this.fullCircle[i][0];
                int n5 = n2 + this.fullCircle[i][1];
                int n6 = this.ii.getNoInterpol(n4, n5, n3);
                double d3 = (double)this.fullCircle[i][0] * d + (double)this.fullCircle[i][1] * d2;
                if (d3 > 0.0) {
                    int[] nArray = this.histograms[0];
                    int n7 = n6;
                    nArray[n7] = nArray[n7] + 1;
                    continue;
                }
                if (!(d3 < 0.0)) continue;
                int[] nArray = this.histograms[1];
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
            }
            if (this.postProc != null) {
                this.histograms = this.postProc.postProcessHisto(this.histograms);
            }
        }

        double getEdgeInformation(int n, int n2, double d, double d2) {
            return this.getEdgeInformation(n, n2, this.slice, d, d2);
        }

        double getEdgeInformation(int n, int n2, int n3, double d, double d2) {
            this.calculateHistograms(n, n2, n3, d, d2);
            double d3 = 0.0;
            for (int i = 0; i < this.histograms[0].length; ++i) {
                d3 += this.measure.doit(this.histograms[0][i], this.histograms[1][i]);
            }
            if (this.nullMeasure != null) {
                d3 += this.nullMeasure.getNormalize(this.fullCircle.length, this.numberOfBins);
                double d4 = 0.0;
                double d5 = 0.001;
                for (int i = 0; i < this.histograms[0].length; ++i) {
                    d4 += this.nullMeasure.doitNull(this.histograms[0][i], this.histograms[1][i]);
                }
                d4 += this.nullMeasure.getNormalizeNull(this.fullCircle.length, this.numberOfBins);
                d3 += Math.log(d5);
                d3 = Math.exp(d3 - (d4 += Math.log(1.0 - d5)));
            }
            return d3;
        }

        double getEdgeInformation(int n, int n2) {
            return this.getEdgeInformation(n, n2, this.slice);
        }

        double getEdgeInformation(int n, int n2, int n3) {
            this.calculateHistograms(n, n2, n3);
            double d = 0.0;
            for (int i = 0; i < this.histograms[0].length; ++i) {
                d += this.measure.doit(this.histograms[0][i], this.histograms[1][i]);
            }
            if (this.nullMeasure != null) {
                d += this.nullMeasure.getNormalize(this.fullCircle.length, this.numberOfBins);
            }
            double d2 = d;
            double d3 = d;
            double d4 = -1.0E300;
            this.angleIndex = 0;
            for (int i = 0; i < this.halfCircle.length; ++i) {
                int n4;
                int n5 = this.ii.getNoInterpol(n + this.halfCircle[i][0], n2 + this.halfCircle[i][1], n3);
                if (n5 != (n4 = this.ii.getNoInterpol(n - this.halfCircle[i][0], n2 - this.halfCircle[i][1], n3))) {
                    if (this.postProc != null && this.postProc.mapping != null) {
                        if ((n5 = this.postProc.mapping[n5]) < 0) {
                            n5 += 256;
                        }
                        if ((n4 = this.postProc.mapping[n4]) < 0) {
                            n4 += 256;
                        }
                    }
                    double d5 = this.measure.doit(this.histograms[0][n5], this.histograms[1][n5]) + this.measure.doit(this.histograms[0][n4], this.histograms[1][n4]);
                    int[] nArray = this.histograms[0];
                    int n6 = n5;
                    nArray[n6] = nArray[n6] - 1;
                    int[] nArray2 = this.histograms[1];
                    int n7 = n5;
                    nArray2[n7] = nArray2[n7] + 1;
                    int[] nArray3 = this.histograms[0];
                    int n8 = n4;
                    nArray3[n8] = nArray3[n8] + 1;
                    int[] nArray4 = this.histograms[1];
                    int n9 = n4;
                    nArray4[n9] = nArray4[n9] - 1;
                    double d6 = this.measure.doit(this.histograms[0][n5], this.histograms[1][n5]) + this.measure.doit(this.histograms[0][n4], this.histograms[1][n4]) - d5;
                    if ((d3 += d6) > d2) {
                        d2 = d3;
                        this.angleIndex = i;
                    }
                }
                d4 = LogFuncs.LogAddLogLog(d4, d3);
            }
            if (this.nullMeasure != null) {
                double d7 = 0.0;
                double d8 = 0.001;
                for (int i = 0; i < this.histograms[0].length; ++i) {
                    d7 += this.nullMeasure.doitNull(this.histograms[0][i], this.histograms[1][i]);
                }
                d7 += this.nullMeasure.getNormalizeNull(this.fullCircle.length, this.numberOfBins);
                d2 += Math.log(d8);
                d2 = Math.exp(d2 - LogFuncs.LogAddLogLog(d4 += Math.log(d8), d7 += Math.log(1.0 - d8)));
            }
            if (this.var != null) {
                this.calculateVariance(d2, n, n2);
            }
            if (this.edgelets != null) {
                this.drawEdgelet(d2, n, n2);
            }
            if (this.angles != null) {
                this.setAngle(n, n2);
            }
            return d2;
        }

        void setAngle(int n, int n2) {
            this.angles[n + n2 * this.ii.getWidth()] = Math.atan2(this.halfCircle[this.angleIndex][0], this.halfCircle[this.angleIndex][1]);
        }

        void calculateVariance(double d, int n, int n2) {
            double d2;
            double d3 = d;
            if (this.maxMutInf < d) {
                this.maxMutInf = d;
            }
            this.calculateHistograms(n, n2, this.slice);
            d = this.var.variance(this, n, n2, this.angleIndex);
            if (this.maxVarMutInf < d) {
                this.maxVarMutInf = d;
            }
            if (d3 != 0.0 && (d2 = Math.sqrt(d) / d3) > this.maxMutInfRatio) {
                this.maxMutInfRatio = d2;
            }
        }

        double getMaxVariance() {
            return _harmonic.get(4 * this.halfCircle.length) - _harmonic.get(2 * this.halfCircle.length) + 1.0 / (4.0 * (double)this.halfCircle.length) * this.maxMutInf;
        }

        void initEdgelets() {
            this.edgelets = CircleIterators.Edgelets(this.halfCircle, this.radius);
            this.res3 = new double[this.ii.getWidth() * this.ii.getHeight()];
        }

        void drawEdgelet(double d, int n, int n2) {
            for (int i = 0; i < this.edgelets[this.angleIndex].length; ++i) {
                int n3 = n + this.edgelets[this.angleIndex][i][0];
                int n4 = n2 + this.edgelets[this.angleIndex][i][1];
                if (n3 < 0 || n3 >= this.ii.getWidth() || n4 < 0 || n4 >= this.ii.getHeight() || !(this.res3[n3 + n4 * this.ii.getWidth()] < d)) continue;
                this.res3[n3 + n4 * this.ii.getWidth()] = d;
            }
        }

        void postLudium() {
            if (this.var != null) {
                double d = this.getMaxVariance();
                IJ.write((String)("maximal MutInf: " + d + ", maximal variance: " + this.maxVarMutInf + " (std. dev.: " + Math.sqrt(this.maxVarMutInf) + "), ratio: " + this.maxMutInfRatio));
            }
            if (this.res3 != null) {
                new ImagePlus("Edgelets", (ImageProcessor)new FloatProcessor(this.ii.getWidth(), this.ii.getHeight(), this.res3)).show();
            }
        }
    }

    static class EdgeInformation3d {
        InterpolatedImage image;
        Measure measure;
        MeasureWithNullModel nullMeasure;
        double radius;
        int[][] sphere;
        int[][] histograms;

        public EdgeInformation3d(ImagePlus imagePlus, Measure measure, double d) {
            this(new InterpolatedImage(imagePlus), measure, d);
        }

        public EdgeInformation3d(InterpolatedImage interpolatedImage, Measure measure, double d) {
            this.image = interpolatedImage;
            this.measure = measure;
            if (this.measure instanceof MeasureWithNullModel) {
                this.nullMeasure = (MeasureWithNullModel)this.measure;
            }
            this.radius = d;
            Calibration calibration = interpolatedImage.image.getCalibration();
            this.sphere = SphereIterators.SphereIterator(d, calibration.pixelWidth, calibration.pixelHeight, calibration.pixelDepth);
            this.histograms = new int[2][256];
        }

        void calculateHistograms(int n, int n2, int n3, double d, double d2, double d3) {
            for (int i = 0; i < this.sphere.length; ++i) {
                int[] nArray = this.sphere[i];
                double d4 = (double)nArray[0] * d + (double)nArray[1] * d2 + (double)nArray[2] * d3;
                if (d4 == 0.0) continue;
                int n4 = this.image.getNoInterpol(n + nArray[0], n2 + nArray[1], n3 + nArray[2]);
                int[] nArray2 = this.histograms[d4 > 0.0 ? 1 : 0];
                int n5 = n4;
                nArray2[n5] = nArray2[n5] + 1;
            }
        }

        void resetHistograms() {
            for (int i = 0; i < this.histograms[0].length; ++i) {
                this.histograms[1][i] = 0;
                this.histograms[0][i] = 0;
            }
        }

        double get(int n, int n2, int n3, double d, double d2, double d3) {
            this.resetHistograms();
            this.calculateHistograms(n, n2, n3, d, d2, d3);
            double d4 = 0.0;
            for (int i = 0; i < this.histograms[0].length; ++i) {
                d4 += this.measure.doit(this.histograms[0][i], this.histograms[1][i]);
            }
            if (this.nullMeasure != null) {
                d4 += this.nullMeasure.getNormalize(this.sphere.length, 256);
                double d5 = 0.0;
                double d6 = 0.001;
                for (int i = 0; i < this.histograms[0].length; ++i) {
                    d5 += this.nullMeasure.doitNull(this.histograms[0][i], this.histograms[1][i]);
                }
                d5 += this.nullMeasure.getNormalizeNull(this.sphere.length, 256);
                d4 += Math.log(d6);
                d4 = Math.exp(d4 - (d5 += Math.log(1.0 - d6)));
            }
            return d4;
        }
    }

    public static class PostProcessHistogram {
        int postProcessIndex;
        byte[] mapping;
        static final int postProcessWidth = 20;
        double[] pp2;

        public PostProcessHistogram(int n) {
            this.postProcessIndex = n;
            System.err.println("index: " + n);
        }

        public int[][] postProcessHisto(int[][] nArray) {
            if (this.postProcessIndex == 3) {
                MaxEntHistogram maxEntHistogram = new MaxEntHistogram(nArray);
                maxEntHistogram.quantize(4);
                this.mapping = maxEntHistogram.getMapping(true);
                return maxEntHistogram.get(nArray);
            }
            int[] nArray2 = this.postProcessHisto(nArray[0]);
            int[] nArray3 = this.postProcessHisto(nArray[1]);
            nArray[0] = nArray2;
            nArray[1] = nArray3;
            return nArray;
        }

        int[] postProcessHisto(int[] nArray) {
            int n;
            int n2 = nArray.length;
            int[] nArray2 = new int[n2];
            if (this.postProcessIndex == 2 && this.pp2 == null) {
                this.pp2 = new double[41];
                this.pp2[0] = 1.0;
                for (n = -19; n <= 20; ++n) {
                    this.pp2[n + 20] = this.pp2[n + 20 - 1] * (double)(41 - (n + 20)) / (double)(n + 20);
                }
            }
            for (n = 0; n < n2; ++n) {
                int n3;
                int n4 = n > 20 ? n - 20 : 0;
                int n5 = n3 = n < n2 - 1 - 20 ? n + 1 + 20 : n2 + 1 - 1;
                if (this.postProcessIndex == 1) {
                    for (int i = n4; i < n3; ++i) {
                        int n6 = n;
                        nArray2[n6] = nArray2[n6] + nArray[i];
                    }
                    int n7 = n;
                    nArray2[n7] = nArray2[n7] / (n3 - n4);
                    continue;
                }
                if (this.postProcessIndex != 2) continue;
                double d = 0.0;
                double d2 = 0.0;
                for (int i = n4; i < n3; ++i) {
                    double d3 = this.pp2[20 + i - n];
                    d += d3;
                    d2 += (double)nArray[i] * d3;
                }
                if (d2 < 0.0) {
                    throw new RuntimeException("result[" + n + "]=" + nArray2[n]);
                }
                nArray2[n] = (int)(d2 / d);
            }
            return nArray2;
        }
    }

    static class Dummy
    implements Measure {
        Dummy() {
        }

        public double doit(int n, int n2) {
            return n + n2;
        }
    }

    static class Euclidean
    implements Measure {
        Euclidean() {
        }

        public double doit(int n, int n2) {
            int n3 = n - n2;
            return n3 * n3;
        }
    }

    static class Jensen
    implements Measure {
        Jensen() {
        }

        public double doit(int n, int n2) {
            return n * n2;
        }
    }

    static class MutualInformation
    implements Measure {
        MutualInformation() {
        }

        public double doit(int n, int n2) {
            int n3 = n + n2;
            if (n3 == 0) {
                return 0.0;
            }
            double d = (double)(-n3) * Math.log(n3);
            if (n != 0) {
                d += (double)n * Math.log(n);
            }
            if (n2 != 0) {
                d += (double)n2 * Math.log(n2);
            }
            return d;
        }
    }

    static class DirichletVarianceMutualInformation
    extends DirichletMutualInformation {
        DirichletVarianceMutualInformation() {
        }

        public double variance(EdgeInformation edgeInformation, int n, int n2, int n3) {
            int n4;
            int[][] nArray = new int[2][edgeInformation.histograms[0].length];
            for (n4 = 0; n4 < edgeInformation.histograms[0].length; ++n4) {
                nArray[0][n4] = edgeInformation.histograms[0][n4];
                nArray[1][n4] = edgeInformation.histograms[1][n4];
            }
            for (n4 = 0; n4 <= n3; ++n4) {
                int n5;
                int n6 = edgeInformation.ii.getNoInterpol(n + edgeInformation.halfCircle[n4][0], n2 + edgeInformation.halfCircle[n4][1], edgeInformation.slice);
                if (n6 == (n5 = edgeInformation.ii.getNoInterpol(n - edgeInformation.halfCircle[n4][0], n2 - edgeInformation.halfCircle[n4][1], edgeInformation.slice))) continue;
                int[] nArray2 = nArray[0];
                int n7 = n6;
                nArray2[n7] = nArray2[n7] - 1;
                int[] nArray3 = nArray[1];
                int n8 = n6;
                nArray3[n8] = nArray3[n8] + 1;
                int[] nArray4 = nArray[0];
                int n9 = n5;
                nArray4[n9] = nArray4[n9] + 1;
                int[] nArray5 = nArray[1];
                int n10 = n5;
                nArray5[n10] = nArray5[n10] - 1;
            }
            double d = edgeInformation.halfCircle.length * 2;
            double d2 = 0.5;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = 0; i < nArray[0].length; ++i) {
                double d5;
                double d6 = nArray[0][i] + nArray[1][i];
                if (d6 == 0.0) continue;
                double d7 = nArray[0][i];
                if (d7 != 0.0) {
                    d5 = Math.log(d7 * d / d2 / d6);
                    d3 += d7 / d * d5 * d5;
                    d4 += d7 / d * d5;
                }
                if ((d7 = (double)nArray[1][i]) == 0.0) continue;
                d5 = Math.log(d7 * d / d2 / d6);
                d3 += d7 / d * d5 * d5;
                d4 += d7 / d * d5;
            }
            return (d3 - d4 * d4) / d;
        }
    }

    static class DirichletMutualInformation
    implements Measure {
        DirichletMutualInformation() {
        }

        public double doit(int n, int n2) {
            return (double)(-(n + 1)) * _harmonic.get(n + 1, n + n2 + 2) - (double)(n2 + 1) * _harmonic.get(n2 + 1, n + n2 + 2);
        }
    }

    static class Dirichlet
    implements Measure {
        Dirichlet() {
        }

        public double doit(int n, int n2) {
            return LogFuncs.LogFactorial(n) + LogFuncs.LogFactorial(n2) - LogFuncs.LogFactorial(n + n2 + 1);
        }
    }

    static class Endres
    implements Measure {
        Endres() {
        }

        public double doit(int n, int n2) {
            int n3 = n + n2;
            if (n3 == 0) {
                return 0.0;
            }
            double d = 0.0;
            if (n != 0) {
                d += (double)n * Math.log((double)n * 2.0 / (double)n3);
            }
            if (n2 != 0) {
                d += (double)n2 * Math.log((double)n2 * 2.0 / (double)n3);
            }
            return d;
        }
    }

    static class Dirichlet2
    implements MeasureWithNullModel {
        Dirichlet2() {
        }

        public double doit(int n, int n2) {
            return LogFuncs.LogFactorial(n) + LogFuncs.LogFactorial(n2);
        }

        public double doitNull(int n, int n2) {
            return LogFuncs.LogFactorial(n + n2);
        }

        public double getNormalize(int n, int n2) {
            return 2.0 * (LogFuncs.LogFactorial(n2) - LogFuncs.LogFactorial(n / 2 + n2));
        }

        public double getNormalizeNull(int n, int n2) {
            return LogFuncs.LogFactorial(n2) - LogFuncs.LogFactorial(n + n2);
        }
    }

    static interface MeasureWithNullModel
    extends Measure {
        public double doitNull(int var1, int var2);

        public double getNormalize(int var1, int var2);

        public double getNormalizeNull(int var1, int var2);
    }

    static interface Measure {
        public double doit(int var1, int var2);
    }
}

