/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import java.util.Vector;

public class SphereIterators {
    static final double EPSILON = 1.0E-15;

    public static double[][] SampleSphereSurface(double d, double d2) {
        return SphereIterators.SampleSphereSurface(d, d2, 1.0);
    }

    public static double[][] SampleSphereSurface(double d, double d2, double d3) {
        double d4 = Math.PI / (d2 /= d);
        double d5 = 4.0 * d4;
        int n = (int)(d5 * 1.0 / d2);
        double[][] dArray = new double[n][3];
        for (int i = 0; i < n; ++i) {
            double d6 = d2 * (double)i;
            double d7 = d3 * d4 / Math.PI * Math.acos(1.0 - d6 / 2.0 / d4 / d3) + 1.0E-15;
            dArray[i][0] = d * Math.sin(d7 / d3 * Math.PI / d4) * Math.cos(Math.PI * 2 * d7);
            dArray[i][1] = d * Math.sin(d7 / d3 * Math.PI / d4) * Math.sin(Math.PI * 2 * d7);
            dArray[i][2] = d3 * d * Math.cos(d7 / d3 * Math.PI / d4);
        }
        return dArray;
    }

    public static void printLandmarkSet(int[][] nArray) {
        double[][] dArray = new double[nArray.length][3];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = nArray[i][j];
            }
        }
        SphereIterators.printLandmarkSet(dArray);
    }

    public static void printLandmarkSet(double[][] dArray) {
        System.out.println("# HyperMesh 3D ASCII 1.0\n\ndefine Markers " + dArray.length + "\n" + "\n" + "Parameters {\n" + "\tContentType \"LandmarkSet\",\n" + "\tNumSets 1\n" + "}\n" + "\n" + "Markers { float[3] Coordinates }  @1\n" + "\n" + "# Data section follows^L\n" + "@1\n");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println(dArray[i][0] + " " + dArray[i][1] + " " + dArray[i][2]);
        }
        System.out.println();
    }

    public static boolean isUpperHalf(int[] nArray, double[] dArray) throws Exception {
        return SphereIterators.isUpperHalf(nArray[0], nArray[1], nArray[2], dArray);
    }

    public static boolean isUpperHalf(int n, int n2, int n3, double[] dArray) throws Exception {
        double d = (double)n * dArray[0] + (double)n2 * dArray[1] + (double)n3 * dArray[2];
        if (d == 0.0) {
            throw new Exception("Neither upper nor lower half!");
        }
        return d > 0.0;
    }

    public static int[][] SphereIterator(double d) {
        return SphereIterators.SphereIterator(d, 1.0);
    }

    public static int[][] SphereIterator(double d, double d2) {
        return SphereIterators.SphereIterator(d, 1.0, 1.0, d2);
    }

    public static int[][] SphereIterator(double d, double d2, double d3, double d4) {
        Vector<int[]> vector = new Vector<int[]>();
        double d5 = d * d;
        int n = (int)Math.floor(d / d4);
        for (int i = -n; i <= n; ++i) {
            double d6 = (double)i * d4;
            int n2 = (int)(Math.sqrt(d5 - d6 * d6) / d3);
            for (int j = -n2; j <= n2; ++j) {
                double d7 = (double)j * d3;
                int n3 = (int)(Math.sqrt(d5 - d6 * d6 - d7 * d7) / d2);
                int n4 = -n3;
                while (n4 <= n3) {
                    int[] nArray = new int[]{n4++, j, i};
                    vector.add(nArray);
                }
            }
        }
        int[][] nArray = new int[vector.size()][3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int[])vector.get(i);
        }
        return nArray;
    }

    static boolean isNull(int[] nArray) {
        return nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0;
    }

    public static int[][] HalfSphereIterator(double d, double[] dArray) {
        return SphereIterators.HalfSphereIterator(d, dArray, 1.0);
    }

    public static int[][] HalfSphereIterator(double d, double[] dArray, double d2) {
        Vector<int[]> vector = new Vector<int[]>();
        int[][] nArray = SphereIterators.SphereIterator(d, d2);
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (SphereIterators.isNull(nArray[i]) || !SphereIterators.isUpperHalf(nArray[i], dArray)) continue;
                vector.add(nArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[][] nArray2 = new int[vector.size()][3];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (int[])vector.get(i);
        }
        return nArray2;
    }

    public static int[][][] HalfSphereIteratorsIterator(double d, double[][] dArray) {
        return SphereIterators.HalfSphereIteratorsIterator(d, dArray, 1.0);
    }

    public static int[][][] HalfSphereIteratorsIterator(double d, double[][] dArray, double d2) {
        int n = dArray.length - 1;
        if (n < 0) {
            return new int[0][][];
        }
        int[][][] nArrayArray = new int[n][][];
        int[][] nArray = SphereIterators.SphereIterator(d, d2);
        for (int i = 0; i < dArray.length - 1; ++i) {
            int n2;
            Vector<int[]> vector = new Vector<int[]>();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                try {
                    if (SphereIterators.isUpperHalf(nArray[n2], dArray[i]) == SphereIterators.isUpperHalf(nArray[n2], dArray[i + 1])) continue;
                    vector.add(nArray[n2]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nArrayArray[i] = new int[vector.size()][3];
            for (n2 = 0; n2 < nArrayArray[i].length; ++n2) {
                nArrayArray[i][n2] = (int[])vector.get(n2);
            }
        }
        return nArrayArray;
    }

    static void put(boolean[][][] blArray, int n, int[] nArray, boolean bl) {
        blArray[n + nArray[0]][n + nArray[1]][n + nArray[2]] = bl;
    }

    static boolean get(boolean[][][] blArray, int n, int[] nArray) {
        return blArray[n + nArray[0]][n + nArray[1]][n + nArray[2]];
    }

    public static boolean testHalfSphereIteratorsIterator(double d, double[][] dArray) {
        int n;
        int n2 = (int)d;
        boolean[][][] blArray = new boolean[2 * n2 + 1][2 * n2 + 1][2 * n2 + 1];
        System.err.println("Building HalfSphereIterator");
        int[][] nArray = SphereIterators.HalfSphereIterator(d, dArray[0]);
        System.err.println("... returned " + nArray.length + " coordinates");
        System.err.println("Building Sphere");
        for (n = 0; n < nArray.length; ++n) {
            SphereIterators.put(blArray, n2, nArray[n], true);
            blArray[n2 - nArray[n][0]][n2 - nArray[n][1]][n2 - nArray[n][2]] = false;
        }
        System.err.println("Checking Sphere");
        for (n = 0; n < nArray.length; ++n) {
            if (SphereIterators.get(blArray, n2, nArray[n])) continue;
            System.err.println("Detected error in HalfSphereIterator");
            return false;
        }
        System.err.println("Building HalfSphereIteratorsIterator");
        int[][][] nArray2 = SphereIterators.HalfSphereIteratorsIterator(d, dArray);
        if (nArray2.length + 1 != dArray.length) {
            System.err.println("Wrong length of HalfSphereIteratorsIterator");
            return false;
        }
        System.err.println("... returned " + nArray2.length + " iterators");
        System.err.println("Checking HalfSphereIteratorsIterator");
        for (int i = 0; i < nArray2.length; ++i) {
            int n3;
            System.err.println("Applying " + i + " (" + nArray2[i].length + " coordinates)");
            for (n3 = 0; n3 < nArray2[i].length; ++n3) {
                SphereIterators.put(blArray, n2, nArray2[i][n3], !SphereIterators.get(blArray, n2, nArray2[i][n3]));
            }
            System.err.println("Building HalfSphereIterator");
            nArray = SphereIterators.HalfSphereIterator(d, dArray[i + 1]);
            System.err.println("Checking with HalfSphereIterator");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (SphereIterators.get(blArray, n2, nArray[n3])) continue;
                System.err.println("HalfSphereIteratorsIterator failed at " + i + ", " + n3);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("-landmarks")) {
            double[][] dArray = SphereIterators.SampleSphereSurface(100.0, 30.0);
            SphereIterators.printLandmarkSet(dArray);
            return;
        }
        double d = 10.0;
        double[][] dArray = SphereIterators.SampleSphereSurface(d, 5.0);
        SphereIterators.testHalfSphereIteratorsIterator(d, dArray);
    }
}

